/********************************************************************************
 *  Projektname         : AERO 
 *  Filename            : EinAus.c
 *  Filetyp             : Source
 ********************************************************************************
 *  Modulname           : EinAus
 *  Version             : 1.3.2
 *  letzte Aenderung    : Mittwoch, 21. August 1996, 16:41:55
 *  Autor               : Andreas Ziegler
 *  Status              : finished, only bugs will be fixed
 *
 *  Beschreibung:
 *
 *  Versionsgeschichte:
 *  15.02.93: Erstellungsdatum 
 *  15.02.93: Farbwerte werden nun auch abgespeichert.
 * -05.05.93: viele nderungen, Fileselectorbox, abspeichern von Sequenzen, ...
 *  11.10.93: Auswahl welche File's angezeigt werden sollen kommt hinzu.
 *  12.01.94: Write-,ReadKamera zum Lesen/Schreiben der Kameradaten des Anima-
 *            tionsfensters.
 *  04.02.94: Beseitigung eines Bugs beim Schreiben einer Datei
 *  03.03.94: bug fixed: while reading a sequence it happend with old scene-files
 *            that it became an endless-loop.
 *   9.11.94: The file selector did not disappear after selecting a file. Now
 *            fixed by using XFlush to enable the window manager to close the
 *            window. 
 ********************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/MenuButton.h>


#include <Xfwf/FileComp.h>
#include <Xfwf/ScrList.h>

#include <ctype.h>
#include <string.h>

#include "Welt.h"
#include "Editor.h"
#include "io.h"


   extern  void AnzeigeDarstellung();
   extern  void SelektAllButtons(TBoolean);
   extern  void DObjektEinfuegen();
   extern  void HighLight(TKoerper *);
   extern  void entferneWelt(TWelt **);
   extern  void KopiereWelt(TWelt **, TWelt *);
   extern  void toggleNOStatus(TBoolean);



static Widget BD_Shell, BD_Selector, BD_label;
static TIORoutine IORoutine;



/*******************************************************************************
 *  void maxId(TWelt *Welt) 
 *  TWelt *Welt: Zeiger auf eine Momentaufnahme der Welt.
 *
 *  Beschreibung:
 *  -------------
 *  Die Routine sucht das Maximum der KoerperId. Die Routine ist deshalb not-
 *  wendig, weil die Routine zum Einlesen der Krperdaten diesen Wert nicht 
 *  bercksichtigt. Damit die Krperdeskriptoren eindeutig bleiben, wird das 
 *  Maximum gesucht.
 ********************************************************************************/

void maxId(TWelt *Welt)
{
   TKoerper *help, *help2;

   help = Welt->Welt.Koerper;
   while(help != NULL)
   {
      if(help->KoerperId > KoerperId)
	 KoerperId = help->KoerperId;
      if(help->Art == ZUSGESOBJ)
      {
	 help2 = help->Form.ZusGesObj.KoerperListe;
	 while(help2 != NULL)
	 {      
	    if(help2->KoerperId > KoerperId)
	       KoerperId = help2->KoerperId;
	    help2 = help2->Naechster;
	 }
      }
      help = help->Naechster;
   }
}


/*******************************************************************************
 *  TBoolean WriteKamera (TKamera Kamera, FILE *handle)
 *
 *  TKamera Kamera: Kameradaten, die gespeichert werden.
 *  FILE *handle  : Datei, in der die Kameradaten abgespeichert werden
 *
 *  Beschreibung:
 *  -------------
 *  Die Kameradaten haben folgendes Format:
 *    K                            # markiert, da nun Kameradaten folgen
 *    p <Kameraposition (3*TReal)> # Positionsangabe (absolut)
 *    z <Zoom (TReal)>             # Zoomfaktor
 *    r <Richtung (Quaternion)>    # Richtungsquaternion wird abgespeichert
 *    m <Eindeutige Objektnummer>  # Wenn die Kamera an ein Objekt gemountet wur-
 *                                 # de, wird die Objektnummer sowie die
 *    o <Offset (3*TReal)>         # Verschiebung der Kamera zum Objekt gespeichert.
 *    Q                            # Ende der Kameradaten
 ********************************************************************************/

TBoolean WriteKamera (TKamera Kamera, FILE *handle)
{
     if (fprintf(handle,"K\n") < 0)
	  return (FALSE);
     if (fprintf (handle,"p %f %f %f\n", Kamera.Position[0], Kamera.Position[1], 
		  Kamera.Position[2]) < 0)
	  return (FALSE);
     if (fprintf (handle,"r %f %f %f %f\n", Kamera.Richtung[0], Kamera.Richtung[1], 
		  Kamera.Richtung[2], Kamera.Richtung[3]) < 0)
	  return (FALSE);
     if (fprintf (handle,"z %f\n", Kamera.Zoom) < 0)
	  return (FALSE);
     if (Kamera.MountObj != NULL)
     {
	  if (fprintf (handle,"m %ld\n", Kamera.MountObjId) < 0)
	       return (FALSE);
	  if (fprintf (handle,"o %f %f %f\n", Kamera.Offset[0], Kamera.Offset[1], 
		       Kamera.Offset[2]) < 0)
	       return (FALSE);
     }
     if (fprintf (handle,"Q\n") < 0)
	  return (FALSE);
     return (TRUE);
}


TBoolean WriteWelt (TWelt *Welt, FILE *handle, TBoolean writeEof)
{
     TKonfigFBB Konfig;
     
     if (fprintf (handle,"W\n") < 0)
	  return (FALSE);
     if (WriteKamera (AnimKamera, handle) == FALSE)
	  return (FALSE);
     if (WriteMaterialien(Welt->Welt.MaterialDaten, NULL, handle) == FALSE)
	  return (FALSE);
     ErfrageKonfigFBB (&Konfig);
     if (WriteKonfiguration (&Konfig, NULL, handle) == FALSE)
	  return (FALSE);
     if (fprintf (handle,"i %.2f\n", 1.0/ZeitIncrement) < 0)
	  return (FALSE);
     if (WriteZustand (&Welt->Welt, NULL, handle))
	  if (writeEof)
	       if (fprintf(handle,"\nY\n") < 0)
	       {
		    printf ("Some error occured while writing sensitive data!\n");
		    return (FALSE);
	       }
	       else return (TRUE);
	  else if (fprintf(handle,"\nX\n") < 0)
	  {
	       printf ("Some error occured while writing sensitive data!\n");
	       return (FALSE);
	  }
	  else return (TRUE); 
     else return (FALSE);
     return (TRUE);
}



/* liest das naechste Zeichen aus (fh) welches kein Zwischenraumzeichen ist
 * und gibt es als Rueckgabewert zur"uck."
 */
static int ReadCode(FILE *handle)
{
     int c;
     
     do 
     {
	  c = fgetc(handle);
	  if (c == '#') 
	       do 
		    c = fgetc(handle); 
	       while(c != EOF && c != '\n' && c != '\r');
     } while(isspace(c));
     return c;
}


void ReadKamera (FILE *handle)
{
   int c;
   TKamera MyCamera;

   MyCamera.Richtung[0] = 1.0;
   MyCamera.Richtung[1] = 0.0;
   MyCamera.Richtung[2] = 0.0;
   MyCamera.Richtung[3] = 0.0;
   MyCamera.Zoom = 1.0;
   MyCamera.MountObj = NULL;
   MyCamera.Offset[0] = 0.0;
   MyCamera.Offset[1] = 0.0;
   MyCamera.Offset[2] = 0.0;
/*   MyCamera.MountObjId = 0; */
   do
   {
      c = ReadCode (handle);
      if (c == 'm')               /* The camera is mounted to an object. */
      {
	 fscanf (handle,"%ld", &MyCamera.MountObjId);
	 MyCamera.MountObj = 0x1; /* this indicates, that the camera is
				     mounted to an object. We can't set the
				     pointer to this object at the moment,
				     because there is no object list yet.
				     The MountObjId is a unique index to
				     find this object lateron. */
	 MyCamera.Offset[0] = 0.0;
	 MyCamera.Offset[1] = 0.0;
	 MyCamera.Offset[2] = 0.0;
      }
      else if (c == 'z')          /* Zoom value of camera. */
      {
	 fscanf (handle,"%lf", &MyCamera.Zoom);
      }
      else if (c == 'o')          /* Offset of the camera regarding the mounted object. */
      {
	 fscanf (handle,"%lf%lf%lf", &MyCamera.Offset[0], &MyCamera.Offset[1], 
		                     &MyCamera.Offset[2]);
      }
      else if (c == 'p')          /* Global position */
      {
	 fscanf (handle,"%lf%lf%lf", &MyCamera.Position[0], &MyCamera.Position[1], 
		                     &MyCamera.Position[2]);
      }
      else if (c == 'r')          /* Quaternion: indicates in which directions */
				  /* the camera is looking. */
      {
	 fscanf (handle,"%lf%lf%lf%lf", &MyCamera.Richtung[0], &MyCamera.Richtung[1], 
		                        &MyCamera.Richtung[2], &MyCamera.Richtung[3] );
      }
   } while (c != 'Q');

   /* Jetzt sollte noch geprft werden, ob ein Fehler auftrat ..., erst dann sollten die
      neuen Kameradaten bernommen werden. */

   AnimKamera = MyCamera;
}

 
TBoolean ReadWelt(TWelt **Welt, FILE *handle)
{
   int c;
   TZustand *MeineWelt = NULL;
   TBoolean RueckRZ;
   TKonfigFBB Konfig;
   double getInc;

   if (AnimKamera.MountObj != NULL)
   {
	AnimKamera.MountObj = NULL;
	AnimKamera.MountObjId = 0;
   }
   *Welt = (TWelt *) malloc(sizeof(TWelt));
   SpeicherFrei(*Welt);
   (*Welt)->Welt.MaterialDaten = NULL;
   c = ReadCode(handle);
   if(c == 'W')
      do
      {
	 c = ReadCode(handle);
	 if(ferror(handle)) 
	 {
	    fprintf(stderr, "Lese-Fehler\n");
	    return(FALSE);
	 }
	 if(c == 'f')
	    fscanf(handle,"%ld", &(*Welt)->FrameCounter);
	 else if(c == 's')
	    fscanf(handle,"%hu", (unsigned short *)&(*Welt)->SzenenAnfang);
	 else if(c == 'Z')
	 {
	    ungetc(c, handle);
	    RueckRZ = ReadZustand(&MeineWelt, (*Welt)->Welt.MaterialDaten, NULL, handle);
	    if(MeineWelt != NULL) 
	    {
	       (*Welt)->Welt = *MeineWelt;
	       free(MeineWelt);
	    }
	    return RueckRZ;
	 }
	 else if(c == 'M')
	 {
	    ungetc(c, handle);
	    if(!ReadMaterialien(&(*Welt)->Welt.MaterialDaten, NULL, handle))
	       return(FALSE);
	 }
	 else if(c == 'P')
	 {
	    ungetc(c, handle);
	    if(!ReadKonfiguration(&Konfig, NULL, handle))
	       return(FALSE);
	    KonfigFBB(&Konfig);
	 }
	 else if(c == 'i')
	 {
	    fscanf(handle,"%lf", &getInc);
	    ZeitIncrement = (TReal)1.0/getInc;
	 }
	 else if (c == 'K')
	    ReadKamera (handle);
      } while(1);
   else fprintf(stderr,"That's probably not a xaero-file!\n");
   return(FALSE);
}


void SchreibeAktuellenZustand(char *Path)
{
     FILE *handle;

     handle = fopen (Path,"w");
     if (handle == NULL)
	  fprintf (stderr,"could not open file: %s\n", Path);
     else if (WriteWelt (aktuelleWelt, handle, TRUE) == FALSE)
	  fprintf(stderr,"some errors occoured while writing sensitive data!\n");
     else fclose (handle);
}


void LeseAktuellenZustand(char *Path, TBoolean noBatch)
{
     TWelt *Welt;
     FILE  *handle;

     handle = fopen(Path,"r");
     if (handle == NULL)
	  fprintf (stderr,"could not open file: %s\n", Path);
     else if( ReadWelt (&Welt, handle) == FALSE)
	  fprintf(stderr,"some errors occoured while reading sensitive data!\n");
     else 
     {
	  Welt->prevSync = aktuelleWelt->prevSync;
	  Welt->nextSync = aktuelleWelt->nextSync;
	  Welt->thisSync = aktuelleWelt->thisSync;
	  Welt->FrameCounter = aktuelleWelt->FrameCounter;
	  Welt->SzenenAnfang = aktuelleWelt->SzenenAnfang;
	  Welt->Welt.Zeit = aktuelleWelt->Welt.Zeit;
	  entferneWelt(&aktuelleWelt);
	  aktuelleWelt = Welt;
	  maxId (aktuelleWelt);
	  selektiertesObjekt = aktuelleWelt->Welt.Koerper;
	  if (noBatch)
	       if (selektiertesObjekt != NULL)
	       {
		    MaterialienListe = (String *) MaterialNamen (aktuelleWelt->Welt.MaterialDaten); 
		    XfwfScrolledListSetList (NO_Material, MaterialienListe, 0, TRUE, NULL);
		    HighLight (selektiertesObjekt);
		    SelektAllButtons (TRUE);
		    DObjektEinfuegen ();
	       }
	       else
	       {
		    SelektAllButtons (FALSE);
		    XtSetSensitive (EM_neuesObjekt, TRUE);
		    toggleNOStatus (FALSE);
		    AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
					EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
					DZoomFaktor, &aktuelleWelt->Welt, 
					KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
	       }
	  fclose (handle);
     }
}   


void SchreibeSequenz(char *Path)
{
     FILE *handle;
     TWelt *help;

     handle = fopen (Path,"w");
     if (handle == NULL)
	  fprintf(stderr,"could not open file: %s\n", Path);
     else
     {
	  help = firstSync;
	  if (help != NULL)
	  {
	       if (help->nextSync != NULL)
		    WriteWelt (help, handle, FALSE);
	       else 
	       {
		    WriteWelt (help, handle, TRUE);
		    return;
	       }
	       help = help->nextSync;
	  }
	  else
	       return;
	  while (help != NULL)
	  {
	       if (!WriteZustand (&help->Welt, NULL, handle))
	       {
		    printf ("Some error occured while writing sensitive data!\n");
		    return;
	       }
	       if (help->nextSync != NULL)
	       {
		    if (fprintf (handle,"\nX\n") < 0)
		    {
			 printf ("Some error occured while writing sensitive data!\n");
			 return;
		    }
	       }
	       else
	       {
		    if (fprintf (handle,"\nY\n") < 0)
		    {
			 printf ("Some error occured while writing sensitive data!\n");
			 return;
		    }
	       }
	       help = help->nextSync;
	  }
	  fclose (handle);
     }
}


void LeseSequenz(char *Path, TBoolean batch)
{
   int c;
   TZustand *MeineWelt = NULL;
   TBoolean RueckRZ;
   TWelt *help = NULL, *help2 = NULL;
   FILE  *handle;
   double getInc;
   TKonfigFBB Konfig;

   handle = fopen(Path,"r");
   if(handle == NULL)
      fprintf(stderr,"could not open file: %s\n", Path);
   else 
   {
      while(firstSync != NULL) 
      { 	 
	 help2 = firstSync; 	
	 firstSync = help2->nextSync; 	 
	 entferneWelt(&help2); 
      } 
      lastSync = NULL;
      help = (TWelt *) malloc(sizeof(TWelt)); 
      SpeicherFrei(help);
      help->nextSync = NULL; 
      help->prevSync = NULL;
      help->SzenenAnfang = TRUE; 
      help->FrameCounter = 1; 
      firstSync = help; 
      help->Welt.MaterialDaten = NULL; 
      c = ReadCode(handle); 
      if(c == 'W') 
      { 	 
	 c = ReadCode(handle); 	 
	 ungetc(c, handle);
	 do 	 
	 { 	 
	    c = ReadCode(handle); 	 
	    if(ferror(handle)) 	 
	    { 	 
	       fprintf(stderr, "read error\n");
	       lastSync = help->prevSync;
	       if(lastSync != NULL)
		  lastSync->nextSync = NULL;
	    } 	 
	    if(c == 'f') 	 
	       fscanf(handle,"%ld", &help->FrameCounter); 	 
	    else if(c == 's') 	
	       fscanf(handle,"%hu", (unsigned short *)&help->SzenenAnfang);
	    else if(c == 'Z') 	 
	    { 	 
	       ungetc(c, handle); 	 
	       RueckRZ = ReadZustand(&MeineWelt, help->Welt.MaterialDaten, NULL, handle);
	       if(MeineWelt != NULL)
	       { 		 
		  help->Welt = *MeineWelt;
		  free(MeineWelt);
	       } 	
	    }
	    else if(c == 'X') 	 
	    { 
	       maxId(help);
	       help2 = help; 
	       help = (TWelt *) malloc(sizeof(TWelt)); 	 
	       SpeicherFrei(help);
	       help->prevSync = help2; 
	       help2->nextSync = help;
	       help->nextSync = NULL;
	       help->SzenenAnfang = TRUE;
	       help->FrameCounter = help2->FrameCounter+1;
	       help->Welt.MaterialDaten = firstSync->Welt.MaterialDaten; 
	    } 
	    else if(c == 'i')
	    {
	       fscanf(handle,"%lf", &getInc);
	       ZeitIncrement = (TReal)1.0/getInc;
	    }
	    else if(c == 'P')
	    {
	       ungetc(c, handle);
	       if(!ReadKonfiguration(&Konfig, NULL, handle))
		  return;
	       KonfigFBB(&Konfig);
	    }
	    else if(c == 'M') 	 
	    {
	       ungetc(c, handle);
	       ReadMaterialien(&help->Welt.MaterialDaten, NULL, handle);
	    }
	    else if (c == 'K')
		 ReadKamera (handle);

	 } while ((c != 'Y') && (!feof (handle))); 
	 lastSync = help; 
	 KopiereWelt(&aktuelleWelt, firstSync);
	 selektiertesObjekt = aktuelleWelt->Welt.Koerper;
	 if(!batch)
	    if(selektiertesObjekt != NULL)
	    {
	       MaterialienListe = (String *) MaterialNamen(aktuelleWelt->Welt.MaterialDaten);
	       XfwfScrolledListSetList(NO_Material, MaterialienListe, 0, TRUE, NULL);
	       HighLight(selektiertesObjekt);
	       SelektAllButtons(TRUE);
	       DObjektEinfuegen();
	    }
      } 
      else 
	 fprintf(stderr,"That's probably not a xaero-file!\n"); 
   } 
}


void PopDownSeq (Widget w, XtPointer garbage, XtPointer data)
{
     XtPopdown(BD_Shell);
     XFlush (XtDisplay (topLevel));
}


void RufeIOAktion (Widget w, XtPointer garbage, XtPointer data)
{
     switch (IORoutine)
     {
       case schreibeAkt: 
	  SchreibeAktuellenZustand ((char *) data);
	  break;
       case leseAkt: 
	  LeseAktuellenZustand ((char *) data, TRUE);
	  break;
       case schreibeMat: 
	  WriteMaterialien (aktuelleWelt->Welt.MaterialDaten, (char *) data, NULL);
	  break;
       case leseMat: 
	  ReadMaterialien (&aktuelleWelt->Welt.MaterialDaten, (char *) data, NULL);
	  MaterialienListe = (String *) MaterialNamen (aktuelleWelt->Welt.MaterialDaten);
	  XfwfScrolledListSetList (NO_Material, MaterialienListe, 0, TRUE, NULL);
	  break;
       case schreibeSeq: 
	  SchreibeSequenz ((char *) data);
	  break;
       case leseSeq: 
	  LeseSequenz ((char *) data, FALSE);
	  break;
     }
}


void KeineIOAktion (Widget w, XtPointer garbage, XtPointer muell)
{
     XtPopdown (BD_Shell);
}


void initBestimmeDateiname (Widget w, XtPointer Routine, XtPointer muell)
{
     IORoutine = (TIORoutine) Routine;
     switch (IORoutine)
     {
       case leseMat: 
	  XtVaSetValues (BD_label, XtNlabel,"... to read a table of materials", NULL);
	  break;
       case schreibeMat: 
	  XtVaSetValues (BD_label, XtNlabel,"... to write a table of materials", NULL);
	  break;
      case leseAkt: 
	  XtVaSetValues (BD_label, XtNlabel,"... to read new world-data", NULL);
	  break;
      case schreibeAkt: 
	  XtVaSetValues (BD_label, XtNlabel,"... to write world-data", NULL);
	  break;
      case leseSeq: 
	  XtVaSetValues (BD_label, XtNlabel,"... to read a sequence", NULL);
	  break;
      case schreibeSeq: 
	  XtVaSetValues (BD_label, XtNlabel,"... to write a sequence", NULL);
	  break;
     }
     XfwfFileCompleteTrimToPath (BD_Selector);
     XfwfFileCompleteForceRescan (BD_Selector); 
     XtPopup (BD_Shell, XtGrabExclusive);
}


/********************************************************************************
 *  Diese Routine wurde komplett aus FileCompT.c bernommen. Sie sendet an den 
 *  FileManager eine Nachricht, da die entsprechenden Files eingeblendet, bzw 
 *  ausgeblendet werden sollen.
 ********************************************************************************/

void change_file_proc(Widget w, XtPointer client_data, XtPointer muell)
{
   XtVaSetValues(BD_Selector, XtNacceptableFilenameProc, client_data, NULL);
}


/********************************************************************************
 *  Diese Routine wurde komplett aus FileCompT.c bernommen. Sie richtet fr 
 *  jeden Eintrag in ein Men ein Widget und die entsprechende Callbackroutine 
 *  ein.                                                                       
 ********************************************************************************/

void add_file_proc(Widget parent, char *label, XfwfFCAcceptableFilenameProc proc)
{
   Widget temp;

   temp = XtVaCreateManagedWidget("entry", smeBSBObjectClass, parent, XtNlabel, label, NULL);
   XtAddCallback(temp, XtNcallback, change_file_proc, proc);
}


void installBestimmeDateiname(void)
{
   Widget BD_paned, BD_Auswahl, BD_Menu;
   
   BD_Shell = XtVaCreatePopupShell("Select a filename", topLevelShellWidgetClass, topLevel, NULL);
   BD_paned = XtVaCreateManagedWidget("BD_paned", panedWidgetClass, BD_Shell, NULL);
   BD_label = XtVaCreateManagedWidget("BD_label", labelWidgetClass, BD_paned, NULL);
   BD_Selector = XtVaCreateManagedWidget("BD_Selector", xfwffileCompleteWidgetClass, 
					 BD_paned, NULL);
   XtAddCallback(BD_Selector, XtNcallback, PopDownSeq, NULL);
   XtAddCallback(BD_Selector, XtNcallback, RufeIOAktion, NULL);
   XtAddCallback(BD_Selector, XtNcancelCallback, KeineIOAktion, NULL);

   /*****************************************************************************
    * Der folgende Abschnitt wurde dem Testprogramm des FileComp (FileCompT.c)  *
    * entnommen und nur dem Programm angepat.                                 *
    *****************************************************************************/
   BD_Auswahl = XtVaCreateManagedWidget("BD_Auswahl", menuButtonWidgetClass, BD_paned, NULL);
   BD_Menu = XtVaCreatePopupShell("BD_Menu", simpleMenuWidgetClass, BD_Auswahl, NULL);
   add_file_proc(BD_Menu, "any", NULL);
   add_file_proc(BD_Menu, "no .files", XfwfFCNoDotFiles);
   add_file_proc(BD_Menu, "no tilde backups", XfwfFCNoTildeBackups);
   add_file_proc(BD_Menu, "no tilde backups or .files", XfwfFCNoTildeBackupsOrDotFiles);
}

