/********************************************************************************
 *  Projektname:	AERO
 *  Filename:		HilfsRoutinen.c
 *  Filetyp:		Modul
 ********************************************************************************
 *  Modulname:		HilfsRoutinen.c
 *  Version:		1.0
 *  letzte Aenderung:	Dienstag, 20. August 1996, 18:53:13
 *  Autor:  		Andreas 
 *  Status:		finished, only bugs will be fixed
 *										
 *  imp. Bezeichner:	
 * 
 *  exp. Bezeichner:
 *  										
 *  Beschreibung:								
 *  -------------								
 *										
 *  Fehler:
 *  -------
 *
 *  Versionsgeschichte:								
 *  -------------------
 *   18.01.93: Da Hartmut bisher noch keine Routine zum selektieren von Objekten
 *             per Maus geschrieben hat, wurde die Routine 'SucheVerbindungen'
 *             geschrieben. Sie fgt Zeiger auf alle Koerper der aktuellen
 *             Welt in eine Liste ein.
 *    9.11.94: implemented the conversion from the RGB-colortable to HSV and the
 *             other way round.
 ********************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xfwf/ScrList.h>

#include "Welt.h"
#include "Editor.h"

/********************************************************************************
 *  global definierte Variablen, die in diesem Modul bentigt werden.
 ********************************************************************************/


void SelektAllButtons (TBoolean Wert)
{
     XtSetSensitive (EM_neuesObjekt, Wert);
     if (Wert)
     {
	  if (selektiertesObjekt != NULL)
	  {
	       XtSetSensitive (EM_entferneObjekt, TRUE);
	       XtSetSensitive (EM_angreifKraft, TRUE);
	       /*	 XtSetSensitive (EM_veraenderKraft, TRUE); */
	       XtSetSensitive (EM_selektObjekt, TRUE);
	       XtSetSensitive (EM_copyObject, TRUE);
	       XtSetSensitive (EM_selektFirst, TRUE);
	       XtSetSensitive (EM_selectNGroup, TRUE);
	       XtSetSensitive (EM_gotoAnimation, TRUE);
	       XtSetSensitive (EM_entbindeKamera, TRUE);
	       XtSetSensitive (EM_bindeKamera, TRUE);
	       XtSetSensitive (EM_loescheKraefte, TRUE);
	       XtSetSensitive (EM_Gruppe, TRUE);
	       XtSetSensitive (EM_loeseGruppe, TRUE);
	  }
	  else
	       XtSetSensitive (EM_copyObject, FALSE);
	  if (aktuelleWelt->Welt.Verbindungen != NULL)
	  {
	       XtSetSensitive (EM_entferneVerb, Wert);
	       XtSetSensitive (EM_aenderVerb, Wert);
	  }
	  if (aktuelleWelt->Welt.Koerper != NULL && 
	      aktuelleWelt->Welt.Koerper->Naechster != NULL)
	       XtSetSensitive (EM_Verbindung, TRUE);
     }
     else
     {
	  XtSetSensitive (EM_selektObjekt, FALSE);
	  XtSetSensitive (EM_copyObject, FALSE);
	  XtSetSensitive (EM_selectNGroup, FALSE);
	  XtSetSensitive (EM_selektFirst, FALSE);
	  XtSetSensitive (EM_gotoAnimation, FALSE);
	  XtSetSensitive (EM_entferneObjekt, FALSE);
	  XtSetSensitive (EM_Verbindung, FALSE);
	  XtSetSensitive (EM_angreifKraft, FALSE);
	  /*      XtSetSensitive (EM_veraenderKraft, FALSE); */
	  XtSetSensitive (EM_entferneVerb, FALSE);
	  XtSetSensitive (EM_aenderVerb, FALSE);
	  XtSetSensitive (EM_bindeKamera, FALSE);
	  XtSetSensitive (EM_entbindeKamera, FALSE);
	  XtSetSensitive (EM_loescheKraefte, FALSE);
	  XtSetSensitive (EM_Gruppe, FALSE);
	  XtSetSensitive (EM_loeseGruppe, FALSE);
     }
}


void toggleNOStatus (TBoolean Wert)
{
   XtVaSetValues (NO_Param1, XtNstring,"              ", NULL);
   XtVaSetValues (NO_Param2, XtNstring,"              ", NULL);
   XtVaSetValues (NO_Param3, XtNstring,"              ", NULL);
   XtVaSetValues (NO_Pos_X,  XtNstring,"              ", NULL);
   XtVaSetValues (NO_Pos_Y,  XtNstring,"              ", NULL);
   XtVaSetValues (NO_Pos_Z,  XtNstring,"              ", NULL);
   XtSetSensitive (NO_GravLos, Wert);
   XtSetSensitive (NO_MasseLos, Wert);
   XtSetSensitive (NO_Apply, Wert);
   XtSetSensitive (NO_Undo, Wert);
   XtSetSensitive (NO_Pos_X, Wert);
   XtSetSensitive (NO_Pos_Y, Wert);
   XtSetSensitive (NO_Pos_Z, Wert);
   XtSetSensitive (NO_Param1, Wert);
   XtSetSensitive (NO_Param2, Wert);
   XtSetSensitive (NO_Param3, Wert);
   XtSetSensitive (NO_ScrollRot, Wert);
   XtSetSensitive (NO_ScrollGruen, Wert);
   XtSetSensitive (NO_ScrollBlau, Wert);
   XtSetSensitive (NO_Scroll_H, Wert);
   XtSetSensitive (NO_Scroll_S, Wert);
   XtSetSensitive (NO_Scroll_V, Wert);
/*   XtSetSensitive (NO_Material, Wert);*/
   XtSetSensitive (NO_rotXP, Wert);
   XtSetSensitive (NO_rotXM, Wert);
   XtSetSensitive (NO_rotYP, Wert);
   XtSetSensitive (NO_rotYM, Wert);
   XtSetSensitive (NO_rotZP, Wert);
   XtSetSensitive (NO_rotZM, Wert);
   XtSetSensitive (NO_ResetRot, Wert);
   XtSetSensitive (NO_movXP, Wert);
   XtSetSensitive (NO_movXM, Wert);
   XtSetSensitive (NO_movYP, Wert);
   XtSetSensitive (NO_movYM, Wert);
   XtSetSensitive (NO_movZP, Wert);
   XtSetSensitive (NO_movZM, Wert);
   XtSetSensitive (NO_ResetMov, Wert);
   XtSetSensitive (NO_neuesMat, Wert);
   XtSetSensitive (NO_showMat, Wert);
   XfwfScrolledListUnhighlightAll (NO_Material);
   if (selektiertesObjekt != NULL)
      XtSetSensitive (EM_ladeMatTab, FALSE);
   else
   {
      XtSetSensitive (EM_ladeMatTab, TRUE);
      XtSetSensitive (NO_showMat, FALSE);
   }
   if (!Wert)
      XtVaSetValues (NO_ObjektInfo, XtNlabel, "no object selected", NULL);
}



/*******************************************************************************
 *  void UeberpruefeWert (TReal *Wert, Widget NO_Param)
 *  TReal *Wert: Zeiger auf einen Wert vom Typ TReal. Der Wert wird als Zeiger 
 *               "ubergeben, damit man den Wert gegebenenfalls ab"andern kann.
 *  Widget NO_Param: Widget zum zugeh"origen Wert.
 *
 *  Beschreibung:
 *  -------------
 *  Die Routine "uberpr"uft den "ubergebenen Wert, ob er gr"o"ser oder gleich 
 *  Null ist. Diese Werte d"urfen bei der Folgeschrittberechnung nicht vorkommen,
 *  denn dort sorgen sie f"ur das Entstehen von einem schwerwiegenden Fehler, der 
 *  zum Abbruch des Programms fhren wrde (Division durch 0).
 ********************************************************************************/

void UeberpruefeWert (TReal *Wert, Widget NO_Param)
{
     char *trans = malloc (20*sizeof (char));

     if (*Wert < 0.0)
     {
	  *Wert = -*Wert;
	  fprintf (stderr, "No values below or equal 0.0 allowed!\n");
     }
     else if (*Wert == 0.0)
	  *Wert = 0.01;
     sprintf (trans, "%.3f", *Wert);
     XtVaSetValues (NO_Param, XtNstring, trans, NULL);
}


/*******************************************************************************
 *  
 *  Typ1 Parameter1 Beschreibung
 *  Typ2 Parameter2 Beschreibung
 *
 *  Fehler:  (Beschreibung evtl. Fehlerwerte im Resultatsparameter)
 *
 *  Beschreibung:
 *  -------------
 *  
 ********************************************************************************/

TBoolean convert_RGB_HSV (long R, long G, long B, TReal *H, TReal *S, TReal *V)
{
     TReal l_min, l_max, r, g, b, delta;

     r = ((TReal)R)/65535.0;
     g = ((TReal)G)/65535.0;
     b = ((TReal)B)/65535.0;
     l_max = max(max(r,g),max(g,b));
     l_min = min(min(r,g),min(g,b));

     *V = l_max;
     if (l_max != 0.0)
	  *S = (l_max - l_min)/l_max;
     else
	  *S = 0.0;
     if (*S == 0.0)
	  return (FALSE);
     {
	  delta = l_max - l_min;
	  if (r == l_max)
	       *H = (g - b)/delta;
	  else if (g == l_max)
	       *H = 2 + (b - r)/delta;
	  else 
	       *H = 4 + (r - g)/delta;
	  *H *= 60.0;
	  if (*H < 0.0)
	       *H += 360.0;
	  *H /= 360.0;
     }
     return (TRUE);
}


void convert_HSV_RGB (TReal H, TReal S, TReal V, TReal *R, TReal *G, TReal *B)
{
     int    i;
     TReal  f, p, q, t;

     if (S == 0.0)
     {
	  *R = V;
	  *G = V;
	  *B = V;
     }
     else
     {
	  H *= 360.0;
	  if (H >= 360.0)
	       H = 0.0;
	  H /= 60.0;
	  i = (int) H;
	  f = H - (TReal) i;
	  p = V*(1 - S);
	  q = V*(1 - S*f);
	  t = V*(1 - S*(1 - f));
	  switch (i)
	  {
	    case 0: { *R = V; *G = t; *B = p; break;}
	    case 1: { *R = q; *G = V; *B = p; break;}
	    case 2: { *R = p; *G = V; *B = t; break;}
	    case 3: { *R = p; *G = q; *B = V; break;}
	    case 4: { *R = t; *G = p; *B = V; break;}
	    case 5: { *R = V; *G = p; *B = q; break;}
	  }
     }
}


/*****************************************************************************
 *  Funktion:       Dimension AlignButtons(Widget w[], int modus)
 *  Parameter:      w:       Liste von Widgets, die angeglichen werden
 *                           sollen (abgeschlossen mit (Widget) NULL)
 *                  modus:   1: auf gleiche Breite
 *                           2: auf gleiche Hoehe
 *
 *  Rueckgabewert:  maximale Breite (modus 1) bzw. Hoehe (modus 2)
 *
 *  Import. Bezeichner:
 *
 *  Beschreibung:
 *  -------------
 *  Von den Widgets w wird nacheinander die aktuelle Breite bzw. Hoehe
 *  ermittelt und das Maximum dieser Werte zurueckgegeben.
 *****************************************************************************/

Dimension AlignButtons(Widget w[], int modus)
{
     int i;
     Dimension max, test;

     if (w[0] == (Widget) NULL) return 0;

     if (modus == 1)
	  XtVaGetValues (w[0], XtNwidth, &max, NULL);
     else
	  XtVaGetValues (w[0], XtNheight, &max, NULL);

     i = 1;
     while (w[i] != (Widget) NULL)
     {
	  if (modus == 1)
	       XtVaGetValues (w[i], XtNwidth, &test, NULL);
	  else
	       XtVaGetValues (w[i], XtNheight, &test, NULL);
	  
	  if (test>max) max=test;
	  i++;
     }	  

     return max;
}

