/********************************************************************************
 *  Projektname:        AERO
 *  Filename:           ObjektAktionen.c
 *  Filetyp:            Modul
 ********************************************************************************
 *  Modulname:          ObjektAktionen
 *  Version:            1.2.2
 *  letzte Aenderung:   Donnerstag,  7. Dezember 1995, 11:39:11
 *  Autor:              Andreas
 *  Status:             finished, only bugs will be fixed
 *
 *  imp. Bezeichner:
 *
 *  exp. Bezeichner:
 *
 *  Beschreibung:
 *  -------------
 *
 *
 *  Versionsgeschichte:
 *  -------------------
 *    3.12.92: Einbringen von Funktionalit"at.
 *   28.12.92: Erm"oglichen zu Scrollen und die Positionierung "uber Mausbutton
 *   29.12.92: SelektiereAuswahl wird installiert
 *   -7. 1.92: Funktionalit"at um 'entferne Objekt', 'baue Verbindung' erweitert
 *   26.01.93: Objekt reedieren ist jetzt m"oglich. dazu mu"s die auch die
 *             Routine einf"ugeObjekt ge"andert werden: Splitten in zwei Teile:
 *                a) nur f"ur einf"uge Objekt relevanter Teil
 *                b) f"ur beide Funktinalit"aten relevanter Teil
 *             Au"serdem mu"ste die 'Abort'-Routine ge"andert werden. Je nach
 *             Kontext wird einmal das selektierte Objekt entfernt (einf"uge-
 *             Objekt), zum Anderen mu"s der Zustand vor dem "Andern wiederherge-
 *             stellt werden.
 *   01.02.93: Das Rotieren der Objekte ist nun m"oglich.
 *   03.02.93: Einf"ugen eines neuen Objektes Boden.
 *   05.02.93: Selektiertes Objekt bleibt selektiert bis ein neues Objekt selek-
 *             tiert wird.
 *   08.02.93: Es trat ein Fehler auf: wurde ein Objekt gel"oscht das mindestens
 *             einer Verbindung angeh"ort, blieb die Verbindung bestehen. Bei Be-
 *             rechnung des Folgebildes wurde dann auf die Objekte zugegriffen
 *             was zu einem BUS-Error f"uhrte. Inzwischen ist dieser Fehler da-
 *             durch behoben, da"s alle Verbindungen, in denen das zu l"oschende
 *             Objekt ein Bindungspartner ist, gel"oscht werden.
 *   11.02.93: Positionsangabe des einzuf"ugenden Objektes ist nun vorhanden.
 *   15.02.93: Das Object-Widget bleibt immer ge"offnet. Daf"ur m"ussen einige
 *             Stellen im Source ge"andert werden. Zus"atzlich kommt eine Routine
 *             zum setzen der Scrollbar-Farbwerte dazu.
 *   17.02.93: Die "Anderung eines der Scrollbar-Werte wirk sich nicht mehr di-
 *             rekt auf das Objekt aus, sondern wird zun"achst in dem daf"ur vor-
 *             gesehenen Fenster gezeigt. Es durch dr"ucken der 'Apply'-Taste
 *             wird die Farbe ins Objekt "ubernommen.
 *  -19.02.93: Routinen zum "Andern von Verbindungsparametern wird implementiert.
 *  -23.03.93: Neue Buttons kommen hinzu: Materialdaten erfragen, Materialdaten 
 *             eintragen, anderes Objekt selektieren, gravitationsloses Objekt, 
 *             masseloses Objekt. 
 *   25.03.93: Es wurde eine Routine zum L"oschen der Zustandsdaten geschrieben.
 *   09.04.93: Es wurde ein K"orper eingef"uhrt, der dann eingeh"angt wird, wenn
 *             ein Angriffspunkt einer Verbindung gesetzt wird.
 *   05.05.93: Einf"ugen eines eineindeutigen Z"ahlers f"ur die K"orper.
 *   18.05.93: Einf"ugen von Drehreglern zur Einstellung von Rauhigkeit und 
 *             Reflexion
 *   24.06.93: Bei der Eingabe eines Gelenkes mu"s die Positionsangabe jetzt nur 
 *             noch bei einem Objekt gemacht werden.
 *   26.07.93: Routine fr SelektFirst-Button
 *   21.02.94: replace char *trans = malloc (20*sizeof(char)) by char trans[20].
 *   24.03.94: undo last change (21.02.94)
 *    7.11.94: Replaced Xaw-Scrollbar by Xfwf-VScrollbar.
 *    9.11.94: Inserted some routines to support HSV-colorchange.
 *   15.02.95: Inserted copy-function to copy objects as well as grouped objects.
 *   25.08.95: Added 'select next group' functionality.
 *    8.09.95: Selecting an object with the mouse is now supported. The code
 *             for this work hacked by Arijan ... I only had to fix a bug.
 *             Thanks Arjian!! :-)
 *    9.11.95: Building links and directed forces use the selection of an object 
 *             by mouse.
 ********************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Command.h>
#include <X11/Shell.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Dialog.h>
#include <Xfwf/VScrollb.h>
#include <Xfwf/scroll.h>
#include <X11/Xaw/Repeater.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Toggle.h>
#ifdef DREHREGLER
#include <Xfwf/Rheostat.h>
#endif
#include <Xfwf/ScrList.h>

#include <string.h>
#include "Welt.h"
#include "vektor.h"
#include "anzeigeconst.h"
#include "Editor.h"
#include "visualisierung.h"

/********************************************************************************
 *  Importierte Funktionen aus unterschiedlichen 'Modulen'.
 ********************************************************************************/
   extern  void AnzeigeDarstellung (Widget, Widget, Widget, Widget, TVektor,
                                   TQuaternion, TReal, TZustand *, int);
   extern  void InitialisiereRGB (XtAppContext *, Widget);
   extern  void AnzeigeRGB (Widget, unsigned short, unsigned short, unsigned short);
   extern  void SetzeActionsDarstellung (XtAppContext *, Widget, Widget, Widget, Widget);
   extern  void KopiereKoerper (TKoerper **, TKoerper *, TKoerper *);

   extern  void SucheSelektiertesObjekt (TKoerperListe **);
   extern  void SelektAllButtons (TBoolean);
   extern  void Q_MUL (TQuaternion, TQuaternion, TQuaternion);
   extern  void UeberpruefeWert (TReal *Wert, Widget NO_Param);
   extern  void HighLight (TKoerper *);
   extern  void UnHighLight (TKoerper *);
   extern  void toggleNOStatus (TBoolean);
   extern  void Aktion_gerichteteKraft (void);
   extern  void initNeuesMaterial (Widget, XtPointer, XtPointer);
   extern  void initMaterialDaten (Widget, XtPointer, XtPointer);
   extern  void entferneZustand (TZustand *);
   extern  TBoolean convert_RGB_HSV (long, long, long, TReal *, TReal *, TReal *);
   extern  void convert_HSV_RGB (TReal, TReal, TReal, TReal *, TReal *, TReal *);
   extern  TKoerper *SelektiereVonDarstellung(Widget w, AXKoord sx, AXKoord sy,
					      TVektor darstpos, TKoerper *koerper);
   extern  void OffsetDarstellung(Widget w, AXKoord sx, AXKoord sy, TVektor darstpos);


/********************************************************************************
 *  Importierte Bezeichner  (global definiert)
 ********************************************************************************/

TSelektKontext SelektKontext;
TKoerper *markPosition;


/********************************************************************************
 *  Local globale Variablen, die den Zustand der Objektposition wiederspiegeln
 ********************************************************************************/
static TReal XOffset, YOffset, ZOffset;
static TVerbindung *selektierteVerbindung;
static TKoerper *selektObjOLD;
/*static TKoerper *selektAlternativ;*/
static unsigned short ScrRot, ScrGruen, ScrBlau;
static TReal Scr_H, Scr_S, Scr_V;
static TBoolean popedupNO = FALSE;
#ifdef DREHREGLER
static Widget NO_Rauhigkeit, NO_RauhigkeitProz, NO_Reflexion, NO_ReflexionProz;
#endif


/*******************************************************************************
 *  void HighLight (TKoerper *sel)
 *  TKoerper *sel: Zeiger auf das selektierte Objekt das hervorgehoben werden 
 *                 soll.
 *
 *  Beschreibung:
 *  -------------
 *  Die Routine setzt f"ur das Objekt ein Flag, das die Darstellung des Objektes
 *  "andert. Es wird hervorgehoben. Damit man diesen Effekt auch sieht wird die
 *  Anzeigeroutine aufgerufen.
 ********************************************************************************/

void HighLight (TKoerper *sel)
{
   if (sel != NULL)
   {
      sel->AStatus |= SelectedON;
      AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
			  EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
			  DZoomFaktor, &aktuelleWelt->Welt, 
			  KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
   }
}


/*******************************************************************************
 *  void UnHighLight (TKoerper *sel)
 *  TKoerper *sel: Zeiger auf das selektierte Objekt das wieder normal darge-
 *                 stellt werden soll.
 *
 *  Beschreibung:
 *  -------------
 *  Die Routine ist das Gegenst"uck zu 'HighLight'. Es sorgt daf"ur, da das 
 *  Objekt wieder normal dargestellt werden kann.
 ********************************************************************************/

void UnHighLight (TKoerper *sel)
{
   if (sel != NULL)
   {
      sel->AStatus &= SelectedOFF;
      AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
			  EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
			  DZoomFaktor, &aktuelleWelt->Welt, 
			  KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
   }
}


/*******************************************************************************
 *  void HighLightVerb (TVerbindung *sel)
 *  TKoerper *sel: Zeiger auf die selektierte Verbindung, die hervorgehoben 
 *                 werden soll.
 *
 *  Beschreibung:
 *  -------------
 *  Selbe Funktion wie HighLight, au"ser da"s statt Objekten Verbindungen hervor-
 *  gehoben werden.
 ********************************************************************************/

void HighLightVerb (TVerbindung *sel)
{
   if (sel != NULL)
   {
      sel->AStatus |= SelectedON;
      AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
			  EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
			  DZoomFaktor, &aktuelleWelt->Welt, 
			  KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
   }
}


/*******************************************************************************
 *  void UnHighLight (TKoerper *sel)
 *  TKoerper *sel: Zeiger auf das selektierte Objekt das wieder normal darge-
 *                 stellt werden soll.
 *
 *  Beschreibung:
 *  -------------
 *  Die Routine ist das Gegenst"uck zu 'HighLight'. Es sorgt daf"ur, da das 
 *  Objekt wieder normal dargestellt werden kann.
 ********************************************************************************/

void UnHighLightVerb (TVerbindung *sel)
{
   if (sel != NULL)
   {
      sel->AStatus &= SelectedOFF;
      AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
			  EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
			  DZoomFaktor, &aktuelleWelt->Welt, 
			  KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
   }
}


/*******************************************************************************
 *  void scrollFenster (Widget w, XEvent *event, String *param, Cardinal *numParam)
 *     Widget w:      Widgetname des 'aufrufenden' Fensters
 *     XEvent *event: Eventtyp mit allen Angaben zu diesem Event
 *
 *  Beschreibung:
 *  -------------
 *  Mit dieser Routine kann man in dem entsprechenden Fenster scrollen. Durch
 *  den Druck der mittleren Maustaste wird diese Routine aufgerufen. Dies hat
 *  zur Folge, da"s die Koordinaten auf denen die Maustaste gedr"uckt wurde in
 *  die Mitte des Fensters 'rutschen'.
 *   
 *  LEIDER wird diese sinnvolle Prozedur nicht untersttzt.
 ********************************************************************************/

void scrollFenster (Widget w, XEvent *event, String *param, Cardinal *numParam)
{
     OffsetDarstellung (w, event->xbutton.x, event->xbutton.y, Koordinatenursprung);
     /****************************************************************************
      * Es folgt ein Refresh des Darstellungsfensters.
      ****************************************************************************/
     AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
			 EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
			 DZoomFaktor, &aktuelleWelt->Welt, 
			 KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
}


/*******************************************************************************
 *  void setzeScrollbarPosition (void)
 *
 *  Beschreibung:
 *  -------------
 *  Die Routine setzt die Scrollbalken auf ihre Position, die sie von der Ein-
 *  stellung der Farbwerte einnehmen mssen.
 ********************************************************************************/

void setzeScrollbarPosition (void)
{
     TReal Wert;

     XtSetSensitive (NO_ScrollRot, TRUE);
     XtSetSensitive (NO_ScrollGruen, TRUE);
     XtSetSensitive (NO_ScrollBlau, TRUE);
     XtSetSensitive (NO_Scroll_H, TRUE);
     XtSetSensitive (NO_Scroll_S, TRUE);
     XtSetSensitive (NO_Scroll_V, TRUE);
     Wert = 1.0 - ((TReal)selektiertesObjekt->R)/65535.0;
     XfwfSetScrollbar (NO_ScrollRot, Wert, SliderSize);
     Wert = 1.0 - ((TReal)selektiertesObjekt->G)/65535.0;
     XfwfSetScrollbar (NO_ScrollGruen, Wert, SliderSize);
     Wert = 1.0 - ((TReal)selektiertesObjekt->B)/65535.0;
     XfwfSetScrollbar (NO_ScrollBlau, Wert, SliderSize);
     if (convert_RGB_HSV (selektiertesObjekt->R, selektiertesObjekt->G, selektiertesObjekt->B, 
		      &Scr_H, &Scr_S, &Scr_V))
	  XfwfSetScrollbar (NO_Scroll_H, 1.0 - Scr_H, SliderSize);
     XfwfSetScrollbar (NO_Scroll_S, 1.0 - Scr_S, SliderSize);
     XfwfSetScrollbar (NO_Scroll_V, 1.0 - Scr_V, SliderSize);
}


/*******************************************************************************
 *  void ObjectInsertEquiv (void)
 *
 *  Beschreibung:
 *  -------------
 *  Die Routine setzt default-Werte fr Objekte.
 ********************************************************************************/

void ObjectInsertEquiv (void)
{
   KoerperId ++;
   selektiertesObjekt->Position[0] = 0.0;        /* x-Position */
   selektiertesObjekt->Position[1] = 0.0;        /* y-Position */
   selektiertesObjekt->Position[2] = 0.0;        /* z-Position */
   selektiertesObjekt->Geschwindigkeit[0] = 0.0; /* Geschw. in x-Richtung */
   selektiertesObjekt->Geschwindigkeit[1] = 0.0; /* Geschw. in y-Richtung */
   selektiertesObjekt->Geschwindigkeit[2] = 0.0; /* Geschw. in z-Richtung */
   selektiertesObjekt->Beschleunigung[0] = 0.0;  /* Beschl. in x-Richtung */
   selektiertesObjekt->Beschleunigung[1] = 0.0;  /* Beschl. in y-Richtung */
   selektiertesObjekt->Beschleunigung[2] = 0.0;  /* Beschl. in z-Richtung */
   selektiertesObjekt->Drehbeschleunigung[0] = 0.0;
   selektiertesObjekt->Drehbeschleunigung[1] = 0.0;
   selektiertesObjekt->Drehbeschleunigung[2] = 0.0;
   selektiertesObjekt->Drehgeschwindigkeit[0] = 0.0;
   selektiertesObjekt->Drehgeschwindigkeit[1] = 0.0;
   selektiertesObjekt->Drehgeschwindigkeit[2] = 0.0;
   selektiertesObjekt->Naechster = NULL;
   selektiertesObjekt->AStatus = 0;
   selektiertesObjekt->Kraefte = NULL;
   selektiertesObjekt->KoerperId = KoerperId;
}


void SameValues (TKoerper *selObjOLD)
{
     selektiertesObjekt->Material = selObjOLD->Material;
     XfwfScrolledListHighlightItem (NO_Material, selektiertesObjekt->Material);
     selektiertesObjekt->R = selObjOLD->R;     
     selektiertesObjekt->G = selObjOLD->G;
     selektiertesObjekt->B = selObjOLD->B;
     selektiertesObjekt->Durchsichtigkeit = selObjOLD->Durchsichtigkeit;
     selektiertesObjekt->Reflexion = selObjOLD->Reflexion;
     selektiertesObjekt->Rauhigkeit = selObjOLD->Rauhigkeit;
     selektiertesObjekt->q[0] = selObjOLD->q[0];
     selektiertesObjekt->q[1] = selObjOLD->q[1];
     selektiertesObjekt->q[2] = selObjOLD->q[2];
     selektiertesObjekt->q[3] = selObjOLD->q[3];
}


void DefaultValues (void)
{
     selektiertesObjekt->Material = EISEN;
     XfwfScrolledListHighlightItem (NO_Material, selektiertesObjekt->Material);
     selektiertesObjekt->R = 
	  DefaultR (aktuelleWelt->Welt.MaterialDaten, selektiertesObjekt->Material);
     selektiertesObjekt->G = 
	  DefaultG (aktuelleWelt->Welt.MaterialDaten, selektiertesObjekt->Material);
     selektiertesObjekt->B = 
	  DefaultB (aktuelleWelt->Welt.MaterialDaten, selektiertesObjekt->Material);
     selektiertesObjekt->Durchsichtigkeit = 
	  DefaultDurchsichtigkeit (aktuelleWelt->Welt.MaterialDaten, selektiertesObjekt->Material);
     selektiertesObjekt->Reflexion = 
	  DefaultReflexion (aktuelleWelt->Welt.MaterialDaten, selektiertesObjekt->Material);
     selektiertesObjekt->Rauhigkeit = 
	  DefaultRauhigkeit (aktuelleWelt->Welt.MaterialDaten, selektiertesObjekt->Material);
     selektiertesObjekt->q[0] = 1.0;
     selektiertesObjekt->q[1] = 0.0;
     selektiertesObjekt->q[2] = 0.0;
     selektiertesObjekt->q[3] = 0.0;
}

#ifdef DREHREGLER
/*******************************************************************************
 *  void setzeRegler (void)
 *
 *  Beschreibung:
 *  -------------
 *  Die Routine setzt die Drehregler auf den entsprechenden Wert. Dabei mu"s 
 *  nicht nur der Drehregler, sondern auch der dazugeh"orende Text gesetzt wer-
 *  den.
 ********************************************************************************/

void setzeRegler (void)
{
     char *konv = malloc (20*sizeof (char));

     XtSetSensitive (NO_Durchsicht, TRUE);
     XtSetSensitive (NO_Rauhigkeit, TRUE);
     XtSetSensitive (NO_Reflexion, TRUE);

     XtVaSetValues (NO_Durchsicht, XtNvalue, (int) (selektiertesObjekt->Durchsichtigkeit*100), NULL);
     sprintf (konv, "    %.1f %% ", selektiertesObjekt->Durchsichtigkeit*100.0);
     XtVaSetValues (NO_DurchsProz, XtNlabel, konv, NULL);

     XtVaSetValues (NO_Rauhigkeit, XtNvalue,  (int)  (selektiertesObjekt->Rauhigkeit*100), NULL);
     sprintf (konv, "    %.1f %% ", selektiertesObjekt->Rauhigkeit*100);
     XtVaSetValues (NO_RauhigkeitProz, XtNlabel, konv, NULL);

     XtVaSetValues (NO_Reflexion, XtNvalue,  (int)  (selektiertesObjekt->Reflexion*100), NULL);
     sprintf (konv, "    %.1f %% ", selektiertesObjekt->Reflexion*100.0);
     XtVaSetValues (NO_ReflexionProz, XtNlabel, konv, NULL);
}
#endif


/*******************************************************************************
 *  void DObjektEinfuegen (void)
 *
 *  Beschreibung:
 *  -------------
 *  Durch hinzunehmen der Funktionalit"at des 'nachedierens' von Objekten musste
 *  die Routine ObjectInsertion in zwei Teile gesplittet werden:
 *     1. den Teil, der nur beim Einf"ugen neuer Objekte durchlaufen wird und
 *     2. einem allgemeinen Teil, der nur noch die Benutzeroberfl"ache 'verwal-
 *        tet'.
 *  Diese Routine realisiert den 2.Teil. Es m"ussen alle Werte gesetzt werden,
 *  sowie die entsprechenden Buttons aktiviert/deaktiviert werden.
 ********************************************************************************/

void DObjektEinfuegen (void)
{
     char *trans = malloc (20*sizeof (char));
     String translation =
	  "#augment\n\
              <Key>Left:    dec(Left)\n\
              <Key>Right:   inc(Right)\n\
              <Key>Down:    dec(Down)\n\
              <Key>Up:      inc(Up)\n\
              <Btn1Down>:   selectObjectWithMouse()\n\
              <Btn2Down>:   scrollFenster()";

     toggleNOStatus (TRUE);

     switch (selektiertesObjekt->Art)
     {
       case KUGEL: 
	  XtVaSetValues (NO_Param1Txt, XtNlabel, "radius", NULL);
	  sprintf (trans, "%.3f", selektiertesObjekt->Form.Kugel.Radius);
	  XtVaSetValues (NO_Param1, XtNstring, trans, NULL);
	  XtSetSensitive (NO_Param1, TRUE);
	  XtVaSetValues (NO_Param2Txt, XtNlabel,"          ", NULL);
	  XtVaSetValues (NO_Param2, XtNstring,"", NULL);
	  XtSetSensitive (NO_Param2, FALSE);
	  XtVaSetValues (NO_Param3Txt, XtNlabel,"          ", NULL);
	  XtSetSensitive (NO_Param3, FALSE);
	  XtVaSetValues (NO_Param3, XtNstring,"", NULL);
	  XtVaSetValues (NO_ObjektInfo, XtNlabel,"Type of edited object: sphere", NULL);
	  break;
      case QUADER: 
	  XtVaSetValues (NO_Param1Txt, XtNlabel,"width     ", NULL);
	  sprintf (trans, "%.3f", selektiertesObjekt->Form.Quader.KantenLaenge[0]);
	  XtVaSetValues (NO_Param1, XtNstring, trans, NULL);
	  XtSetSensitive (NO_Param1, TRUE);
	  XtVaSetValues (NO_Param2Txt, XtNlabel,"height    ", NULL);
	  sprintf (trans, "%.3f", selektiertesObjekt->Form.Quader.KantenLaenge[1]);
	  XtVaSetValues (NO_Param2, XtNstring, trans, NULL);
	  XtSetSensitive (NO_Param2, TRUE);
	  XtVaSetValues (NO_Param3Txt, XtNlabel,"depth     ", NULL);
	  sprintf (trans, "%.3f", selektiertesObjekt->Form.Quader.KantenLaenge[2]);
	  XtVaSetValues (NO_Param3, XtNstring, trans, NULL);
	  XtSetSensitive (NO_Param3, TRUE);
	  XtVaSetValues (NO_ObjektInfo, XtNlabel,"Type of edited object: cuboid", NULL);
	  break;
      case ZYLINDER: 
	  XtVaSetValues (NO_Param1Txt, XtNlabel,"height     ", NULL);
	  sprintf (trans, "%.3f", selektiertesObjekt->Form.Zylinder.Hoehe);
	  XtVaSetValues (NO_Param1, XtNstring, trans, NULL);
	  XtSetSensitive (NO_Param1, TRUE);
	  XtVaSetValues (NO_Param2Txt, XtNlabel,"radius    ", NULL);
	  sprintf (trans, "%.3f", selektiertesObjekt->Form.Zylinder.Radius);
	  XtVaSetValues (NO_Param2, XtNstring, trans, NULL);
	  XtSetSensitive (NO_Param2, TRUE);
	  XtVaSetValues (NO_Param3Txt, XtNlabel,"          ", NULL);
	  XtVaSetValues (NO_Param3, XtNstring,"", NULL);
	  XtSetSensitive (NO_Param3, FALSE);
	  XtVaSetValues (NO_ObjektInfo, XtNlabel,"Type of edited object: cylinder", NULL);
	  break;
       default: 
	  XtVaSetValues (NO_Param1Txt, XtNlabel,"            ", NULL);
	  XtVaSetValues (NO_Param2Txt, XtNlabel,"            ", NULL);
	  XtVaSetValues (NO_Param3Txt, XtNlabel,"            ", NULL);
	  XtSetSensitive (NO_Param1, FALSE);
	  XtSetSensitive (NO_Param2, FALSE);
	  XtSetSensitive (NO_Param3, FALSE);
	  XtVaSetValues (NO_Param1, XtNstring,"", NULL);
	  XtVaSetValues (NO_Param2, XtNstring,"", NULL);
	  XtVaSetValues (NO_Param3, XtNstring,"", NULL);
	  switch (selektiertesObjekt->Art)
	  {
	    case NAGEL: 
	       XtVaSetValues (NO_ObjektInfo, XtNlabel,"Type of edited object: immovable point", 
			      NULL);
	       break;
	    case PUNKT: 
	       XtVaSetValues (NO_ObjektInfo, XtNlabel,"Type of edited object: movable point", 
			      NULL);
	       break;
	    case EBENE: 
	       XtVaSetValues (NO_ObjektInfo, XtNlabel,"Type of edited object: plane", NULL);
	       break;
	    case ZUSGESOBJ: 
	       XtVaSetValues (NO_ObjektInfo, XtNlabel,"Type of edited object: group object", 
			      NULL); 
	       break;
	    default: break;
	  }
	  break;
     } /* switch */
     XOffset = 0.0; YOffset = 0.0; ZOffset = 0.0;     /*** 28.12.92 ***/
     SelektAllButtons (TRUE);

     sprintf (trans,"%.3f", selektiertesObjekt->Position[0]);
     XtVaSetValues (NO_Pos_X, XtNstring, trans, NULL);
     sprintf (trans,"%.3f", selektiertesObjekt->Position[1]);
     XtVaSetValues (NO_Pos_Y, XtNstring, trans, NULL);
     sprintf (trans,"%.3f", -selektiertesObjekt->Position[2]);
     XtVaSetValues (NO_Pos_Z, XtNstring, trans, NULL);
     
     XtAugmentTranslations (EM_DarstellungXY, XtParseTranslationTable (translation));
     XtAugmentTranslations (EM_DarstellungXZ, XtParseTranslationTable (translation));
     XtAugmentTranslations (EM_DarstellungYZ, XtParseTranslationTable (translation));
     if (selektiertesObjekt->Art != ZUSGESOBJ)
     {
	  ScrRot = selektiertesObjekt->R;
	  ScrGruen = selektiertesObjekt->G;
	  ScrBlau = selektiertesObjekt->B;
	  setzeScrollbarPosition ();
	  XfwfScrolledListHighlightItem (NO_Material, selektiertesObjekt->Material);
#ifdef DREHREGLER
	  setzeRegler ();
#endif
     }
     else
     {
	  XtSetSensitive (NO_ScrollRot, FALSE);
	  XtSetSensitive (NO_ScrollGruen, FALSE);
	  XtSetSensitive (NO_ScrollBlau, FALSE);
#ifdef DREHREGLER
	  XtSetSensitive (NO_Durchsicht, FALSE);
	  XtSetSensitive (NO_Rauhigkeit, FALSE);
	  XtSetSensitive (NO_Reflexion, FALSE);
#endif
	  XtSetSensitive (NO_Apply, FALSE);
     }
     XtVaSetValues (NO_GravLos, XtNstate, IstKoerperGravlos (selektiertesObjekt), NULL);
     XtVaSetValues (NO_MasseLos, XtNstate, IstKoerperMasselos (selektiertesObjekt), NULL);
     
     *selektObjOLD = *selektiertesObjekt;
     AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
			 EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
			 DZoomFaktor, &aktuelleWelt->Welt, 
			 KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
     if (!popedupNO)
     {
	  XtPopup (NO_Shell, XtGrabNone);
	  InitialisiereRGB (&appContext, NO_Farbe);
	  popedupNO = TRUE;
     }
     AnzeigeRGB (NO_Farbe, ScrRot, ScrGruen, ScrBlau);
}


/*******************************************************************************
 *  void ObjectInsertion (Widget w, XtPointer clientData, XtPointer garbage)
 *  Widget w              Widget des ausl"osenden Menue-Eintrages.
 *  XtPointer clientData  Parameter der durch XtAddCallback "ubergeben wird,
 *                        hier der Typ des einzuf"ugenden Objektes.
 *  XtPointer garbage     Wird nicht verwendet, wird jedoch von Callback verlangt.
 *
 *  Beschreibung:
 *  -------------
 *  ObjectInsertion reserviert Platz f"ur einen neuen K"orper und belegt in Ab-
 *  h"angigkeit des Parameters clientData Defaultwerte f"ur das Objekt.
 *  Anschliessend wird die Shell NO_Shell ge"offnet.
 ********************************************************************************/

void ObjectInsertion (Widget w, XtPointer GrundForm, XtPointer callData)
{
     TGrundFormen Form =  (TGrundFormen) GrundForm;

     if (selektiertesObjekt != NULL)
     {
	  UnHighLight (selektiertesObjekt);
	  *selektObjOLD = *selektiertesObjekt;
     }
     selektiertesObjekt =  (TKoerper *) malloc (sizeof (TKoerper));
     SpeicherFrei (selektiertesObjekt);
     selektiertesObjekt->OberKoerper = selektiertesObjekt;
     selektiertesObjekt->Art = Form;
     if (selektObjOLD != NULL)
     {
	  if (Form == KUGEL)
	       if (selektObjOLD->Art == KUGEL)
	       {
		    selektiertesObjekt->Form.Kugel.Radius = selektObjOLD->Form.Kugel.Radius;
		    SameValues (selektObjOLD);
	       }
	       else
	       {
		    selektiertesObjekt->Form.Kugel.Radius = 0.05;
		    DefaultValues ();
	       }
	  else if (Form == QUADER)
	       if (selektObjOLD->Art == QUADER)
	       {
		    selektiertesObjekt->Form.Quader.KantenLaenge[0] = 
			 selektObjOLD->Form.Quader.KantenLaenge[0];  /* Einheit Meter */
		    selektiertesObjekt->Form.Quader.KantenLaenge[1] = 
			 selektObjOLD->Form.Quader.KantenLaenge[1];
		    selektiertesObjekt->Form.Quader.KantenLaenge[2] = 
			 selektObjOLD->Form.Quader.KantenLaenge[2];
		    SameValues (selektObjOLD);
	       }
	       else
	       {
		    selektiertesObjekt->Form.Quader.KantenLaenge[0] = 0.3;  /* Einheit Meter */
		    selektiertesObjekt->Form.Quader.KantenLaenge[1] = 0.1;
		    selektiertesObjekt->Form.Quader.KantenLaenge[2] = 0.2;
		    DefaultValues ();
	       }
	  else if (Form == ZYLINDER)
	       if (selektObjOLD->Art == ZYLINDER)
	       {
		    selektiertesObjekt->Form.Zylinder.Radius = selektObjOLD->Form.Zylinder.Radius;
		    selektiertesObjekt->Form.Zylinder.Hoehe = selektObjOLD->Form.Zylinder.Hoehe;
		    SameValues (selektObjOLD);
	       }
	       else
	       {
		    selektiertesObjekt->Form.Zylinder.Radius = 0.05;  /* Einheit Meter */
		    selektiertesObjekt->Form.Zylinder.Hoehe = 0.2;    /* Einheit Meter */
		    DefaultValues ();
	       }
	  else
	       DefaultValues ();
     }
     else
     {
	  if (Form == KUGEL)
	       selektiertesObjekt->Form.Kugel.Radius = 0.05;
	  else if (Form == QUADER)
	  {
	       selektiertesObjekt->Form.Quader.KantenLaenge[0] = 0.3;  /* Einheit Meter */
	       selektiertesObjekt->Form.Quader.KantenLaenge[1] = 0.1;
	       selektiertesObjekt->Form.Quader.KantenLaenge[2] = 0.2;
	  }
	  else if (Form == ZYLINDER)
	  {
	       selektiertesObjekt->Form.Zylinder.Radius = 0.05;  /* Einheit Meter */
	       selektiertesObjekt->Form.Zylinder.Hoehe = 0.2;    /* Einheit Meter */
	  }
	  DefaultValues ();
     }
     ObjectInsertEquiv ();
     HighLight (selektiertesObjekt);
     selektiertesObjekt->Naechster = aktuelleWelt->Welt.Koerper;
     aktuelleWelt->Welt.Koerper = selektiertesObjekt;
     KoeIniMech (selektiertesObjekt, aktuelleWelt->Welt.MaterialDaten);
     DObjektEinfuegen ();
}


/********************************************************************************
 *  void selectObjectWithMouse (Widget w, XEvent *event, String *param, 
 *                              Cardinal *numParam)
 *
 *      w: Widget 
 *  explanation:
 *  -------------
 *
 ********************************************************************************/

void selectObjectWithMouse (Widget w, XEvent *event, String *param, Cardinal *numParam)
{
     UnHighLight (selektiertesObjekt);
     selektiertesObjekt = 
	  SelektiereVonDarstellung (w, event->xbutton.x, event->xbutton.y, 
				    Koordinatenursprung, aktuelleWelt->Welt.Koerper);
     HighLight (selektiertesObjekt);
     DObjektEinfuegen ();
     AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
			 EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
			 DZoomFaktor, &aktuelleWelt->Welt, 
			 KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
}


/*******************************************************************************
 *  void newObjectUndo (Widget w, XtPointer clientData, XtPointer garbage)
 *
 *  Beschreibung:
 *  -------------
 *  Die Routine wird aufgerufen, wenn das editierte Objekt nicht in die 'Welt'
 *  "ubernommen werden soll. Da das slektierteObjekt jedoch bereits in die Welt
 *  eingef"ugt wurde, mu"s es noch aus der Liste entfernt werden. Das Entfernen
 *  ist recht einfach, da das selektierte Objekt immer am Anfang der Liste ein-
 *  gef"ugt wird. Nach dem Umh"angen der Zeiger kann der reservierten Speicher-
 *  bereich f"ur das selektierte Objekt wieder freigeben werden.
 ********************************************************************************/

void newObjectUndo (Widget w, XtPointer clientData, XtPointer garbage)
{
   if (selektiertesObjekt != NULL)
   {
      *selektiertesObjekt = *selektObjOLD;
      DObjektEinfuegen ();
      SetzeActionsDarstellung (&appContext, EM_DarstellungXY, EM_DarstellungYZ,
	  		       EM_DarstellungXZ, EM_Darstellung3D);
      AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
			  EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
			  DZoomFaktor, &aktuelleWelt->Welt, 
			  KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
   }
   else fprintf (stderr,"Please select an object first!\n");
}


/*******************************************************************************
 *  void inc (Widget w, XEvent *event, String *param, Cardinal *num_param)
 *
 *  Beschreibung:
 *  -------------
 *  Die Routine wird durch Druecken einer Cursortaste  (up, right, siehe Trans-
 *  lationtable) ausgeloest. Entsprechend dem Fenster, in dem sich die Maus bei
 *  Tastendruck befand, wird eine Koordinate erhoeht. Danach wird das Bild aktu-
 *  alisiert und die neue Position im Objekt-Fenster geschrieben.
 ********************************************************************************/

void inc (Widget w, XEvent *event, String *param, Cardinal *num_param)
{
   TReal Schrittweite;
   char *trans = malloc (20*sizeof (char));

   Schrittweite = 0.05/DZoomFaktor;
   if (selektiertesObjekt != NULL)
   {
      if (w == EM_DarstellungXY)
         if (strcmp (*param, "Right") == 0)
            selektiertesObjekt->Position[0] += Schrittweite;   /* x-Achse: increment */
         else selektiertesObjekt->Position[1] += Schrittweite; /* y-Achse: increment */
      else if (w == EM_DarstellungXZ)
         if (strcmp (*param, "Right") == 0)
            selektiertesObjekt->Position[0] += Schrittweite;   /* x-Achse: increment */
         else
            selektiertesObjekt->Position[2] -= Schrittweite;   /* z-Achse: increment */
      else if (w == EM_DarstellungYZ)
         if (strcmp (*param, "Right") == 0)
            selektiertesObjekt->Position[2] -= Schrittweite;   /* z-Achse: increment */
         else
            selektiertesObjekt->Position[1] += Schrittweite;   /* y-Achse: increment */
      else
         fprintf (stderr, "Something went wrong  (inc)!\n");
      if (selektiertesObjekt->Art == ZUSGESOBJ)
	 ZusGesObjRot (selektiertesObjekt);

      sprintf (trans,"%.3f", selektiertesObjekt->Position[0]);
      XtVaSetValues (NO_Pos_X, XtNstring, trans, NULL);
      sprintf (trans,"%.3f", selektiertesObjekt->Position[1]);
      XtVaSetValues (NO_Pos_Y, XtNstring, trans, NULL);
      sprintf (trans,"%.3f", -selektiertesObjekt->Position[2]);
      XtVaSetValues (NO_Pos_Z, XtNstring, trans, NULL);

      AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
			  EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
			  DZoomFaktor, &aktuelleWelt->Welt, 
			  KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
   }
}


/*******************************************************************************
 *  void dec (Widget w, XEvent *event, String *param, Cardinal *num_param)
 *
 *  Beschreibung:
 *  -------------
 *  Selbe Funktion wie inc, ausser dass die Funktion bei Druck der Tasten left,
 *  down ausgeloest wird und die Koordinate des selektierten Objekts decremen-
 *  tiert.
 ********************************************************************************/

void dec (Widget w, XEvent *event, String *param, Cardinal *num_param)
{
     TReal Schrittweite;
     char *trans = malloc (20*sizeof (char));
     
     Schrittweite = 0.05/DZoomFaktor;
     if (selektiertesObjekt != NULL)
     {
	  if (w == EM_DarstellungXY)
	       if (strcmp (*param, "Left") == 0)
		    selektiertesObjekt->Position[0] -= Schrittweite;   /* x-Achse */
	       else
		    selektiertesObjekt->Position[1] -= Schrittweite;   /* y-Achse */
	  else if (w == EM_DarstellungXZ)
	       if (strcmp (*param, "Left") == 0)
		    selektiertesObjekt->Position[0] -= Schrittweite;   /* x-Achse */
	       else
		    selektiertesObjekt->Position[2] += Schrittweite;   /* z-Achse */
	  else if (w == EM_DarstellungYZ)
	       if (strcmp (*param, "Left") == 0)
		    selektiertesObjekt->Position[2] += Schrittweite;   /* z-Achse */
	       else
		    selektiertesObjekt->Position[1] -= Schrittweite;   /* y-Achse */
	  else
	       fprintf (stderr, "Something went wrong  (dec)!\n");
	  if (selektiertesObjekt->Art == ZUSGESOBJ)
	       ZusGesObjRot (selektiertesObjekt);
	  
	  sprintf (trans,"%.3f", selektiertesObjekt->Position[0]);
	  XtVaSetValues (NO_Pos_X, XtNstring, trans, NULL);
	  sprintf (trans,"%.3f", selektiertesObjekt->Position[1]);
	  XtVaSetValues (NO_Pos_Y, XtNstring, trans, NULL);
	  sprintf (trans,"%.3f", -selektiertesObjekt->Position[2]);
	  XtVaSetValues (NO_Pos_Z, XtNstring, trans, NULL);

	  AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
			      EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
			      DZoomFaktor, &aktuelleWelt->Welt, 
			      KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
     }
}


/*******************************************************************************
 *  void inc2 (Widget w, XtPointer Richtung, XtPointer muell)
 *
 *  Beschreibung:
 *  -------------
 *  Selbe Funktion wie inc, au"ser da"s diese Funktion "uber die entsprechenden
 *  Tasten im Objekt-Fenster ausgel"ost werden.
 ********************************************************************************/

void inc2 (Widget w, XtPointer Richtung, XtPointer muell)
{
     char *trans = malloc (20*sizeof (char));
     TReal Schrittweite = 0.05/DZoomFaktor;
     
     switch ((TRichtung) Richtung)
     {
       case XRich: selektiertesObjekt->Position[0] += Schrittweite;
	  break;
       case YRich: selektiertesObjekt->Position[1] += Schrittweite;
	  break;
       case ZRich: selektiertesObjekt->Position[2] -= Schrittweite;
	  break;
     }
     if (selektiertesObjekt->Art == ZUSGESOBJ)
	  ZusGesObjRot (selektiertesObjekt);
     
     sprintf (trans,"%.3f", selektiertesObjekt->Position[0]);
     XtVaSetValues (NO_Pos_X, XtNstring, trans, NULL);
     sprintf (trans,"%.3f", selektiertesObjekt->Position[1]);
     XtVaSetValues (NO_Pos_Y, XtNstring, trans, NULL);
     sprintf (trans,"%.3f", -selektiertesObjekt->Position[2]);
     XtVaSetValues (NO_Pos_Z, XtNstring, trans, NULL);
     
     AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
			 EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
			 DZoomFaktor, &aktuelleWelt->Welt, 
			 KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
}


/*******************************************************************************
 *  void dec2 (Widget w, XtPointer Richtung, XtPointer muell)
 *
 *  Beschreibung:
 *  -------------
 *  Selbe Funktion wie inc, au"ser da diese Funktion "uber die entsprechenden
 *  Tasten im Objekt-Fenster ausgel"ost werden.
 ********************************************************************************/

void dec2 (Widget w, XtPointer Richtung, XtPointer muell)
{
     char *trans = malloc (20*sizeof (char));
     TReal Schrittweite = 0.05/DZoomFaktor;

     switch ( (TRichtung) Richtung)
     {
       case XRich: selektiertesObjekt->Position[0] -= Schrittweite;
	  break;
       case YRich: selektiertesObjekt->Position[1] -= Schrittweite;
	  break;
       case ZRich: selektiertesObjekt->Position[2] += Schrittweite;
	  break;
     }
     if (selektiertesObjekt->Art == ZUSGESOBJ)
	  ZusGesObjRot (selektiertesObjekt);

     sprintf (trans,"%.3f", selektiertesObjekt->Position[0]);
     XtVaSetValues (NO_Pos_X, XtNstring, trans, NULL);
     sprintf (trans,"%.3f", selektiertesObjekt->Position[1]);
     XtVaSetValues (NO_Pos_Y, XtNstring, trans, NULL);
     sprintf (trans,"%.3f", -selektiertesObjekt->Position[2]);
     XtVaSetValues (NO_Pos_Z, XtNstring, trans, NULL);

     /**************************************************************************
      * In ferner Zukunft erfolgt jetzt eine Kollisionsbehandlung, die unter-
      * sucht, ob das Objekt "uberhaupt soweit in dieser Richtung bewegt werden
      * kann.
      **************************************************************************/
     AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
			 EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
			 DZoomFaktor, &aktuelleWelt->Welt, 
			 KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
}


/*******************************************************************************
 *  void newObjectWerteSetzen (Widget w, XtPointer clientData, XtPointer garbage)
 *
 *  Beschreibung:
 *  -------------
 *  Die Routine "ubernimmt die Gr"o"senparameter der einzelnen Objekte. Da sich
 *  die Werte ge"andert haben k"onnten, wird ein Redraw des Bildschirms durch-
 *  gefhrt.
 ********************************************************************************/
void newObjectWerteSetzen (Widget w, XEvent *event, String *param, Cardinal *numPar)
{
     char *Werte = malloc (20*sizeof(char));
     TBoolean Gravlos, Masselos;

     if (selektiertesObjekt != NULL)
     {
	  Gravlos = IstKoerperGravlos (selektiertesObjekt);
	  Masselos = IstKoerperMasselos (selektiertesObjekt); 
	  switch (selektiertesObjekt->Art)
	  {
	    case QUADER: 
	       XtVaGetValues (NO_Param1, XtNstring, &Werte, NULL);
	       selektiertesObjekt->Form.Quader.KantenLaenge[0] =  (TReal) atof (Werte);
	       UeberpruefeWert (&selektiertesObjekt->Form.Quader.KantenLaenge[0], NO_Param1);
	       XtVaGetValues (NO_Param2, XtNstring, &Werte, NULL);
	       selektiertesObjekt->Form.Quader.KantenLaenge[1] =  (TReal) atof (Werte);
	       UeberpruefeWert (&selektiertesObjekt->Form.Quader.KantenLaenge[1], NO_Param2);
	       XtVaGetValues (NO_Param3, XtNstring, &Werte, NULL);
	       selektiertesObjekt->Form.Quader.KantenLaenge[2] =  (TReal) atof (Werte);
	       UeberpruefeWert (&selektiertesObjekt->Form.Quader.KantenLaenge[2], NO_Param3);
	       KoeIniMech (selektiertesObjekt, aktuelleWelt->Welt.MaterialDaten);
	       break;
	    case KUGEL: 
	       XtVaGetValues (NO_Param1, XtNstring, &Werte, NULL);
	       selektiertesObjekt->Form.Kugel.Radius =  (TReal) atof (Werte);
	       UeberpruefeWert (&selektiertesObjekt->Form.Kugel.Radius, NO_Param1);
	       KoeIniMech (selektiertesObjekt, aktuelleWelt->Welt.MaterialDaten);
	       break;
	    case ZYLINDER: 
	       XtVaGetValues (NO_Param1, XtNstring, &Werte, NULL);
	       selektiertesObjekt->Form.Zylinder.Hoehe =  (TReal) atof (Werte);
	       UeberpruefeWert (&selektiertesObjekt->Form.Zylinder.Hoehe, NO_Param1);
	       XtVaGetValues (NO_Param2, XtNstring, &Werte, NULL);
	       selektiertesObjekt->Form.Zylinder.Radius =  (TReal) atof (Werte);
	       UeberpruefeWert (&selektiertesObjekt->Form.Zylinder.Radius, NO_Param2);
	       KoeIniMech (selektiertesObjekt, aktuelleWelt->Welt.MaterialDaten);
	    default: break;
	  }
	  XtVaGetValues (NO_Pos_X, XtNstring, &Werte, NULL);
	  selektiertesObjekt->Position[0] =  (TReal) atof (Werte);
	  XtVaGetValues (NO_Pos_Y, XtNstring, &Werte, NULL);
	  selektiertesObjekt->Position[1] =  (TReal) atof (Werte);
	  XtVaGetValues (NO_Pos_Z, XtNstring, &Werte, NULL);
	  selektiertesObjekt->Position[2] = - (TReal) atof (Werte);
	  if (selektiertesObjekt->Art == ZUSGESOBJ)
	       ZusGesObjRot (selektiertesObjekt);
	  
	  SetzeKoerperGravlos (selektiertesObjekt, Gravlos);
	  SetzeKoerperMasselos (selektiertesObjekt, Masselos);
	  AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
			      EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
			      DZoomFaktor, &aktuelleWelt->Welt, 
			      KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
     }
     else fprintf (stderr,"Please select an object first!\n");
}


/*******************************************************************************
 *  void uebernehmeFarbwerte (Widget w, XtPointer muell, XtPointer garbage)
 *
 *  Beschreibung:
 *  -------------
 *  Die Farbwerte werden erst bei Druck der Taste 'apply color' f"ur das Objekt
 *  "ubernommen.
 ********************************************************************************/

void uebernehmeFarbwerte (Widget w, XtPointer muell, XtPointer garbage)
{
   selektiertesObjekt->R = ScrRot;
   selektiertesObjekt->G = ScrGruen;
   selektiertesObjekt->B = ScrBlau;
   AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
		       EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
		       DZoomFaktor, &aktuelleWelt->Welt, 
		       KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
}


/*******************************************************************************
 *  void setzeFarbwerte (Widget w, XtPointer Farbe, XtPointer ThumbPos)
 *  XtPointer Farbe: einer der Werte Rot|Gruen|Blau. Wurde zunchst gebraucht,
 *               um die Schiebernderung direkt auf das Objekt zu bertra-
 *               en. Da eine nderung notwendig wurde, ist dieser Parameter
 *               nicht mehr von Bedeutung.
 *  XtPointer ThumbPos: Gibt die Position des Schiebereglers wieder. Dieser Pa-
 *               rameter ist seit der nderung auch nicht mehr von Bedeutung.
 *
 *  Beschreibung:
 *  -------------
 *  Die Routine wird aufgerufen, wenn sich in einem der drei Scollbars etwas ver-
 *  ndert hat. Aus Grnden der Farbbelegung wird der genderte Wert nicht
 *  mehr direkt in die Objektstruktur eingetragen. Statt dessen werden die
 *  Schieberpositionen abgefragt und die Farbe nur in einem seperaten Fenster
 *  angezeigt. Erst bei drcken der 'Apply'-Taste wird der Farbwert in die Kr-
 *  perstruktur ubernommen.
 ********************************************************************************/

void setzeFarbwerte (Widget w, XtPointer Farbe, XtPointer infoAboutThumb)
{
     XfwfScrollInfo *info = (XfwfScrollInfo *) infoAboutThumb;
     TReal          topOfThumb, increment, H, S, V;

     increment = 1.0/255.0;
     if (selektiertesObjekt != NULL)
     {
	  if (info->reason == XfwfSUp)
	       topOfThumb = max (info->vpos - increment, 0);
	  else if (info->reason == XfwfSDown)
	       topOfThumb = min (info->vpos + increment, 1);
	  else
	       topOfThumb = info->vpos;
	  XfwfSetScrollbar (w, topOfThumb, SliderSize);
	  switch ((TFarbe) Farbe)
	  {
	    case Rot: 
	       ScrRot =  (unsigned short) 65535* (1.0-topOfThumb);
	       break;
	    case Gruen: 
	       ScrGruen =  (unsigned short) 65535* (1.0-topOfThumb);
	       break;
	    case Blau:
	       ScrBlau =  (unsigned short) 65535* (1.0-topOfThumb);
	    default:
	       break;
	  }
	  /*****
	   * update der Farbe in NO_Farbe
	   *****/
	  if (convert_RGB_HSV (ScrRot, ScrGruen, ScrBlau, &H, &S, &V))
	  {
	       Scr_H = H;
	       XfwfSetScrollbar (NO_Scroll_H, 1.0 - Scr_H, SliderSize);
	  }
	  Scr_S = S;
	  Scr_V = V;
	  XfwfSetScrollbar (NO_Scroll_S, 1.0 - Scr_S, SliderSize);
	  XfwfSetScrollbar (NO_Scroll_V, 1.0 - Scr_V, SliderSize);
	  AnzeigeRGB (NO_Farbe, ScrRot, ScrGruen, ScrBlau);
     }
     else 
	  fprintf (stderr,"Please select an object first!\n");
}



void moving_HSV (Widget w, XtPointer Farbe, XtPointer infoAboutThumb)
{
     XfwfScrollInfo *info = (XfwfScrollInfo *) infoAboutThumb;
     TReal          topOfThumb, increment, R, G, B, H, S, V;

     increment = 1.0/255.0;
     if (selektiertesObjekt != NULL)
     {
	  if (info->reason == XfwfSUp)
	       topOfThumb = max (info->vpos - increment, 0);
	  else if (info->reason == XfwfSDown)
	       topOfThumb = min (info->vpos + increment, 1);
	  else
	       topOfThumb = info->vpos;
	  XfwfSetScrollbar (w, topOfThumb, SliderSize);
	  switch ((TFarbe) Farbe)
	  {
	    case M_H: 
	       Scr_H =  1.0 - topOfThumb;
	       break;
	    case M_S: 
	       Scr_S =  1.0 - topOfThumb;
	       break;
	    case M_V:
	       Scr_V =  1.0 - topOfThumb;
	    default:
	       break;
	  }
	  H = Scr_H; S = Scr_S; V = Scr_V;
	  convert_HSV_RGB (H, S, V, &R, &G, &B);
	  ScrRot = (unsigned short) 65535*R;
	  ScrGruen = (unsigned short) 65535*G;
	  ScrBlau = (unsigned short) 65535*B;
	  XfwfSetScrollbar (NO_ScrollRot, 1.0 - R, SliderSize);
	  XfwfSetScrollbar (NO_ScrollGruen, 1.0 - G, SliderSize);
	  XfwfSetScrollbar (NO_ScrollBlau, 1.0 - B, SliderSize);
	  /*****
	   * update der Farbe in NO_Farbe
	   *****/
	  AnzeigeRGB (NO_Farbe, ScrRot, ScrGruen, ScrBlau);
     }
     else 
	  fprintf (stderr,"Please select an object first!\n");
}


/*******************************************************************************
 *  void rotPlusSelektObj (Widget w, XtPointer Richtung, XtPointer muell)
 *
 *  Beschreibung:
 *  -------------
 *
 ********************************************************************************/

void rotPlusSelektObj (Widget w, XtPointer Richtung, XtPointer muell)
{
   if (selektiertesObjekt != NULL)
   {
      switch ( (TRichtung) Richtung)
      {
	 case XRich: Q_MUL (selektiertesObjekt->q, CRotXP, selektiertesObjekt->q);
	             break;
         case YRich: Q_MUL (selektiertesObjekt->q, CRotYP, selektiertesObjekt->q);
                     break;
         case ZRich: Q_MUL (selektiertesObjekt->q, CRotZM, selektiertesObjekt->q);
                     break;
      }
      if (selektiertesObjekt->Art == ZUSGESOBJ)
	 ZusGesObjRot (selektiertesObjekt);
      AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
                          EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
                          DZoomFaktor, &aktuelleWelt->Welt, 
			  KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
   }
   else fprintf (stderr,"Please select an object first!\n");
}


/*******************************************************************************
 *
 *
 *  Beschreibung:
 *  -------------
 *
 ********************************************************************************/

void rotMinusSelektObj (Widget w, XtPointer Richtung, XtPointer muell)
{
   if (selektiertesObjekt != NULL)
   {
      switch ( (TRichtung) Richtung)
      {
         case XRich: Q_MUL (selektiertesObjekt->q, CRotXM, selektiertesObjekt->q);
                     break;
         case YRich: Q_MUL (selektiertesObjekt->q, CRotYM, selektiertesObjekt->q);
                     break;
         case ZRich: Q_MUL (selektiertesObjekt->q, CRotZP, selektiertesObjekt->q);
                     break;
      }
      if (selektiertesObjekt->Art == ZUSGESOBJ)
	 ZusGesObjRot (selektiertesObjekt);
      AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
                          EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
                          DZoomFaktor, &aktuelleWelt->Welt, 
			  KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
   }
   else fprintf (stderr,"Please select an object first!\n");
}


/*******************************************************************************
 *
 *
 *  Beschreibung:
 *  -------------
 *
 ********************************************************************************/

void resetRotation (Widget w, XtPointer garbage, XtPointer muell)
{
   if (selektiertesObjekt != NULL)
   {
      selektiertesObjekt->q[0] = 1.0;
      selektiertesObjekt->q[1] = 0.0;
      selektiertesObjekt->q[2] = 0.0;
      selektiertesObjekt->q[3] = 0.0;
      if (selektiertesObjekt->Art == ZUSGESOBJ) 
	   ZusGesObjRot (selektiertesObjekt);
      AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
                          EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
                          DZoomFaktor, &aktuelleWelt->Welt, 
			  KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
   }
   else fprintf (stderr,"Please select an object first!\n");
}


void resetTranslat (Widget w, XtPointer muell, XtPointer garbage)
{
   if (selektiertesObjekt != NULL)
   {
      selektiertesObjekt->Position[0] = 0.0;
      selektiertesObjekt->Position[1] = 0.0;
      selektiertesObjekt->Position[2] = 0.0;
      if (selektiertesObjekt->Art == ZUSGESOBJ)
	 ZusGesObjRot (selektiertesObjekt);
      DObjektEinfuegen ();
   }
   else fprintf (stderr,"Please select an object first!\n");
}


/*******************************************************************************
 *
 *
 *  Beschreibung:
 *  -------------
 *
 ********************************************************************************/

void setzeMaterial (Widget w, XtPointer garbage, XtPointer selectMat)
{
   XfwfScrolledListReturnStruct *Mat =  (XfwfScrolledListReturnStruct *) selectMat;
   TBoolean Gravlos, Masselos;

   if (selektiertesObjekt != NULL && selektiertesObjekt->Art != ZUSGESOBJ)
   {
      selektiertesObjekt->Material = Mat->index;
      selektiertesObjekt->R = DefaultR (aktuelleWelt->Welt.MaterialDaten, selektiertesObjekt->Material);
      selektiertesObjekt->G = DefaultG (aktuelleWelt->Welt.MaterialDaten, selektiertesObjekt->Material);
      selektiertesObjekt->B = DefaultB (aktuelleWelt->Welt.MaterialDaten, selektiertesObjekt->Material);
      ScrRot = selektiertesObjekt->R;
      ScrGruen = selektiertesObjekt->G;
      ScrBlau = selektiertesObjekt->B;
      selektiertesObjekt->Durchsichtigkeit = DefaultDurchsichtigkeit (aktuelleWelt->Welt.MaterialDaten, selektiertesObjekt->Material);
      selektiertesObjekt->Reflexion = DefaultReflexion (aktuelleWelt->Welt.MaterialDaten, selektiertesObjekt->Material);
      selektiertesObjekt->Rauhigkeit = DefaultRauhigkeit (aktuelleWelt->Welt.MaterialDaten, selektiertesObjekt->Material);
#ifdef DREHREGLER
      setzeRegler ();
#endif
      AnzeigeRGB (NO_Farbe, ScrRot, ScrGruen, ScrBlau);
      setzeScrollbarPosition ();

      Gravlos = IstKoerperGravlos (selektiertesObjekt);
      Masselos = IstKoerperMasselos (selektiertesObjekt); 

      KoeIniMech (selektiertesObjekt, aktuelleWelt->Welt.MaterialDaten);
      SetzeKoerperMasselos (selektiertesObjekt, Masselos);
      SetzeKoerperGravlos (selektiertesObjekt, Gravlos);
      AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
                          EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
                          DZoomFaktor, &aktuelleWelt->Welt, KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
   }
   else fprintf (stderr,"Please select an object first!\n");
}

#ifdef DREHREGLER
void setzeDurchsichtigkeit (Widget w, XtPointer muell, XtPointer garbage)
{
   int Proz;
   char *trans = malloc (10*sizeof (char));

   XtVaGetValues (NO_Durchsicht, XtNvalue, &Proz, NULL);
   sprintf (trans, "    %.1f %% ", selektiertesObjekt->Durchsichtigkeit*100.0);
   selektiertesObjekt->Durchsichtigkeit = Proz/100.0;
   XtVaSetValues (NO_DurchsProz, XtNlabel, trans, NULL);
}


void setzeRauhigkeit (Widget w, XtPointer muell, XtPointer garbage)
{
     int Proz;
     char *trans = malloc (10*sizeof (char));

     XtVaGetValues (NO_Rauhigkeit, XtNvalue, &Proz, NULL);
     selektiertesObjekt->Rauhigkeit = Proz/100.0;
     sprintf (trans, "    %.1f %% ", selektiertesObjekt->Rauhigkeit*100.0);
     XtVaSetValues (NO_RauhigkeitProz, XtNlabel, trans, NULL);
}


void setzeReflexion (Widget w, XtPointer muell, XtPointer garbage)
{
   int Proz;
   char *trans = malloc (10*sizeof (char));

   XtVaGetValues (NO_Reflexion, XtNvalue, &Proz, NULL);
   selektiertesObjekt->Reflexion = Proz/100.0;
   sprintf (trans, "    %.1f %% ", selektiertesObjekt->Reflexion*100.0);
   XtVaSetValues (NO_ReflexionProz, XtNlabel, trans, NULL);
}
#endif


void toggleGravitation (Widget w, XtPointer muell, XtPointer garbage)
{
     if (selektiertesObjekt != NULL)
	  if (IstKoerperGravlos (selektiertesObjekt))
	  {
	       SetzeKoerperGravlos (selektiertesObjekt, FALSE);
	       XtVaSetValues (NO_GravLos, XtNstate, IstKoerperGravlos (selektiertesObjekt), NULL);
	  }
	  else
	  {
	       SetzeKoerperGravlos (selektiertesObjekt, TRUE);
	       XtVaSetValues (NO_GravLos, XtNstate, IstKoerperGravlos (selektiertesObjekt), NULL);
	  }
}


void toggleMasse (Widget w, XtPointer muell, XtPointer garbage)
{
     if (selektiertesObjekt != NULL)
	  if (IstKoerperMasselos (selektiertesObjekt))
	  {
	       SetzeKoerperMasselos (selektiertesObjekt, FALSE);
	       XtVaSetValues (NO_MasseLos, XtNstate, IstKoerperMasselos (selektiertesObjekt), NULL);
	  }
	  else
	  {
	       SetzeKoerperMasselos (selektiertesObjekt, TRUE);
	       XtVaSetValues (NO_MasseLos, XtNstate, IstKoerperMasselos (selektiertesObjekt), NULL);
	  }
}


/*******************************************************************************
 *  installObjektAktionen (void)
 *
 *  Beschreibung:
 *  -------------
 *  Installiert ein Window f"ur das Einf"ugen von Objekten, ...
 ********************************************************************************/

void installObjektAktionen (void)
{
   Widget NO_box, NO_box1, NO_FarbBox, NO_RotTxt, NO_GruenTxt, NO_BlauTxt,
          NO_panedBox, NO_PosXTxt, NO_PosYTxt, NO_PosZTxt, NO_box2, NO_H_Txt,
          NO_S_Txt, NO_V_Txt;
#ifdef DREHREGLER
   NO_DurchBox,  NO_RauhigkeitBox, NO_RauhigkeitTxt, NO_ReflexionBox, NO_ReflexionTxt, NO_box3;
#endif
   static XtActionsRec WerteSetzen[] = {{"newObjectWerteSetzen", newObjectWerteSetzen }};


   selektObjOLD =  (TKoerper *) malloc (sizeof (TKoerper));
   selektObjOLD->Art = NAGEL;
   NO_Shell = XtVaCreatePopupShell ("Object", topLevelShellWidgetClass, topLevel, NULL);
   NO_panedBox = XtVaCreateManagedWidget ("NO_panedBox", panedWidgetClass, NO_Shell, NULL);
   NO_ObjektInfo = XtVaCreateManagedWidget ("NO_ObjektInfo", labelWidgetClass, NO_panedBox, NULL);
   NO_box2 =XtVaCreateManagedWidget ("NO_box2", formWidgetClass, NO_panedBox, NULL); 
   NO_box = XtVaCreateManagedWidget ("NO_box", formWidgetClass, NO_panedBox, NULL);
#ifdef DREHREGLER
   NO_box3 = XtVaCreateManagedWidget ("NO_box3", formWidgetClass, NO_panedBox, NULL);
#endif
   NO_box1 = XtVaCreateManagedWidget ("NO_box1", formWidgetClass, NO_panedBox, NULL);

   /*****************************************************************************
    * Erster Block
    *****************************************************************************/
   NO_GravLos = XtVaCreateManagedWidget ("NO_GravLos", toggleWidgetClass, NO_box2, NULL);
   NO_MasseLos = XtVaCreateManagedWidget ("NO_MasseLos", toggleWidgetClass, NO_box2, NULL);

   /*****************************************************************************
    * Zweiter Block
    *****************************************************************************/
   NO_FarbBox = XtVaCreateManagedWidget ("NO_FarbBox", formWidgetClass, NO_box, NULL);
   NO_RotTxt = XtVaCreateManagedWidget ("NO_RotTxt", labelWidgetClass, NO_FarbBox, NULL);
   NO_ScrollRot = XtVaCreateManagedWidget ("NO_ScrollRot", xfwfVScrollbarWidgetClass, NO_FarbBox, NULL);
   NO_GruenTxt = XtVaCreateManagedWidget ("NO_GruenTxt", labelWidgetClass, NO_FarbBox, NULL);
   NO_ScrollGruen = XtVaCreateManagedWidget ("NO_ScrollGruen", xfwfVScrollbarWidgetClass, NO_FarbBox, NULL);
   NO_BlauTxt = XtVaCreateManagedWidget ("NO_BlauTxt", labelWidgetClass, NO_FarbBox, NULL);
   NO_ScrollBlau = XtVaCreateManagedWidget ("NO_ScrollBlau", xfwfVScrollbarWidgetClass, NO_FarbBox, NULL);
   NO_H_Txt = XtVaCreateManagedWidget ("NO_H_Txt", labelWidgetClass, NO_FarbBox, NULL);
   NO_Scroll_H = XtVaCreateManagedWidget ("NO_Scroll_H", xfwfVScrollbarWidgetClass, NO_FarbBox, NULL);
   NO_S_Txt = XtVaCreateManagedWidget ("NO_S_Txt", labelWidgetClass, NO_FarbBox, NULL);
   NO_Scroll_S = XtVaCreateManagedWidget ("NO_Scroll_S", xfwfVScrollbarWidgetClass, NO_FarbBox, NULL);
   NO_V_Txt = XtVaCreateManagedWidget ("NO_V_Txt", labelWidgetClass, NO_FarbBox, NULL);
   NO_Scroll_V = XtVaCreateManagedWidget ("NO_Scroll_V", xfwfVScrollbarWidgetClass, NO_FarbBox, NULL);
   NO_neuesMat = XtVaCreateManagedWidget ("NO_neuesMat", commandWidgetClass, NO_box, NULL);
   NO_showMat = XtVaCreateManagedWidget ("NO_showMat", commandWidgetClass, NO_box, NULL);
   NO_Material = XtVaCreateManagedWidget ("NO_Material", xfwfScrolledListWidgetClass, NO_box, NULL);
   NO_Farbe = XtVaCreateManagedWidget ("NO_Farbe", simpleWidgetClass, NO_box, NULL);
   XfwfScrolledListSetList (NO_Material, MaterialienListe, 0, TRUE, NULL);
   NO_Apply = XtVaCreateManagedWidget ("NO_Apply", commandWidgetClass, NO_box, NULL);
   XfwfSetScrollbar (NO_ScrollRot, 1.0, SliderSize);
   XfwfSetScrollbar (NO_ScrollGruen, 1.0, SliderSize);
   XfwfSetScrollbar (NO_ScrollBlau, 1.0, SliderSize);
   XfwfSetScrollbar (NO_Scroll_H, 1.0, SliderSize);
   XfwfSetScrollbar (NO_Scroll_S, 1.0, SliderSize);
   XfwfSetScrollbar (NO_Scroll_V, 1.0, SliderSize);

#ifdef DREHREGLER
   NO_DurchBox = XtVaCreateManagedWidget ("NO_DurchBox", panedWidgetClass, NO_box3, NULL);
   NO_DurchsichtTxt = XtVaCreateManagedWidget ("NO_DurchsichtTxt", labelWidgetClass, NO_DurchBox, NULL);
   NO_Durchsicht = XtVaCreateManagedWidget ("NO_Durchsicht", rheostatWidgetClass, NO_DurchBox, NULL);
   NO_DurchsProz = XtVaCreateManagedWidget ("NO_DurchsProz", labelWidgetClass, NO_DurchBox, NULL);

   NO_RauhigkeitBox  = XtVaCreateManagedWidget ("NO_RauhigkeitBox", panedWidgetClass, NO_box3, NULL);
   NO_RauhigkeitTxt  = XtVaCreateManagedWidget ("NO_RauhigkeitTxt", labelWidgetClass, NO_RauhigkeitBox, NULL);
   NO_Rauhigkeit     = XtVaCreateManagedWidget ("NO_Rauhigkeit", rheostatWidgetClass, NO_RauhigkeitBox, NULL);
   NO_RauhigkeitProz = XtVaCreateManagedWidget ("NO_RauhigkeitProz", labelWidgetClass, NO_RauhigkeitBox, NULL);

   NO_ReflexionBox  = XtVaCreateManagedWidget ("NO_ReflexionBox", panedWidgetClass, NO_box3, NULL);
   NO_ReflexionTxt  = XtVaCreateManagedWidget ("NO_ReflexionTxt", labelWidgetClass, NO_ReflexionBox, NULL);
   NO_Reflexion     = XtVaCreateManagedWidget ("NO_Reflexion", rheostatWidgetClass, NO_ReflexionBox, NULL);
   NO_ReflexionProz = XtVaCreateManagedWidget ("NO_ReflexionProz", labelWidgetClass, NO_ReflexionBox, NULL);
#endif

   /*****************************************************************************
    * Dritter Block
    *****************************************************************************/
   NO_Param1Txt = XtVaCreateManagedWidget ("NO_Param1Txt", labelWidgetClass, NO_box1, NULL);
   NO_Param1 = XtVaCreateManagedWidget ("NO_Param1", asciiTextWidgetClass, NO_box1, NULL);
   NO_Param2Txt = XtVaCreateManagedWidget ("NO_Param2Txt", labelWidgetClass, NO_box1, NULL);
   NO_Param2 = XtVaCreateManagedWidget ("NO_Param2", asciiTextWidgetClass, NO_box1, NULL);
   NO_Param3Txt = XtVaCreateManagedWidget ("NO_Param3Txt", labelWidgetClass, NO_box1, NULL);
   NO_Param3 = XtVaCreateManagedWidget ("NO_Param3", asciiTextWidgetClass, NO_box1, NULL);

   NO_PosXTxt = XtVaCreateManagedWidget ("NO_PosXTxt", labelWidgetClass, NO_box1, NULL);
   NO_Pos_X = XtVaCreateManagedWidget ("NO_Pos_X", asciiTextWidgetClass, NO_box1, NULL);
   NO_PosYTxt = XtVaCreateManagedWidget ("NO_PosYTxt", labelWidgetClass, NO_box1, NULL);
   NO_Pos_Y = XtVaCreateManagedWidget ("NO_Pos_Y", asciiTextWidgetClass, NO_box1, NULL);
   NO_PosZTxt = XtVaCreateManagedWidget ("NO_PosZTxt", labelWidgetClass, NO_box1, NULL);
   NO_Pos_Z = XtVaCreateManagedWidget ("NO_Pos_Z", asciiTextWidgetClass, NO_box1, NULL);

   NO_rotXP = XtVaCreateManagedWidget ("NO_rotXP", repeaterWidgetClass, NO_box1, XtNbitmap, BRotXP, NULL);
   NO_rotYP = XtVaCreateManagedWidget ("NO_rotYP", repeaterWidgetClass, NO_box1, XtNbitmap, BRotYP, NULL);
   NO_rotZP = XtVaCreateManagedWidget ("NO_rotZP", repeaterWidgetClass, NO_box1, XtNbitmap, BRotZP, NULL);
   NO_rotXM = XtVaCreateManagedWidget ("NO_rotXM", repeaterWidgetClass, NO_box1, XtNbitmap, BRotXM, NULL);
   NO_rotYM = XtVaCreateManagedWidget ("NO_rotYM", repeaterWidgetClass, NO_box1, XtNbitmap, BRotYM, NULL);
   NO_rotZM = XtVaCreateManagedWidget ("NO_rotZM", repeaterWidgetClass, NO_box1, XtNbitmap, BRotZM, NULL);
   NO_movXP = XtVaCreateManagedWidget ("NO_movXP", repeaterWidgetClass, NO_box1, XtNbitmap, BMovXP, NULL);
   NO_movYP = XtVaCreateManagedWidget ("NO_movYP", repeaterWidgetClass, NO_box1, XtNbitmap, BMovYP, NULL);
   NO_movZP = XtVaCreateManagedWidget ("NO_movZP", repeaterWidgetClass, NO_box1, XtNbitmap, BMovZP, NULL);
   NO_movXM = XtVaCreateManagedWidget ("NO_movXM", repeaterWidgetClass, NO_box1, XtNbitmap, BMovXM, NULL);
   NO_movYM = XtVaCreateManagedWidget ("NO_movYM", repeaterWidgetClass, NO_box1, XtNbitmap, BMovYM, NULL);
   NO_movZM = XtVaCreateManagedWidget ("NO_movZM", repeaterWidgetClass, NO_box1, XtNbitmap, BMovZM, NULL);
   NO_ResetRot = XtVaCreateManagedWidget ("NO_ResetRot", commandWidgetClass, NO_box1, NULL);
   NO_ResetMov = XtVaCreateManagedWidget ("NO_ResetMov", commandWidgetClass, NO_box1, NULL);
   NO_Undo = XtVaCreateManagedWidget ("NO_Undo", commandWidgetClass, NO_box1, NULL);

   XtAddCallback (NO_Undo, XtNcallback, newObjectUndo,  (XtPointer) NO_Shell);
   XtAppAddActions (appContext, WerteSetzen, XtNumber (WerteSetzen));
   XtAddCallback (NO_ScrollRot, XtNscrollCallback, setzeFarbwerte,  (XtPointer) Rot);
   XtAddCallback (NO_ScrollGruen, XtNscrollCallback, setzeFarbwerte,  (XtPointer) Gruen);
   XtAddCallback (NO_ScrollBlau, XtNscrollCallback, setzeFarbwerte,  (XtPointer) Blau);
   XtAddCallback (NO_Scroll_H, XtNscrollCallback, moving_HSV, (XtPointer) M_H);
   XtAddCallback (NO_Scroll_S, XtNscrollCallback, moving_HSV, (XtPointer) M_S);
   XtAddCallback (NO_Scroll_V, XtNscrollCallback, moving_HSV, (XtPointer) M_V);
   XtAddCallback (NO_Apply, XtNcallback, uebernehmeFarbwerte, NULL);
   XtAddCallback (NO_rotXP, XtNcallback, rotPlusSelektObj,  (XtPointer) XRich);
   XtAddCallback (NO_rotXM, XtNcallback, rotMinusSelektObj,  (XtPointer) XRich);
   XtAddCallback (NO_rotYP, XtNcallback, rotPlusSelektObj,  (XtPointer) YRich);
   XtAddCallback (NO_rotYM, XtNcallback, rotMinusSelektObj,  (XtPointer) YRich);
   XtAddCallback (NO_rotZP, XtNcallback, rotPlusSelektObj,  (XtPointer) ZRich);
   XtAddCallback (NO_rotZM, XtNcallback, rotMinusSelektObj,  (XtPointer) ZRich);
   XtAddCallback (NO_movXP, XtNcallback, inc2,  (XtPointer) XRich);
   XtAddCallback (NO_movXM, XtNcallback, dec2,  (XtPointer) XRich);
   XtAddCallback (NO_movYP, XtNcallback, inc2,  (XtPointer) YRich);
   XtAddCallback (NO_movYM, XtNcallback, dec2,  (XtPointer) YRich);
   XtAddCallback (NO_movZP, XtNcallback, inc2,  (XtPointer) ZRich);
   XtAddCallback (NO_movZM, XtNcallback, dec2,  (XtPointer) ZRich);
   XtAddCallback (NO_Material, XtNcallback, setzeMaterial, NULL);
   XtAddCallback (NO_ResetRot, XtNcallback, resetRotation, NULL);
   XtAddCallback (NO_ResetMov, XtNcallback, resetTranslat, NULL);
   XtAddCallback (NO_neuesMat, XtNcallback, initNeuesMaterial, NULL);
   XtAddCallback (NO_showMat, XtNcallback, initMaterialDaten, NULL);
#ifdef DREHREGLER
   XtAddCallback (NO_Durchsicht, XtNsetCallback, setzeDurchsichtigkeit, NULL);
   XtAddCallback (NO_Rauhigkeit, XtNsetCallback, setzeRauhigkeit, NULL);
   XtAddCallback (NO_Reflexion, XtNsetCallback, setzeReflexion, NULL);
#endif
   XtAddCallback (NO_GravLos, XtNcallback, toggleGravitation, NULL);
   XtAddCallback (NO_MasseLos, XtNcallback, toggleMasse, NULL);
}


/*******************************************************************************
 *  void entferneObjektVerb (TKoerper *selekt)
 *  TKoerper *selekt: Zeiger auf das zu entfernende Objekt.
 *
 *  Beschreibung:
 *  -------------
 *  Die Routine entfernt alle Verbindungen, die den K"orper selekt als Verbin-
 *  dungspartner haben. Dabei wird mit zwei Zeigern durch die Verbindungsliste
 *  gehangelt. Der Erste l"auft dem Zweiten vorraus. Ist eine Verbindung mit dem
 *  Objekt 'selekt' gefunden, so wird sie aus der Liste entfernt.
 ********************************************************************************/

void entferneObjektVerb (TKoerper *selekt)
{
   TVerbindung *help1, *help2;

   help1 = aktuelleWelt->Welt.Verbindungen;
   help2 = NULL;
   while (help1 != NULL)
      if (selekt == help1->Koerper1 || selekt == help1->Koerper2)
         if (help2 == NULL)
         {
            aktuelleWelt->Welt.Verbindungen = help1->Naechste;
            free (help1);
            help1 = aktuelleWelt->Welt.Verbindungen;
         }
         else
         {
            help2->Naechste = help1->Naechste;
            free (help1);
            help1 = help2->Naechste;
         }
      else
      {
         help2 = help1;
         help1 = help1->Naechste;
      }
}


void Aktion_entferneAll (Widget w, XtPointer muell, XtPointer garbage)
{
     if (AnimKamera.MountObj != NULL)
     {
	  AnimKamera.MountObj = NULL;
	  AnimKamera.MountObjId = 0;
     }
     entferneZustand (&aktuelleWelt->Welt);
     SelektAllButtons (FALSE);
     XtSetSensitive (EM_neuesObjekt, TRUE);
     selektiertesObjekt = NULL;
     toggleNOStatus (FALSE);
     AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
			 EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
			 DZoomFaktor, &aktuelleWelt->Welt, 
			 KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
}



void entferneKraft (TKraft **Geloescht, TKoerper *Finde)
{
   TKraft *h1, *h2;
   
   h1 = *Geloescht;
   h2 = NULL;
   while (h1 != NULL)
      if (h1->Typ == GERICHTET && h1->KD.GerKraft.ZielKoerper == Finde)
         /* Es wurde eine gerichtete Kraft mit Zielkoerper gleich dem zu
            l"oschenden Objekt gefunden, d.h. es mu"s entfernt werden  */
         if (h2 == NULL)
         {
            *Geloescht = h1->Naechste;
            free (h1);
            h1 = *Geloescht;
         }
         else
         {
            h2->Naechste = h1->Naechste;
            free (h1);
            h1 = h2->Naechste;
         }
      else
      {
         h2 = h1;
         h1 = h1->Naechste;
      }
}


void entferneGerichteteKraft (TKoerper *entfernendesObjekt)
{
   TKoerper *help;
   
   help = aktuelleWelt->Welt.Koerper;
   while (help != NULL)
   {
      entferneKraft (&help->Kraefte, entfernendesObjekt);
      help = help->Naechster;
   }
}


/*******************************************************************************
 *  void Aktion_entferneObjekt (void)
 *
 *  Beschreibung:
 *  -------------
 *  Diese Routine wird von der Routine selektAuswahlApply aufgerufen. Sie ent-
 *  fernt das durch selektiertesObjekt referenzierte Objekt.
 *    Dabei ist eine Fallunterscheidung zu treffen:
 *      o ist das gew"ahlte Objekt am Anfang der Liste, mu"s der Anfang auf
 *        das folgende Objekt gesetzt werden.
 *      o ansonsten mu"s man das Element vor dem gew"ahlten ausfindig machen,
 *        um das Objekt aush"angen zu k"onnen und nicht einen Teil der Liste zu
 *        verlieren.
 *  Was nicht vergessen werden darf, ist die Tatsache, da"s an einem Objekt eine
 *  Verbindung h"angen kann. Wird das Objekt entfernt, so m"ussen auch alle an
 *  ihm h"angenden Verbindungen gel"oscht werden!
 *  Ist nach dieser Operation kein Objekt mehr vorhanden sind einige Operationen
 *  nicht mehr sinnvoll. Die Buttons werden deaktiviert.
 ********************************************************************************/

void Aktion_entferneObjekt (Widget w, XtPointer garbage, XtPointer muell)
{
     TKoerper *help;

     help = aktuelleWelt->Welt.Koerper;
     UnHighLight (selektiertesObjekt);
     entferneObjektVerb (selektiertesObjekt);
     entferneGerichteteKraft (selektiertesObjekt);
     SelektAllButtons (FALSE);
     if (selektiertesObjekt == help) /* Objekt steht am Anfang der Liste */
     {
	  aktuelleWelt->Welt.Koerper = help->Naechster;
	  free (help);
	  selektiertesObjekt = NULL;
	  help = aktuelleWelt->Welt.Koerper;
     }
     else
     {
	  while ( (help->Naechster != NULL) && (help->Naechster != selektiertesObjekt))
	       help = help->Naechster;
	  if (help == NULL)
	       fprintf (stderr,"Something went terribly wrong  (Aktion_entferneObjekt, while)\n");
	  else
	  {
	       help->Naechster = selektiertesObjekt->Naechster;
	       free (selektiertesObjekt);
	       selektiertesObjekt = NULL;
	  }
     }
     if (aktuelleWelt->Welt.Koerper != NULL)
     {
	  SelektAllButtons (TRUE);
	  if (help != NULL)
	       selektiertesObjekt = help;
	  else
	       selektiertesObjekt = aktuelleWelt->Welt.Koerper;
	  HighLight (selektiertesObjekt);
	  DObjektEinfuegen ();
     }
     else
     {
	  toggleNOStatus (FALSE);
	  AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
			      EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
			      DZoomFaktor, &aktuelleWelt->Welt,
			      KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
     }
     XtSetSensitive (EM_neuesObjekt, TRUE);
     SelektKontext = Selektion;
}


/*******************************************************************************
 *  Aktion_loescheVerbindung ()
 *
 *  Beschreibung:
 *  -------------
 *  The selected link (selektierteVerbindung) is removed from the list of all
 *  links. To remove it, we have to check, wether the link is the first entry
 *  or not. If so, we just have to set the begining of the list to the next
 *  entry. Otherwise we have to find the link before the selected one.
 *       If there is no link after removing the selected, we disable some
 *  buttons (EM_entferneVerb, EM_aenderVerb). 
 ********************************************************************************/

void Aktion_loescheVerbindung (void)
{
     TVerbindung *help;
     
     help = aktuelleWelt->Welt.Verbindungen;
     UnHighLightVerb (selektierteVerbindung); 
     if (selektierteVerbindung == help)   /* Verbindung ist erster Eintrag der Liste */
     {
	  aktuelleWelt->Welt.Verbindungen = help->Naechste;
	  free (help);
	  selektierteVerbindung = NULL;
     }
     else
     {
	  while ( (help->Naechste != NULL) &&  (help->Naechste != selektierteVerbindung))
	       help = help->Naechste;
	  if (help == NULL)
	       fprintf (stderr,"Something went terribly wrong  (Aktion_loescheVerbindung, while)\n");
	  else
	  {
	       help->Naechste = selektierteVerbindung->Naechste;
	       free (selektierteVerbindung);
	       selektierteVerbindung = NULL;
	  }
     }
     if (aktuelleWelt->Welt.Verbindungen == NULL)
     {
	  XtSetSensitive (EM_entferneVerb, FALSE);
	  XtSetSensitive (EM_aenderVerb, FALSE);
     }
     SelektKontext = Selektion;
     AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
			 EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
			 DZoomFaktor, &aktuelleWelt->Welt,
			 KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
}


/*******************************************************************************
 *  
 *
 *  Beschreibung:
 *  -------------
 *  
 ********************************************************************************/

void Aktion_aenderVerbindungInit (void)
{
     char *trans = malloc (20*sizeof (char));

     XtRealizeWidget (AV_Shell);
     SelektKontext = Selektion;
     switch (selektierteVerbindung->Art)
     {
       case FEDER: 
	  XtVaSetValues (AV_VerbInfo, XtNlabel,"Type of selected link: spring", NULL);
	  XtVaSetValues (AV_Param1Txt, XtNlabel,"spring length in\nequlibrium", NULL);
	  XtVaSetValues (AV_Param2Txt, XtNlabel,"spring constant", NULL);
	  sprintf (trans,"%.3f", selektierteVerbindung->VerParameter.Feder.Ruhelaenge);
	  XtVaSetValues (AV_Param1, XtNstring, trans, NULL);
	  sprintf (trans,"%.3f", selektierteVerbindung->VerParameter.Feder.Federkonstante);
	  XtVaSetValues (AV_Param2, XtNstring, trans, NULL);
	  XtSetSensitive (AV_Param1, TRUE);
	  XtSetSensitive (AV_Param2, TRUE);
	  break;
       case DAEMPFER: 
	  XtVaSetValues (AV_VerbInfo, XtNlabel,"Type of selected link: damper", NULL);
	  XtVaSetValues (AV_Param1Txt, XtNlabel,"damper constant", NULL);
	  XtVaSetValues (AV_Param2Txt, XtNlabel,"", NULL);
	  sprintf (trans,"%.3f", selektierteVerbindung->VerParameter.Daempfer.Daempfungskonstante);
	  XtVaSetValues (AV_Param1, XtNstring, trans, NULL);
	  XtSetSensitive (AV_Param1, TRUE);
	  XtSetSensitive (AV_Param2, FALSE);
	  XtVaSetValues (AV_Param2, XtNstring, "", NULL);
	  break;
       case STANGE: 
	  XtVaSetValues (AV_VerbInfo, XtNlabel,"Type of selected link: rod", NULL);
	  XtVaSetValues (AV_Param1Txt, XtNlabel,"", NULL);
	  XtVaSetValues (AV_Param1, XtNstring, "", NULL);
	  XtSetSensitive (AV_Param1, FALSE);
	  XtVaSetValues (AV_Param2Txt, XtNlabel,"", NULL);
	  XtVaSetValues (AV_Param2, XtNstring, "", NULL);
	  XtSetSensitive (AV_Param2, FALSE);
	  break;
      case GELENK: 
	  XtVaSetValues (AV_VerbInfo, XtNlabel,"Type of selected link: joint", NULL);
	  XtVaSetValues (AV_Param1Txt, XtNlabel,"", NULL);
	  XtVaSetValues (AV_Param2Txt, XtNlabel,"", NULL);
	  XtSetSensitive (AV_Param1, FALSE);
	  XtSetSensitive (AV_Param2, FALSE);
	  XtVaSetValues (AV_Param1, XtNstring, "", NULL);
	  XtVaSetValues (AV_Param2, XtNstring, "", NULL);
	  break;
     }
     
     /* Jetzt werden die Koordinaten f"ur beide Verbindungspartner gesetzt. */
     sprintf (trans, "%.3f", selektierteVerbindung->VPunkt1[0]);
     XtVaSetValues (AV_K1X, XtNstring, trans, NULL);
     sprintf (trans, "%.3f", selektierteVerbindung->VPunkt1[1]);
     XtVaSetValues (AV_K1Y, XtNstring, trans, NULL);
     sprintf (trans, "%.3f", selektierteVerbindung->VPunkt1[2]);
     XtVaSetValues (AV_K1Z, XtNstring, trans, NULL);
     sprintf (trans, "%.3f", selektierteVerbindung->VPunkt2[0]);
     XtVaSetValues (AV_K2X, XtNstring, trans, NULL);
     sprintf (trans, "%.3f", selektierteVerbindung->VPunkt2[1]);
     XtVaSetValues (AV_K2Y, XtNstring, trans, NULL);
     sprintf (trans, "%.3f", selektierteVerbindung->VPunkt2[2]);
     XtVaSetValues (AV_K2Z, XtNstring, trans, NULL);
     
     XtPopup (AV_Shell, XtGrabNone);
}


/*******************************************************************************
 *
 *  Beschreibung:
 *  -------------
 *
 ********************************************************************************/

void selektiereAuswahlInit (Widget w, XtPointer garbage, XtPointer muell)
{
     if (SelektKontext == baueVerbindung || SelektKontext == anlegeKraft)
     {
	  if (SelektKontext == baueVerbindung)
	       XtVaSetValues (SA_label, XtNlabel,
			      "... next object\n to link with mouse.\n Press apply"
			      " when selected", NULL);
	  else 
	       XtVaSetValues (SA_label, XtNlabel,
			      "... an object\n to add force with mouse.\n Press apply"
			      " when selected", NULL);
/*	  selektAlternativ = aktuelleWelt->Welt.Koerper; */
	  if (aktuelleWelt->Welt.Koerper->Naechster == NULL)
	       XtSetSensitive (SA_Next, FALSE);
	  else
	       XtSetSensitive (SA_Next, TRUE);
	  XtPopup (SA_Shell, XtGrabNone);
     }
     else
     {
	  if (SelektKontext == aenderVerbindung)
	       XtVaSetValues (SA_label, XtNlabel,"... a link\n to change link parameter", NULL);
	  else if (SelektKontext == loescheVerbindung)
	       XtVaSetValues (SA_label, XtNlabel,"... a link\n to remove it", NULL);
	  selektierteVerbindung = aktuelleWelt->Welt.Verbindungen;
	  if (selektierteVerbindung->Naechste == NULL)
	  {
	       if (SelektKontext == loescheVerbindung)
		    Aktion_loescheVerbindung ();
	       else if (SelektKontext == aenderVerbindung)
		    Aktion_aenderVerbindungInit ();
	  }
	  else
	  {
	       XtSetSensitive (SA_Next, TRUE);
	       XtPopup (SA_Shell, XtGrabNone);
	       HighLightVerb (selektierteVerbindung); 
	  }
     }
}


/*******************************************************************************
 *  void Aktion_baueVerbindung (void)
 *
 *  Beschreibung:
 *  -------------
 ********************************************************************************/

void Aktion_baueVerbindung (void)
{
     if (selektierteVerbindung->Koerper1 == NULL)
     {
	  selektierteVerbindung->Koerper1 = selektiertesObjekt;
	  /**************************************************************************
	   * Es fehlt noch eine Routine zur Bestimmung des Angriffspunktes f"ur die
	   * Verbindung. D.h. der Beginn der Verbindung ist noch nicht festgelegt.
	   * Stattdessen wird mom. nur der Mittelpunkt des Objektes genommen.
	   **************************************************************************/
	  selektierteVerbindung->VPunkt1[0] = 0.0;
	  selektierteVerbindung->VPunkt1[1] = 0.0;
	  selektierteVerbindung->VPunkt1[2] = 0.0;
	  markPosition->Position[0] = selektiertesObjekt->Position[0];
	  markPosition->Position[1] = selektiertesObjekt->Position[1];
	  markPosition->Position[2] = selektiertesObjekt->Position[2];
	  markPosition->Naechster = aktuelleWelt->Welt.Koerper;
	  aktuelleWelt->Welt.Koerper = markPosition;
	  AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
			      EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
			      DZoomFaktor, &aktuelleWelt->Welt,
			      KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
	  
	  XtPopup (VP_Shell, XtGrabNone);
     }
     else if (selektierteVerbindung->Koerper2 == NULL)
     {
	  if (selektiertesObjekt == selektierteVerbindung->Koerper1)
	  {
	       fprintf (stderr,"it's not allowed to have the same objekt in a link!\n");
	       fprintf (stderr,"please select another object\n");
	       selektiereAuswahlInit (topLevel, NULL, NULL);
	  }
	  else
	  {
	       selektierteVerbindung->Koerper2 = selektiertesObjekt;
	       selektierteVerbindung->Naechste = aktuelleWelt->Welt.Verbindungen;
	       aktuelleWelt->Welt.Verbindungen = selektierteVerbindung;
	       if (selektierteVerbindung->Art == GELENK)
	       {
		    TQuaternion q2;
		    TMatrix Matrix, Matrix2;
		    TVektor V1;
		    
		    RotMatrix (Matrix, selektierteVerbindung->Koerper1->q);
		    MV_MUL2 (V1, Matrix, selektierteVerbindung->VPunkt1);
		    V1[0] += selektierteVerbindung->Koerper1->Position[0];
		    V1[1] += selektierteVerbindung->Koerper1->Position[1];
		    V1[2] += selektierteVerbindung->Koerper1->Position[2];
		    V1[0] -= selektierteVerbindung->Koerper2->Position[0];
		    V1[1] -= selektierteVerbindung->Koerper2->Position[1];
		    V1[2] -= selektierteVerbindung->Koerper2->Position[2];
		    q2[0] = selektierteVerbindung->Koerper2->q[0];
		    q2[1] = -selektierteVerbindung->Koerper2->q[1];
		    q2[2] = -selektierteVerbindung->Koerper2->q[2];
		    q2[3] = -selektierteVerbindung->Koerper2->q[3];
		    RotMatrix (Matrix2, q2);  
		    MV_MUL2 (selektierteVerbindung->VPunkt2, Matrix2, V1);
		    SelektAllButtons (TRUE); 
		    SelektKontext = Selektion;
	       }
	       else
	       {
		    selektierteVerbindung->VPunkt2[0] = 0.0;
		    selektierteVerbindung->VPunkt2[1] = 0.0;
		    selektierteVerbindung->VPunkt2[2] = 0.0;
		    markPosition->Position[0] = selektiertesObjekt->Position[0];
		    markPosition->Position[1] = selektiertesObjekt->Position[1];
		    markPosition->Position[2] = selektiertesObjekt->Position[2];
		    markPosition->Naechster = aktuelleWelt->Welt.Koerper;
		    aktuelleWelt->Welt.Koerper = markPosition;
		    XtPopup (VP_Shell, XtGrabNone);
	       }
	       AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
				   EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
				   DZoomFaktor, &aktuelleWelt->Welt,
				   KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
	  }
     }
     else fprintf (stderr,"Something went terribly wrong in Aktion_baueVerbindung!\n");
}


/*******************************************************************************
 *  void selektiereErstesObjekt (Widget w, XtPointer muell, XtPointer garbage)
 *
 *  Beschreibung:
 *  -------------
 *  Die Routine setzt das selektierte Objekt auf das erste Objekt in der Liste,
 *  d.h. das zuletzt eingef"ugte. Mittels der Routine DObjektEinfuegne werden
 *  die Daten des ausgew"ahlten Objekte im Objekt-Fenster angezeigt.
 ********************************************************************************/

void selektiereErstesObjekt (Widget w, XtPointer muell, XtPointer garbage)
{
   UnHighLight (selektiertesObjekt);
   selektiertesObjekt = aktuelleWelt->Welt.Koerper;
   HighLight (selektiertesObjekt);
   DObjektEinfuegen ();
}


/*******************************************************************************
 *  void selektiereAuswahlNext (Widget w, XtPointer clientData, XtPointer garbage)
 *
 *  Beschreibung:
 *  -------------
 *
 ********************************************************************************/

void selektiereAuswahlNext (Widget w, XtPointer clientData, XtPointer garbage)
{
     if (SelektKontext == baueVerbindung || SelektKontext == anlegeKraft) {
	  UnHighLight (selektiertesObjekt);
	  if (selektiertesObjekt->Naechster != NULL)
	       selektiertesObjekt = selektiertesObjekt->Naechster;
	  else 
	       selektiertesObjekt = aktuelleWelt->Welt.Koerper;
	  DObjektEinfuegen ();
	  HighLight (selektiertesObjekt);
     }
     else if (SelektKontext == Selektion) {
	  UnHighLight (selektiertesObjekt);
	  if (selektiertesObjekt->Naechster != NULL)
	       selektiertesObjekt = selektiertesObjekt->Naechster;
	  else selektiertesObjekt = aktuelleWelt->Welt.Koerper;
	  HighLight (selektiertesObjekt);
	  DObjektEinfuegen ();
     }
     else {
	  UnHighLightVerb (selektierteVerbindung);
	  if (selektierteVerbindung->Naechste != NULL)
	       selektierteVerbindung = selektierteVerbindung->Naechste;
	  else selektierteVerbindung = aktuelleWelt->Welt.Verbindungen;
	  HighLightVerb (selektierteVerbindung);
     }
}


/*******************************************************************************
 *  void selektiereAuswahlApply (Widget w, XtPointer clientData, XtPointer garbage)
 *
 *  Beschreibung:
 *  -------------
 *  Die Routine wird aufgerufen wenn ein Objekt ausgew"ahlt wurde. Zunaechst
 *  werden alle verbleibenden Elemente aus der Auswahlliste rausgeworfen. Dann
 *  wird entsprechend dem Flag 'SelektKontext' eine entsprechende Routine zur
 *  Weiterverarbeitung des ausgew"ahlten Objektes aufgerufen.
 ********************************************************************************/

void selektiereAuswahlApply (Widget w, XtPointer muell, XtPointer garbage)
{
     XtPopdown (SA_Shell);
     if (SelektKontext == baueVerbindung)
	  Aktion_baueVerbindung ();
     else if (SelektKontext == anlegeKraft)
	  Aktion_gerichteteKraft ();
     else if (SelektKontext == loescheVerbindung)
	  Aktion_loescheVerbindung ();
     else if (SelektKontext == aenderVerbindung)
	  Aktion_aenderVerbindungInit ();
}


/*******************************************************************************
 *  void selektiereAuswahlAbort (Widget w, XtPointer muell, XtPointer garbage)
 *
 *  Beschreibung:
 *  -------------
 *
 ********************************************************************************/

void selektiereAuswahlAbort (Widget w, XtPointer muell, XtPointer garbage)
{
     XtPopdown (SA_Shell);
     if ((SelektKontext == Selektion) ||  (SelektKontext == baueVerbindung) ||
	 (SelektKontext == anlegeKraft))
     {
	  SelektAllButtons (TRUE);
	  if (SelektKontext == baueVerbindung) {
	       free (selektierteVerbindung);
	       selektierteVerbindung = NULL;
	  }
	  if (selektiertesObjekt != NULL) {
	       HighLight (selektiertesObjekt);
	       DObjektEinfuegen ();
	  }
     }
     else
	  UnHighLightVerb (selektierteVerbindung);
     SelektKontext = Selektion;
}


/*******************************************************************************
 *  void installSelektAuswahl (void)
 *
 *  Beschreibung:
 *  -------------
 *  Bereitstellung eines 'Dialoges' zur Auswahl eines Objektes.
 ********************************************************************************/

void installSelektAuswahl (void)
{
   Widget SA_box, SA_Abort, SA_panedBox;

   SA_Shell = XtVaCreatePopupShell ("Select ...", topLevelShellWidgetClass, topLevel, NULL);
   SA_panedBox = XtVaCreateManagedWidget ("SA_panedBox", panedWidgetClass, SA_Shell, NULL);
   SA_label = XtVaCreateManagedWidget ("SA_box", labelWidgetClass, SA_panedBox, NULL);
   SA_box = XtVaCreateManagedWidget ("SA_box", formWidgetClass, SA_panedBox, NULL);
   SA_Next = XtVaCreateManagedWidget ("SA_Next", commandWidgetClass, SA_box, NULL);
   SA_Apply = XtVaCreateManagedWidget ("SA_Apply", commandWidgetClass, SA_box, NULL);
   SA_Abort = XtVaCreateManagedWidget ("SA_Abort", commandWidgetClass, SA_box, NULL);

   XtAddCallback (SA_Next, XtNcallback, selektiereAuswahlNext, NULL);
   XtAddCallback (SA_Apply, XtNcallback, selektiereAuswahlApply, NULL);
   XtAddCallback (SA_Abort, XtNcallback, selektiereAuswahlAbort, NULL);
}


/*******************************************************************************
 *  void DaempferVerbApply (Widget w, XtPointer clientData, XtPointer garbage)
 *
 *  Beschreibung:
 *  -------------
 *
 ********************************************************************************/

void DaempferVerbApply (Widget w, XtPointer clientData, XtPointer garbage)
{
     char *Daempfung = malloc (20*sizeof(char));
     
     XtPopdown (VA_DialogDaempfer);
     Daempfung = XawDialogGetValueString (VA_InteraktDaempfer);
     selektierteVerbindung->VerParameter.Daempfer.Daempfungskonstante =  (TReal) atof (Daempfung);
     SelektKontext = baueVerbindung;
     Aktion_baueVerbindung ();
     SelektAllButtons (FALSE);
     free (Daempfung);
}


void DaempferVerbAbort (Widget w, XtPointer clientData, XtPointer garbage)
{
     XtPopdown (VA_DialogDaempfer);
     free (selektierteVerbindung);
}


/*******************************************************************************
 *  void FederVerbApply (Widget w, XtPointer clientData, XtPointer garbage)
 *
 *  Beschreibung:
 *  -------------
 *
 ********************************************************************************/

void FederVerbApply (Widget w, XtPointer clientData, XtPointer garbage)
{
     char *FederParam = malloc (20*sizeof (char));
     
     XtPopdown (VA_ShellFeder);
     XtVaGetValues (VA_RuheFeder, XtNstring, &FederParam, NULL);
     selektierteVerbindung->VerParameter.Feder.Ruhelaenge =  (TReal) atof (FederParam);
     XtVaGetValues (VA_KonstFeder, XtNstring, &FederParam, NULL);
     selektierteVerbindung->VerParameter.Feder.Federkonstante =  (TReal) atof (FederParam);
     SelektKontext = baueVerbindung;
     SelektAllButtons (FALSE);
     
     Aktion_baueVerbindung ();
}


void FederVerbAbort (Widget w, XtPointer clientData, XtPointer garbage)
{
     XtPopdown (VA_ShellFeder);
     free (selektierteVerbindung);
}


void VerbLoeschen (Widget w, XtPointer muell, XtPointer garbage)
{
   SelektKontext = loescheVerbindung;
   selektiereAuswahlInit (w, NULL, NULL);
}


void VerbAendern (Widget w, XtPointer muell, XtPointer garbage)
{
   SelektKontext = aenderVerbindung;
   selektiereAuswahlInit (w, NULL, NULL);
}


/*******************************************************************************
 *  void VerbInsertion (Widget w, XtPointer VerbArt, XtPointer garbage)
 *
 *  Beschreibung:
 *  -------------
 *  Eine Verbindung soll eingef"ugt werden. Dazu wird zun"achst Speicher bereit-
 *  gestellt. Danach werden einige Werte initialisiert. Entsprechend der Ver-
 *  bindungsart werden die notwendigen Routinen zu deren Eingabe aufgerufen.
 ********************************************************************************/

void VerbInsertion (Widget w, XtPointer VerbArt, XtPointer garbage)
{
   selektierteVerbindung =  (TVerbindung *) malloc (sizeof (TVerbindung));
   SpeicherFrei (selektierteVerbindung)
   selektierteVerbindung->Art =  (TVerbindungsart) VerbArt;
   selektierteVerbindung->Koerper1 = NULL;
   selektierteVerbindung->Koerper2 = NULL;
   selektierteVerbindung->Naechste = NULL;
   selektierteVerbindung->AStatus = 0;
   switch ( (TVerbindungsart) VerbArt)
   {
      case DAEMPFER: XtPopup (VA_DialogDaempfer, XtGrabNone);
                     break;
      case FEDER: XtPopup (VA_ShellFeder, XtGrabNone);
                  break;
      case GELENK: SelektKontext = baueVerbindung;
                   SelektAllButtons (FALSE);
                   Aktion_baueVerbindung ();
                   break;
      case STANGE: SelektKontext = baueVerbindung;
                   SelektAllButtons (FALSE);
                   Aktion_baueVerbindung ();
                   break;
   }
}


/*******************************************************************************
 *  void installVerbindungAufbau (void)
 *
 *  Beschreibung:
 *  -------------
 *  Erzeugung aller zur Eingabe von Verbindungsparametern notwendige Widgets.
 ********************************************************************************/

void installVerbindungAufbau (void)
{
   Widget VA_boxFeder, VA_ApplyFeder, VA_AbortFeder, VA_RuheFederTxt,
          VA_KonstFederTxt;

   /****************************************************************************
    * Es wird eine Interaktionsshell fuer die Eingabe aller notwendigen Feder-
    * eigenschaften bereitgestellt.
    ****************************************************************************/
   VA_ShellFeder = XtVaCreatePopupShell ("Spring parameter", topLevelShellWidgetClass, topLevel, NULL);
   VA_boxFeder = XtVaCreateManagedWidget ("VA_boxFeder", formWidgetClass, VA_ShellFeder, NULL);
   VA_RuheFederTxt = XtVaCreateManagedWidget ("VA_RuheFederTxt", labelWidgetClass, VA_boxFeder, NULL);
   VA_RuheFeder = XtVaCreateManagedWidget ("VA_RuheFeder", asciiTextWidgetClass, VA_boxFeder, NULL);
   VA_KonstFederTxt = XtVaCreateManagedWidget ("VA_KonstFederTxt", labelWidgetClass, VA_boxFeder, NULL);
   VA_KonstFeder = XtVaCreateManagedWidget ("VA_KonstFeder", asciiTextWidgetClass, VA_boxFeder, NULL);
   VA_ApplyFeder = XtVaCreateManagedWidget ("VA_ApplyFeder", commandWidgetClass, VA_boxFeder, NULL);
   VA_AbortFeder = XtVaCreateManagedWidget ("VA_AbortFeder", commandWidgetClass, VA_boxFeder, NULL);
   XtAddCallback (VA_ApplyFeder, XtNcallback, FederVerbApply, NULL);
   XtAddCallback (VA_AbortFeder, XtNcallback, FederVerbAbort, NULL);

   /****************************************************************************
    * Es wird ein Dialog zur Erfragung der Daempfungskonstante bereitgestellt
    ****************************************************************************/
   VA_DialogDaempfer = XtVaCreatePopupShell ("Attenuation parameters", topLevelShellWidgetClass, topLevel, NULL);
   VA_InteraktDaempfer = XtVaCreateManagedWidget ("VA_InteraktDaempfer", dialogWidgetClass, VA_DialogDaempfer, NULL);
   XawDialogAddButton (VA_InteraktDaempfer, "VA_ApplyDaempfer", DaempferVerbApply, NULL);
   XawDialogAddButton (VA_InteraktDaempfer, "VA_AbortDaempfer", DaempferVerbAbort, NULL);
}


void VerbindungInc (Widget w, XtPointer Richtung, XtPointer garbage)
{
   TReal SchrittX, SchrittY, SchrittZ;
   TMatrix Matrix;

   switch (selektiertesObjekt->Art)
   {
      case QUADER: SchrittX = selektiertesObjekt->Form.Quader.KantenLaenge[0]/20.0;
                   SchrittY = selektiertesObjekt->Form.Quader.KantenLaenge[1]/20.0;
                   SchrittZ = selektiertesObjekt->Form.Quader.KantenLaenge[2]/20.0;
                   break;
      case ZYLINDER: SchrittX = selektiertesObjekt->Form.Zylinder.Radius/10.0;
                     SchrittZ = selektiertesObjekt->Form.Zylinder.Hoehe/20.0;
                     SchrittY = SchrittX;
                     break;
      case KUGEL: SchrittX = selektiertesObjekt->Form.Kugel.Radius/10.0;
                  SchrittY = SchrittX;
                  SchrittZ = SchrittX;
                  break;
      case EBENE: SchrittX = 0.5;
                  SchrittY = SchrittX;
                  SchrittZ = SchrittX;
                  break;
      default: SchrittX = 0.01;
               SchrittY = SchrittX;
               SchrittZ = SchrittX;
               break;
   }

   switch ( (TRichtung) Richtung)
   {
      case XRich: if (selektierteVerbindung->Koerper2 == NULL)
                     selektierteVerbindung->VPunkt1[0] += SchrittX;
                  else
                     selektierteVerbindung->VPunkt2[0] += SchrittX;
                  break;
      case YRich: if (selektierteVerbindung->Koerper2 == NULL)
                     selektierteVerbindung->VPunkt1[1] += SchrittY;
                  else
                     selektierteVerbindung->VPunkt2[1] += SchrittY;
                  break;
      case ZRich: if (selektierteVerbindung->Koerper2 == NULL)
                     selektierteVerbindung->VPunkt1[2] -= SchrittZ;
                  else
                     selektierteVerbindung->VPunkt2[2] -= SchrittZ;
                  break;
   }
   if (selektierteVerbindung->Koerper2 == NULL)
   {
      RotMatrix (Matrix, selektierteVerbindung->Koerper1->q);
      MV_MUL2 (markPosition->Position, Matrix, selektierteVerbindung->VPunkt1);
   }
   else
   {
      RotMatrix (Matrix, selektierteVerbindung->Koerper2->q);
      MV_MUL2 (markPosition->Position, Matrix, selektierteVerbindung->VPunkt2);
   }
   markPosition->Position[0] += selektiertesObjekt->Position[0];
   markPosition->Position[1] += selektiertesObjekt->Position[1];
   markPosition->Position[2] += selektiertesObjekt->Position[2];
   AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
                       EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
                       DZoomFaktor, &aktuelleWelt->Welt, 
		       KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
}


void VerbindungDec (Widget w, XtPointer Richtung, XtPointer garbage)
{
   TReal SchrittX, SchrittY, SchrittZ;
   TMatrix Matrix;

   switch (selektiertesObjekt->Art)
   {
      case QUADER: SchrittX = selektiertesObjekt->Form.Quader.KantenLaenge[0]/20.0;
                   SchrittY = selektiertesObjekt->Form.Quader.KantenLaenge[1]/20.0;
                   SchrittZ = selektiertesObjekt->Form.Quader.KantenLaenge[2]/20.0;
                   break;
      case ZYLINDER: SchrittX = selektiertesObjekt->Form.Zylinder.Radius/10.0;
                     SchrittZ = selektiertesObjekt->Form.Zylinder.Hoehe/20.0;
                     SchrittY = SchrittX;
                     break;
      case KUGEL: SchrittX = selektiertesObjekt->Form.Kugel.Radius/10.0;
                  SchrittY = SchrittX;
                  SchrittZ = SchrittX;
                  break;
      case EBENE: SchrittX = 0.5;
                  SchrittY = SchrittX;
                  SchrittZ = SchrittX;
                  break;
      default: SchrittX = 0.01;
               SchrittY = SchrittX;
               SchrittZ = SchrittX;
               break;
   }

   switch ( (TRichtung) Richtung)
   {
      case XRich: if (selektierteVerbindung->Koerper2 == NULL)
                     selektierteVerbindung->VPunkt1[0] -= SchrittX;
                  else
                     selektierteVerbindung->VPunkt2[0] -= SchrittX;
                  break;
      case YRich: if (selektierteVerbindung->Koerper2 == NULL)
                     selektierteVerbindung->VPunkt1[1] -= SchrittY;
                  else
                     selektierteVerbindung->VPunkt2[1] -= SchrittY;
                  break;
      case ZRich: if (selektierteVerbindung->Koerper2 == NULL)
                     selektierteVerbindung->VPunkt1[2] += SchrittZ;
                  else
                     selektierteVerbindung->VPunkt2[2] += SchrittZ;
                  break;
   }
   if (selektierteVerbindung->Koerper2 == NULL)
   {
      RotMatrix (Matrix, selektierteVerbindung->Koerper1->q);
      MV_MUL2 (markPosition->Position, Matrix, selektierteVerbindung->VPunkt1);
   }
   else
   {
      RotMatrix (Matrix, selektierteVerbindung->Koerper2->q);
      MV_MUL2 (markPosition->Position, Matrix, selektierteVerbindung->VPunkt2);
   }
   markPosition->Position[0] += selektiertesObjekt->Position[0];
   markPosition->Position[1] += selektiertesObjekt->Position[1];
   markPosition->Position[2] += selektiertesObjekt->Position[2];
   AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
                       EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
                       DZoomFaktor, &aktuelleWelt->Welt, 
		       KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
}


/*******************************************************************************
 *  
 *
 *  Beschreibung:
 *  -------------
 *  
 ********************************************************************************/

void VerbindungApply (Widget w, XtPointer Richtung, XtPointer garbage)
{
   TMatrix Matrix;
   TVektor V1, V2;

   XtPopdown (VP_Shell);
   aktuelleWelt->Welt.Koerper = markPosition->Naechster;
   markPosition->Naechster = NULL;

   if (selektierteVerbindung->Koerper2 == NULL)
      selektiereAuswahlInit (SA_Shell, NULL, NULL);
   else
   {
      if (selektierteVerbindung->Art == STANGE)
      {
	 RotMatrix (Matrix, selektierteVerbindung->Koerper1->q);
	 MV_MUL2 (V1, Matrix, selektierteVerbindung->VPunkt1);
	 V1[0] += selektierteVerbindung->Koerper1->Position[0];
	 V1[1] += selektierteVerbindung->Koerper1->Position[1];
	 V1[2] += selektierteVerbindung->Koerper1->Position[2];
	 RotMatrix (Matrix, selektierteVerbindung->Koerper2->q);
	 MV_MUL2 (V2, Matrix, selektierteVerbindung->VPunkt2);
	 V2[0] += selektierteVerbindung->Koerper2->Position[0];
	 V2[1] += selektierteVerbindung->Koerper2->Position[1];
	 V2[2] += selektierteVerbindung->Koerper2->Position[2];
	 selektierteVerbindung->VerParameter.Stange.Stangenlaenge =
	    sqrt (QUADRAT (V1[0]-V2[0])+QUADRAT (V1[1]-V2[1])+QUADRAT (V1[2]-V2[2]));
      }
      AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
                          EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
                          DZoomFaktor, &aktuelleWelt->Welt,
                          KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
      selektierteVerbindung = NULL;
      SelektAllButtons (TRUE); 
      SelektKontext = Selektion;
   }
}


/*******************************************************************************
 *  void VerbindungsPositionInit (void)
 *
 *  Beschreibung:
 *  -------------
 *  Erzeugen aller Widgets die zur Eingabe eines Angriffspunktes f"ur eine Ver-
 *  bindung notwendig sind, sowie aller Abh"angigkeiten.
 ********************************************************************************/

void installVerbindungsPosition (void)
{
   Widget VP_box, VP_movXP, VP_movXM, VP_movYP, VP_movYM, VP_movZP, VP_movZM,
          VP_Apply, VP_paned, VP_label;

   VP_Shell = XtVaCreatePopupShell ("What to do now?", topLevelShellWidgetClass, topLevel, NULL);
   VP_paned = XtVaCreateManagedWidget ("VP_paned", panedWidgetClass, VP_Shell, NULL);
   VP_label = XtVaCreateManagedWidget ("VP_label", labelWidgetClass,  VP_paned, NULL);
   VP_box   = XtVaCreateManagedWidget ("VP_box", formWidgetClass, VP_paned, NULL);
   VP_movXP = XtVaCreateManagedWidget ("VP_movXP", repeaterWidgetClass, VP_box, XtNbitmap, BMovXP, NULL);
   VP_movXM = XtVaCreateManagedWidget ("VP_movXM", repeaterWidgetClass, VP_box, XtNbitmap, BMovXM, NULL);
   VP_movYP = XtVaCreateManagedWidget ("VP_movYP", repeaterWidgetClass, VP_box, XtNbitmap, BMovYP, NULL);
   VP_movYM = XtVaCreateManagedWidget ("VP_movYM", repeaterWidgetClass, VP_box, XtNbitmap, BMovYM, NULL);
   VP_movZP = XtVaCreateManagedWidget ("VP_movZP", repeaterWidgetClass, VP_box, XtNbitmap, BMovZP, NULL);
   VP_movZM = XtVaCreateManagedWidget ("VP_movZM", repeaterWidgetClass, VP_box, XtNbitmap, BMovZM, NULL);
   VP_Apply = XtVaCreateManagedWidget ("VP_Apply", commandWidgetClass,  VP_box, NULL);
   XtAddCallback (VP_movXP, XtNcallback, VerbindungInc,  (XtPointer) XRich);
   XtAddCallback (VP_movYP, XtNcallback, VerbindungInc,  (XtPointer) YRich);
   XtAddCallback (VP_movZP, XtNcallback, VerbindungInc,  (XtPointer) ZRich);
   XtAddCallback (VP_movXM, XtNcallback, VerbindungDec,  (XtPointer) XRich);
   XtAddCallback (VP_movYM, XtNcallback, VerbindungDec,  (XtPointer) YRich);
   XtAddCallback (VP_movZM, XtNcallback, VerbindungDec,  (XtPointer) ZRich);
   XtAddCallback (VP_Apply, XtNcallback, VerbindungApply, NULL);
   markPosition =  (TKoerper *) malloc (sizeof (TKoerper));
   markPosition->Art = NAGEL;
   markPosition->R = 0;
   markPosition->G = 0;
   markPosition->B = 0;
   markPosition->AStatus = 0;
   markPosition->Kraefte = NULL;
}


/*******************************************************************************
 *  
 *
 *  Beschreibung:
 *  -------------
 *  
 ********************************************************************************/

void aendereVerbindungApply (Widget w, XtPointer muell, XtPointer garbage)
{
     char *trans = malloc (20*sizeof (char));
     TMatrix Matrix;
     TVektor V1, V2;


     XtVaGetValues (AV_K1X, XtNstring, &trans, NULL);
     selektierteVerbindung->VPunkt1[0] =  (TReal) atof (trans);
     XtVaGetValues (AV_K1Y, XtNstring, &trans, NULL);
     selektierteVerbindung->VPunkt1[1] =  (TReal) atof (trans);
     XtVaGetValues (AV_K1Z, XtNstring, &trans, NULL);
     selektierteVerbindung->VPunkt1[2] =  (TReal) atof (trans);
     XtVaGetValues (AV_K2X, XtNstring, &trans, NULL);
     selektierteVerbindung->VPunkt2[0] =  (TReal) atof (trans);
     XtVaGetValues (AV_K2Y, XtNstring, &trans, NULL);
     selektierteVerbindung->VPunkt2[1] =  (TReal) atof (trans);
     XtVaGetValues (AV_K2Z, XtNstring, &trans, NULL);
     selektierteVerbindung->VPunkt2[2] =  (TReal) atof (trans);
     switch (selektierteVerbindung->Art)
     {
       case FEDER: 
	  XtVaGetValues (AV_Param1, XtNstring, &trans, NULL);
	  selektierteVerbindung->VerParameter.Feder.Ruhelaenge = (TReal) atof (trans);
	  XtVaGetValues (AV_Param2, XtNstring, &trans, NULL);
	  selektierteVerbindung->VerParameter.Feder.Federkonstante = (TReal) atof (trans);
	  break;
       case DAEMPFER: 
	  XtVaGetValues (AV_Param1, XtNstring, &trans, NULL);
	  selektierteVerbindung->VerParameter.Daempfer.Daempfungskonstante = (TReal) atof (trans);
	  break;
       case STANGE: 
	  RotMatrix (Matrix, selektierteVerbindung->Koerper1->q);
	  MV_MUL2 (V1, Matrix, selektierteVerbindung->VPunkt1);
	  V1[0] += selektierteVerbindung->Koerper1->Position[0];
	  V1[1] += selektierteVerbindung->Koerper1->Position[1];
	  V1[2] += selektierteVerbindung->Koerper1->Position[2];
	  RotMatrix (Matrix, selektierteVerbindung->Koerper2->q);
	  MV_MUL2 (V2, Matrix, selektierteVerbindung->VPunkt2);
	  V2[0] += selektierteVerbindung->Koerper2->Position[0];
	  V2[1] += selektierteVerbindung->Koerper2->Position[1];
	  V2[2] += selektierteVerbindung->Koerper2->Position[2];
	  selektierteVerbindung->VerParameter.Stange.Stangenlaenge =
	       sqrt (QUADRAT (V1[0]-V2[0])+QUADRAT (V1[1]-V2[1])+QUADRAT (V1[2]-V2[2]));
	  RotMatrix (Matrix, selektierteVerbindung->Koerper1->q);
	  MV_MUL2 (V1, Matrix, selektierteVerbindung->VPunkt1);
	  V1[0] += selektierteVerbindung->Koerper1->Position[0];
	  V1[1] += selektierteVerbindung->Koerper1->Position[1];
	  V1[2] += selektierteVerbindung->Koerper1->Position[2];
	  RotMatrix (Matrix, selektierteVerbindung->Koerper2->q);
	  MV_MUL2 (V2, Matrix, selektierteVerbindung->VPunkt2);
	  V2[0] += selektierteVerbindung->Koerper2->Position[0];
	  V2[1] += selektierteVerbindung->Koerper2->Position[1];
	  V2[2] += selektierteVerbindung->Koerper2->Position[2];
	  selektierteVerbindung->VerParameter.Stange.Stangenlaenge =
	       sqrt (QUADRAT (V1[0]-V2[0])+QUADRAT (V1[1]-V2[1])+QUADRAT (V1[2]-V2[2]));
       default: break;
     }
     
     XtPopdown (AV_Shell);
     UnHighLightVerb (selektierteVerbindung);
     selektierteVerbindung = NULL;
     AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
			 EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
			 DZoomFaktor, &aktuelleWelt->Welt,
			 KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
}


/*******************************************************************************
 *  
 *
 *  Beschreibung:
 *  -------------
 *  
 ********************************************************************************/

void aendereVerbindungAbort (Widget w, XtPointer muell, XtPointer garbage)
{
     XtPopdown (AV_Shell);
     UnHighLightVerb (selektierteVerbindung);
     selektierteVerbindung = NULL;
}


/*******************************************************************************
 *  
 *
 *  Beschreibung:
 *  -------------
 *  
 ********************************************************************************/

void installAendereVerbindung (void)
{
   Widget AV_panedBox, AV_box;

   AV_Shell = XtVaCreatePopupShell ("Change something ... :-)", topLevelShellWidgetClass,
				   topLevel, NULL);
   AV_panedBox = XtVaCreateManagedWidget ("AV_panedBox", panedWidgetClass, AV_Shell, NULL);
   AV_VerbInfo = XtVaCreateManagedWidget ("AV_VerbInfo", labelWidgetClass, AV_panedBox, NULL);
   AV_box = XtVaCreateManagedWidget ("AV_box", formWidgetClass, AV_panedBox, NULL);
   AV_K1X = XtVaCreateManagedWidget ("AV_K1X", asciiTextWidgetClass, AV_box, NULL);
   AV_K1Y = XtVaCreateManagedWidget ("AV_K1Y", asciiTextWidgetClass, AV_box, NULL);
   AV_K1Z = XtVaCreateManagedWidget ("AV_K1Z", asciiTextWidgetClass, AV_box, NULL);
   AV_K2X = XtVaCreateManagedWidget ("AV_K2X", asciiTextWidgetClass, AV_box, NULL);
   AV_K2Y = XtVaCreateManagedWidget ("AV_K2Y", asciiTextWidgetClass, AV_box, NULL);
   AV_K2Z = XtVaCreateManagedWidget ("AV_K2Z", asciiTextWidgetClass, AV_box, NULL);
   AV_Param1Txt = XtVaCreateManagedWidget ("AV_Param1Txt", labelWidgetClass, AV_box, NULL);
   AV_Param1 = XtVaCreateManagedWidget ("AV_Param1", asciiTextWidgetClass, AV_box, NULL);
   AV_Param2Txt = XtVaCreateManagedWidget ("AV_Param2Txt", labelWidgetClass, AV_box, NULL);
   AV_Param2 = XtVaCreateManagedWidget ("AV_Param2", asciiTextWidgetClass, AV_box, NULL);
   AV_Apply = XtVaCreateManagedWidget ("AV_Apply", commandWidgetClass, AV_box, NULL);
   AV_Abort = XtVaCreateManagedWidget ("AV_Abort", commandWidgetClass, AV_box, NULL);
   XtAddCallback (AV_Apply, XtNcallback, aendereVerbindungApply, NULL);
   XtAddCallback (AV_Abort, XtNcallback, aendereVerbindungAbort, NULL);
}


void bindeKameraAnKoerper (Widget w, XtPointer muell, XtPointer garbage)
{
   AnimKamera.MountObj = selektiertesObjekt;
   AnimKamera.MountObjId = selektiertesObjekt->KoerperId;
   AnimKamera.Richtung[0] = 1.0;
   AnimKamera.Richtung[1] = 0.0;
   AnimKamera.Richtung[2] = 0.0;
   AnimKamera.Richtung[3] = 0.0;
   AnimKamera.Offset[0] = 0.0;
   AnimKamera.Offset[1] = 0.0;
   AnimKamera.Offset[2] = 0.0;
}


void KraefteLoeschen (Widget w, XtPointer muell, XtPointer garbage)
{
     TKraft *help;
   
     help = selektiertesObjekt->Kraefte;
     while (help != NULL)
     {
	  selektiertesObjekt->Kraefte = help->Naechste;
	  free (help);
	  help = selektiertesObjekt->Kraefte;
     }
     AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
			 EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
			 DZoomFaktor, &aktuelleWelt->Welt,
			 KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
}


void copySelectedObject (Widget w, XtPointer clientData, XtPointer callData)
{
     TKoerper *newObject, *headOfGroup;

     if (selektiertesObjekt->Art == ZUSGESOBJ) 
     {
	  headOfGroup = KoerperAllozieren ();
	  SpeicherFrei (headOfGroup);
	  KoerperKopieren (headOfGroup, selektiertesObjekt, headOfGroup);
	  KopiereKoerper (&headOfGroup->Form.ZusGesObj.KoerperListe, 
			  selektiertesObjekt->Form.ZusGesObj.KoerperListe, 
			  headOfGroup);
	  newObject = headOfGroup;
     } 
     else
     {
	  newObject = KoerperAllozieren ();
	  SpeicherFrei (newObject);
	  KoerperKopieren (newObject, selektiertesObjekt, selektiertesObjekt);
     }
     KoerperId ++;
     newObject->KoerperId = KoerperId;
     newObject->Kraefte = NULL; /* We just copied a pointer of forces, not the forces themselfs */
     KoeIniMech (newObject, aktuelleWelt->Welt.MaterialDaten);
     newObject->Naechster = aktuelleWelt->Welt.Koerper;
     aktuelleWelt->Welt.Koerper = newObject;
     UnHighLight (selektiertesObjekt);
     HighLight (newObject);
     selektiertesObjekt = newObject;
     *selektObjOLD = *selektiertesObjekt;
     DObjektEinfuegen ();
}


void selectNextGroup (Widget w, XtPointer garbage, XtPointer garbageToo)
{
     TKoerper *nextGroup;
     
     nextGroup = selektiertesObjekt->Naechster;
     if (nextGroup == NULL)
	  nextGroup = aktuelleWelt->Welt.Koerper;
     while (nextGroup->Art != ZUSGESOBJ && nextGroup != selektiertesObjekt)
	  if (nextGroup->Naechster != NULL)
	       nextGroup = nextGroup->Naechster;
	  else nextGroup = aktuelleWelt->Welt.Koerper;
     UnHighLight (selektiertesObjekt);
     selektiertesObjekt = nextGroup;
     HighLight (selektiertesObjekt);
     DObjektEinfuegen ();
}
