/********************************************************************************
 *  Projektname:        AERO
 *  Filename:           Welt.h
 *  Filetyp:            Header
 ********************************************************************************
 *  Modulname:          Welt.h
 *  Version:            1.0
 *  letzte Aenderung:   15.12.92
 *  Autor:              Andreas 
 *  Status:             
 *                                                                              
 *  imp. Bezeichner:
 * 
 *  exp. Bezeichner:
 *                                                                      
 *  Beschreibung:
 *  -------------
 *  
 *  Versionsgeschichte:
 *  -------------------
 *   15.12.92: Erweiterung der Struktur TWelt um 'FrameCounter'.
 *   13.01.93: Erweiterung der Struktur TWelt um Pointer 'thisSync' auf Struktur 
 *             TWelt. Die "Anderung wurde notwendig, da sonst das R"uckw"arts-
 *             laufen auf Sync-Punkten nicht funktioniert h"atte.
 *   19.01.93: Erweiterung der Struktur TWelt um ein Flag 'Szenenanfang'.
 *    7.11.94: Definition of min and max.
 *   20.02.95: Structure TModusAnimation has been expanded by the element 
 *             anim_SEQUENCE.
 ********************************************************************************/

#ifndef WELT_H
#define WELT_H
#include "folgeschrittberechnung.h"
#include <stdio.h>
#include <stdlib.h>
#include "Kamera.h"
#if 0   /* Not supported at version 1.5 or greater */
#define Drehregler
#endif
typedef struct TWelt {
           TZustand Welt;
           unsigned long FrameCounter;  /* 15.12.92 */
           struct TWelt *prevSync;
           struct TWelt *thisSync;      /* 13.01.93 */
           struct TWelt *nextSync;
	   TBoolean SzenenAnfang;       /* 19.01.93 */
        } TWelt;


typedef enum { 
           anim_PAUSE, 
           anim_PLAY,
	   anim_STEP,
	   anim_SEQUENCE,
	   anim_PLAYBACK
        } TModusAnimation;


typedef enum {
           SpeicherOK,
           SpeicherVoll
        } TSpeicher;


typedef struct TKoerperListe {
           TKoerper *Koerper;
           struct TKoerperListe *next;
        } TKoerperListe;


typedef enum {
           Selektion,
           baueVerbindung,
	   loescheVerbindung,
	   aenderVerbindung,
	   anlegeKraft/*,
           entferneKoerper, 
           veraenderKraft,
           entferneKraft */
        } TSelektKontext;   /* f"ur die Selektionsroutine, zur Bestimmung     */
                            /* welche Routine sie f"ur die Weiterverarbeitung */
                            /* des gew"ahlten Objektes aufrufen mu"s          */
                            
typedef enum {
           XRich,
           YRich,
           ZRich
        } TRichtung;

typedef enum {
           Rot,
           Gruen,
           Blau,
	   M_H,
	   M_S,
	   M_V
	} TFarbe;

typedef enum {
           schreibeAkt,
           leseAkt,
	   schreibeMat,
	   leseMat,
	   schreibeSeq,
	   leseSeq
        } TIORoutine;

#define SpeicherFrei(Pointer) if (Pointer == NULL){ fprintf(stderr, "No memory left, try later"); exit (-1); }

#ifndef min
#define min(x,y) (x)>(y)?(y):(x)
#endif
#ifndef max
#define max(x,y) (x)>(y)?(x):(y)
#endif
#define SliderSize 10.0/265.0

#endif
