/********************************************************************************
 *  Projektname		: AERO
 *  Filename		: bewegunggleichungen.c
 *  Filetyp		: C-Source
 ********************************************************************************
 *  Modulname		: bewegunggleichungen.o
 *  letzte Aenderung	: 22.03.93
 *  Autor		: Horst Stolz (HUS)
 *  Status:		: groesstenteils getestet
 *  
 *  Beschreibung:
 *  
 *  Noch zu machen:
 *
 *  Versionsgeschichte:
 *    21.01.93	Bewegunggleichunen von Folgeschrittberechnung abgekoppelt.
 *    22.01.93  Bewegungsgleichungen nur fuer FREIE Koerper berechnen
 *    22.01.93  Verbindung Daempfer eingebaut =>DaempferKraft()
 *    27.01.93  Erweiterung des Bewegungstyps um GEFUEHRT beruecksichtigt
 *    26.02.93  zur konstanten Gravitation wird noch ein variabler Wert 
 *              addiert wenn Konfiguration.G_Zufall==TRUE.
 *    19.03.93  Luftwiderstand
 *    22.03.93  Gravitionslose Koerper beruecksichtigt
 *    02.04.93  Luftwiderstand von ZusGesObj unterstuetzt
 *    11.05.94  Compiler-Warnings ausgebaut
 *  
 ********************************************************************************/

#include "grundtypen.h"
#include "vektor.h"
#include "folgeschrittberechnung.h"
#include "kollision.h"
#include "bewegungsgleichungen.h"
#include "konfig.h"
#include "ausgabe.h"
#include "fehler.h"
#include "kollisionsbehandlung.h"

#include <stdlib.h>


#define RAND_MAX_HOPE 32767


int bg_debug_level = 0;


/* Absoluter Anteil zwischen dem sich ein Zufaelliger Gravitationswert bewegt!
 * Also: |Zufaellige Gravitation| <= ZufGravFaktor
 */
TReal ZufGravFaktor;


/* MinDehnung = 0.00001; */
/* Schwellenwert unter dem eine Dehnung (einer Feder) 
 * nicht als Dehnung der Feder erkennbar ist [in m].
 */  
                            


void KoerperRotMatrizen(TKoerper *k)
{
    TKoerper *ek;
    TVektor v;
    
    for (;k; k=k->Naechster) {
	RotMatrizen(k->RotTrans1, k->RotTrans, k->ty->q);

	/* bei einem Zusammengesetzen Koerper auch die Rotmatrizen und Positionen 
         * der eingebetteten Koerper berechen (zwecks Kollisionserkennung)
         */
	if (k->Art==ZUSGESOBJ)
	    for (ek=k->Form.ZusGesObj.KoerperListe; ek; ek=ek->Naechster) {

		MV_MUL2(v, k->RotTrans1, ek->Position_bzg_ZGO);
		V_ADD(ek->Position, k->ty->p, v);

		Q_MUL(ek->q, ek->q_bzg_ZGO, k->ty->q); 
		RotMatrizen(ek->RotTrans1, ek->RotTrans, ek->q);
	    }	
    }
}



void EingepraegteKraft(TKoerper *k, TVektor p, TVektor F)
/****************************************************************************
 * Eingepraegte Kraeft F die im koerperfestem Angriffspunkt p angreift
 * wird direkt zur "rechten" Seite des Impuls- und Drallsatzes des
 *  Koerpers k dazuaddiert.
 */
{
    TVektor M;		/* Moment */

    if (k->BewTyp & FREI) {
	V_INC(k->a, F);				/* Kraft in Impulssatz */

	/*MV_MUL2(kF, k->RotTrans, F);*/	/* Kraft in Koerperkoordinaten */
	V_MUL(M, p, F);	        		/* Moment = Abstand * Kraft */
	V_INC(k->u, M);                         /* In Drallsatz einbringen */
    }
}

static void FederKraft(TKoerper *k1, TVektor p1, TKoerper *k2, TVektor p2, TReal x0, TReal c)
/****************************************************************************
 * FederKraft in Bewegungsgleichungen einbringen (als eingepraegte Kraft)
 * Feder ist definiert durch die Federenden in Koerperkoordinaten, einer
 * Ruhelaenge x0, sowie der Federkonstanten c.
 */
{
    TVektor F;		/* Feder-Kraftvektor auf k1 */
    TReal f;		/* Absolut-Kraft auf k1 */
    TReal x;		/* Federlaenge */
    TVektor ap1, ap2;   /* Absolutkoordinaten der Federenden */
    

    FehlerOrt("FederKraft()");

    /*
     * Absolutkoordinaten der Federenden aus den Koerperkoordinaten sowie
     * den Koerperschwerpunkten berechnen.
     */
    MV_MUL2(ap1, k1->RotTrans1, p1);
    V_ADD(F, ap1, k1->ty->p);

    MV_MUL2(ap2, k2->RotTrans1, p2);
    V_DEC(F, ap2);
    V_DEC(F, k2->ty->p);

    x = V_BETRAG(F);			/* Laenge der Feder */
	
    /* Abstand x = 0   => Keine Kraftrichtung bestimmbar ?!!! 
     */
    if (fabs(x) < Konfiguration.F_MinDehnung) return;

    f = ((x0 - x) * c)/x;
    V_SKALAR(F, F, f);

    /* Federkraft F in in Impulssatz und Drallsatz der frei beweglichen Koerper
     * einbringen
     */

    EingepraegteKraft(k1, ap1, F);
    F[0] = - F[0];
    F[1] = - F[1];
    F[2] = - F[2];
    EingepraegteKraft(k2, ap2, F);
}


static void DaempferKraft(TKoerper *k1, TVektor p1, TKoerper *k2, TVektor p2, TReal d)
{
    TVektor F;		/* Feder-Kraftvektor auf k1 */
    TReal x;		/* */
    TVektor ap1, ap2;   /* Absolutkoordinaten der Daempferenden */
    TVektor v1, v2;	/* Abs.Geschwindigkeit an den Daempferenden */

    FehlerOrt("DaempferKraft()");

    /*
     * Absolutkoordinaten der Federenden aus den Koerperkoordinaten sowie
     * den Koerperschwerpunkten berechnen.
     */
    MV_MUL2(ap1, k1->RotTrans1, p1);
    V_ADD(F, ap1, k1->ty->p);

    MV_MUL2(ap2, k2->RotTrans1, p2);
    V_DEC(F, ap2);
    V_DEC(F, k2->ty->p);

    x = V_BETRAG(F);			/* Positionsunterschied der Daempferenden */
	
    /* Abstand x = 0   => Keine Kraftrichtung bestimmbar ?!!! 
     */
    if (fabs(x) < Konfiguration.F_MinDehnung) return;

    x = 1.0 / x;
    V_SKALAR(F, F, x);		/* Normalenvektor des Daempfers */
					/* = Kraftrichtung */
    V_MUL(v1, k1->ty->w, ap1);		/* Absolut-Geschwindigkeit am Daempfer */
    V_INC(v1, k1->ty->v);		/* Ende des Koerpers k1 */

    V_MUL(v2, k2->ty->w, ap2);		/* Absolut-Geschwindigkeit am Daempfer */
    V_INC(v2, k2->ty->v);		/* Ende des Koerpers k2 */

    V_DEC(v1, v2);
    x = -(V_PRODUKT(v1,F)) * d;	/* Daempferlaengenaenderung */

    V_SKALAR(F, F, x);

    /* Daempferkraft F in in Impulssatz und Drallsatz der frei beweglichen Koerper
     * einbringen
     */
    EingepraegteKraft(k1, ap1, F);
    F[0] = - F[0];
    F[1] = - F[1];
    F[2] = - F[2];
    EingepraegteKraft(k2, ap2, F);
}
	

void Luftwiderstandskraefte(TKoerper *k, TReal t)
{
    TKoerper *ek;
    TReal f;
    TVektor v, p, M;

    for (;k; k=k->Naechster) 
	if (k->BewTyp & FREI) {
	    switch(k->Art) {
		case KUGEL:    f = Konfiguration.L_Beiwert_Kugel; break;
		case QUADER:   f = Konfiguration.L_Beiwert_Quader; break;
		case ZYLINDER: f = Konfiguration.L_Beiwert_Zylinder; break;
		case ZUSGESOBJ:
		    for (ek = k->Form.ZusGesObj.KoerperListe; ek; ek=ek->Naechster) {
			switch(ek->Art) {
			case KUGEL:    f = Konfiguration.L_Beiwert_Kugel; break;
			case QUADER:   f = Konfiguration.L_Beiwert_Quader; break;
			case ZYLINDER: f = Konfiguration.L_Beiwert_Zylinder; break;
			default:       continue;
			}

			/* Position des eingebetteten Koerpers bzg. Koerperschw. */
			V_SUB(p, ek->ty->p, k->ty->p);

		        /* Geschw. des eingebetteten Koerpers */
			V_MUL(v, k->ty->w, p);
			V_INC(v, k->ty->v);     

			/* Widerstandskraft */
			f *= -V_BETRAG(v) * k->Angriffsflaeche;
			V_SKALAR(v, v, f);

			/* in Impuls- und Drallsatz einbringen */
			V_INC(k->a, v);
			V_MUL(M, p, v);
			V_INC(k->u, M);
		    }
		    continue;
		default: continue;
	    }
	    f *= V_BETRAG(k->ty->v) * k->Angriffsflaeche;
	    V_SUBSKAL(k->a, k->a, f, k->ty->v);
	}
}


void Bewegungsgleichungen(TZustand *z, TReal t)
/***************************************************************************
 * Aufstellen der Bewegungsgleichungen aller Koerper fuer die Integration.
 * Das waere der Impulssatz : m*a = F  (in Var. k->a)
 * Und Drallsatz            : Ju = M   (in Var. k->u)
 * Wobei als F nur eingepraegte Kraefte wie Gewichtskraft, Federkraft,...
 * zulaessig sind. 
 * Des weiteren werden noch die Gleichungen zur Hoch-Integration aufgestellt
 * (HUS: sollte noch umgebaut werden!!)
 */
{
    TKoerper *k;
    TVerbindung *v;
    TVektor tv0, tv1;  		/* Hilfsvariablen */
    TIVariablen *ty, *y;

    FehlerOrt("Bewegungsgleichungen() - RotMatrizen berechnen");

    /* neu Rotationsmatrizen aller Koerper berechnen
     */     

    KoerperRotMatrizen(z->Koerper);


    FehlerOrt("Bewegungsgleichungen() - Schwerkraft einbringen");
    
    /* Schwerkraft in Impulssatz und Drallsatz einbringen
     */
    if (z->GravitationAn) 
	for (k = z->Koerper; k; k = k->Naechster) {

	    /* Koerper bei denen Gravition nicht erlaubt ist wird keine
             * Gravitationskraft angerechnet
	     */
	    if ((k->BewTyp) & GRAV0) {
		V_SET(k->a, 0.0, 0.0, 0.0);   /* keine Gravitation */
	    }
	    else {
		
		/* Beschleunigung und Drehbeschleunigung muesse gesetzt werden,
		 * Um einen korrekten Zugriff (auch Schreibend aufgrund der
		 * Verbindungen) zu gewaehrleisten!
		 */
		/* Init - Impulssatz ma = F */
		V_SKALAR(k->a, z->GravitationsVektor, k->Masse);
		/* Zufallaellige variierung der Gravitation */
		if (Konfiguration.G_Zufall) {
		    
		    k->a[0] += (2.0*((TReal)(RAND_MAX_HOPE&rand()))/((TReal)RAND_MAX_HOPE) - 1.0)
		      *ZufGravFaktor * k->Masse;
		    k->a[1] += (2.0*((TReal)(RAND_MAX_HOPE&rand()))/((TReal)RAND_MAX_HOPE) - 1.0)
		      *ZufGravFaktor * k->Masse;
		    k->a[2] += (2.0*((TReal)(RAND_MAX_HOPE&(z->Seed = rand())))/
		                ((TReal)RAND_MAX_HOPE) - 1.0)* ZufGravFaktor * k->Masse;
		    
		} 
	    }
	    V_SET(k->u, 0.0, 0.0, 0.0);            /* Init - Drallsatz Ju = M */
	}
    else 
      for (k = z->Koerper; k; k = k->Naechster) {
	  V_SET(k->a, 0.0, 0.0, 0.0);		   /* keine Gravitation */
	  V_SET(k->u, 0.0, 0.0, 0.0);            /* Init - Drallsatz Ju = M */
      }


    FehlerOrt("Bewegungsgleichungen() - Eingepraegte Krafte einbringen");

    /* Luftwiderstandskraefte einbringen
     */
    if (Konfiguration.L_Luftwiderstand)
	Luftwiderstandskraefte(z->Koerper, t);    


    /*
     * eingepraegte Kraefte durch Verbindungen einbringen
     */


    KraefteEinbringen(z->Koerper, t);

    for (v = z->Verbindungen; v; v = v->Naechste) switch(v->Art) {
      case FEDER:
	FederKraft(v->Koerper1, v->VPunkt1, v->Koerper2, v->VPunkt2, 
                   v->VerParameter.Feder.Ruhelaenge,
		   v->VerParameter.Feder.Federkonstante);
	break;
      case DAEMPFER:
	DaempferKraft(v->Koerper1, v->VPunkt1, v->Koerper2, v->VPunkt2,
		      v->VerParameter.Daempfer.Daempfungskonstante);
	break;
      case GELENK:
	FederKraft(v->Koerper1, v->VPunkt1, v->Koerper2, v->VPunkt2, 
                   0.0, Konfiguration.C_Gelenk_c);
	DaempferKraft(v->Koerper1, v->VPunkt1, v->Koerper2, v->VPunkt2,
		      Konfiguration.C_Gelenk_d);
	break;
      case STANGE:
	FederKraft(v->Koerper1, v->VPunkt1, v->Koerper2, v->VPunkt2, 
                   v->VerParameter.Stange.Stangenlaenge,
		   Konfiguration.C_Stange_c);
	DaempferKraft(v->Koerper1, v->VPunkt1, v->Koerper2, v->VPunkt2,
		   Konfiguration.C_Stange_d);
	break;
      default:
	Fehler("unbekannte Verbindungsart");
	break;
    }    
    

    if (KTest(z, t, TRUE)) {
#ifndef NODEBUG
	if (bg_debug_level>=2)
		printf("Kollision zw Koerpern ->Ruecksetzen erforderlich\n");
#endif

	
/*
	KBehandlung(z, t);
	INeustartn(t, );
*/

    }
    
    FehlerOrt("Bewegungsgleichungen() - Aufzuintegrierende Vars setzen");
    

    for (k = z->Koerper; k; k = k->Naechster) {
	if (k->BewTyp & FREI) {

	ty = k->ty;
	y = k->y;
	
	if (k->Masse == 0.0) {
	    V_SET(k->a, 0.0, 0.0, 0.0);
	    V_SET(k->u, 0.0, 0.0, 0.0);
	} else {
	    k->a[0] /= k->Masse;          /* Beschleunigung */
	    k->a[1] /= k->Masse;
	    k->a[2] /= k->Masse;
/*
 * Traegheitstensor noch in raumfeste Koord. wandeln
 */
/* SO NICHT!?? */
            MV_MUL2(tv0, k->RotTrans, k->u);
            MV_MUL2(tv1, k->Traegheitstensor1, tv0);
            MV_MUL2(k->u, k->RotTrans1, tv1);
/* */
/*
            MV_MUL2(tv0, k->Traegheitstensor1, k->u); 
	    V_LET(k->u, tv0);
 */
           /* Drehbeschleunigung */ 
	}
	
	V_LET(y->v, k->a);            /* aufzuintegrierende Geschwindigkeit */
	V_LET(y->p, ty->v);           /* aufzuintegrierende Position */
	V_LET(y->w, k->u);            /* aufzuintegrierende Drehgeschwindigkeit */

        /* aufzuintegrierende Euler-Par */
/*
	y->q[0] = -0.5*((ty->w[0])*(ty->q[1])+(ty->w[1])*(ty->q[2])+(ty->w[2])*(ty->q[3]));
	y->q[1] = 0.5*((ty->w[0])*(ty->q[0])+(ty->w[2])*(ty->q[2])-(ty->w[1])*(ty->q[3]));
	y->q[2] = 0.5*((ty->w[1])*(ty->q[0])-(ty->w[2])*(ty->q[1])+(ty->w[0])*(ty->q[3]));
	y->q[3] = 0.5*((ty->w[2])*(ty->q[0])+(ty->w[1])*(ty->q[1])-(ty->w[0])*(ty->q[2]));
*/



	y->q[0] = 0.5*((ty->w[0])*(ty->q[1])+(ty->w[1])*(ty->q[2])+(ty->w[2])*(ty->q[3]));
	y->q[1] = -0.5*((ty->w[0])*(ty->q[0])+(ty->w[2])*(ty->q[2])-(ty->w[1])*(ty->q[3]));
	y->q[2] = -0.5*((ty->w[1])*(ty->q[0])-(ty->w[2])*(ty->q[1])+(ty->w[0])*(ty->q[3]));
	y->q[3] = -0.5*((ty->w[2])*(ty->q[0])+(ty->w[1])*(ty->q[1])-(ty->w[0])*(ty->q[2]));


	}
    }

#ifndef NODEBUG
    if (bg_debug_level>=3) {
    printf("End BewGl\n");
    for (k = z->Koerper; k; k = k->Naechster) {
	printf("Koerper %p\n", k);
	printf("k->BewTyp = %d\n", k->BewTyp);
	printvektor("k->a = ", k->a);
	printvektor("k->u = ", k->u);
	printvektor("k->y->p = ", k->y->p);
	printvektor("k->y->v = ", k->y->v);
	printvektor("k->y->w = ", k->y->w);
	printeulerpar("k->y->q = ", k->y->q);
	printvektor("k->ty->p = ", k->ty->p);
	printvektor("k->ty->v = ", k->ty->v);
	printvektor("k->ty->w = ", k->ty->w);
	printeulerpar("k->ty->q = ", k->ty->q);
    }
    }
#endif
}
