/********************************************************************************
 *  Projektname		: AERO
 *  Filename		: folgeschrittberechnung.c
 *  Filetyp		: C-Source
 ********************************************************************************
 *  Modulname		: folgeschrittberechnung.o
 *  Autor		: Horst Stolz (HUS)
 *  Status:		: schon ofters mal ausgefuehrt
 *  
 *  Beschreibung:
 *    waehrend der Folgeschrittberechnet werden die Koerper-Eintraege
 *    k->ty und k->y als Schreibende und Lesende Variablen fuer 
 *    Position & Geschw benutzt, alle darunterliegenden Proz. veraendern
 *    nur diese Variablen. Das Umkopieren in die oeffentlichen Variablen
 *    ->Position, ... geschieht in diesem Modul.
 *  
 *  Versionsgeschichte:
 *  -------------------
 *    10.01.93	Type TQuaternion eingebaut
 *    20.01.93  Anderung von IInit beruecksichtigt, UngeaendertFBB(..) eingebaut
 *    06.06.93  Fehler rausgemacht: ty der Teilkoerper in ZusGesObj setzten!
 *    11.05.94  Compiler Warnings entfernt
 *    18.05.94  ein paar Debug-Ausgaben ergaenzt
 *    24.05.94  Fehler in { } bei #ifndef NODEBUG behoben
 *    07.06.94  ((TIVariable *)y) umformuliert, da es Probleme mit HPs cc gab.
 *
 ********************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "grundtypen.h"
#include "vektor.h"
#include "folgeschrittberechnung.h"
#include "integration.h"
#include "bewegungsgleichungen.h"
#include "kollisionsbehandlung.h"
#include "fehler.h"
#include "ausgabe.h"



int fsb_debug_level = 0;




static TBoolean zustand_geaendert = TRUE;
static TBoolean integration_initialisiert = FALSE;


static TZustand *z;
static TReal letztes_t = -12345.0;

static TReal *yout;

void FBBRestart(TReal t)
{
    INeustart(t, yout);
}

void Funktionsauswertung(TReal *y_real, TReal *ytemp_real, TReal t)
/***************************************************************************
 * Bestimme den Systemzustand (Bewegungsgleichungen der freien Koerper)
 * zur Zeit t, mit den y-Werten ytemp (Pos, Geschw, Eulerpar, Drehgeschw)
 * und schreibe Erg. nach y
 */
{
    TKoerper *k;
    TIVariablen *y = (TIVariablen *)y_real;
    TIVariablen *ytemp = (TIVariablen *)ytemp_real;

    FehlerOrt("Funktionsauswertung()");
    
    yout = y_real;


    for (k = z->Koerper; k; k = k->Naechster) {
	if (k->BewTyp & FREI) {
	    k->y = y;		/* Schreib-Var. setzen */
	    k->ty = ytemp;		/* Lese-Var. setzen */
	    y++;
	    ytemp++;
	} else {
	    k->y = (TIVariablen *)&(k->Position);
	    k->ty = k->y;

	}

    }

    Bewegungsgleichungen(z, t);
}



void Interpolationsnachbearbeitung(TReal *ytemp_real, TReal t)
/***************************************************************************
 * Auswertungsfunktion die nach der Interpolation aufgerufen wird.
 * Nur lesender Zugriff!!!!!!!
 */
{
    TKoerper *k;
    TIVariablen *ytemp = (TIVariablen *)ytemp_real;


    FehlerOrt("Interpolationsnachbearbeitung()");
    
    for (k = z->Koerper; k; k = k->Naechster) {
	if (k->BewTyp & FREI) {
	    k->y = ytemp;		/* Schreib-Var. setzen */
	    k->ty = ytemp;		/* Lese-Var. setzen */
	    ytemp++;
	} else {
	    k->y = (TIVariablen *)&(k->Position);
	    k->ty = k->y;
	}

    }

    KoerperRotMatrizen(z->Koerper);
    KTest(z, t, FALSE);
}




void IntSchrittWiederholung(TReal t)
/***************************************************************************
 * Diese Funktion wird aufgerufen wenn die 
 * Genauigkeit nicht ausreicht und der Integrationsschritt 
 * nochmals gemacht werden muss.
 */
{
}



void IntSchrittVorbearbeitung(TReal t)
/***************************************************************************
 * Vorverarbeitung vor der Integration.
 * 
 * Bringt Quaternion-Betrag in Richtung 1.0
 */
{
    TReal qs;
    TKoerper *k;

    FehlerOrt("IntSchrittVorbearbeitung()");

    for (k = z->Koerper; k; k = k->Naechster) {
	if (k->BewTyp & FREI) {
	    
/* normierung des Quaternions auf 1, alte Version
 */
	    qs = sqrt(QUADRAT(k->ty->q[0])+QUADRAT(k->ty->q[1])
		      +QUADRAT(k->ty->q[2])+QUADRAT(k->ty->q[3]));
	    
	    k->ty->q[0] /= qs;
	    k->ty->q[1] /= qs;
	    k->ty->q[2] /= qs;
	    k->ty->q[3] /= qs;


	    /* q[0]^2 + q[1]^2 + q[2]^2 + q[3]^2 != 1
	     */
/* test
	    
	    
	    qs = (QUADRAT(k->ty->q[1])+QUADRAT(k->ty->q[2])+QUADRAT(k->ty->q[3]));
	    
	    if (qs > 1.0) {
		qs = sqrt(qs + QUADRAT(k->ty->q[0]));
		
		k->ty->q[0] /= qs;
		k->ty->q[1] /= qs;
		k->ty->q[2] /= qs;
		k->ty->q[3] /= qs;

	    }
	    else {
		qs = sqrt(1.0 - qs);
	
		if (k->ty->q[0] >=0.0)
		    k->ty->q[0] = qs;
		else
		    k->ty->q[0] = -qs;
	    }
*/
	}
    }
}



void IStart()
/***************************************************************************
 * Integrationsverfahren initialisieren,
 * fuer die Integration bestimmten werte aus der Zustands-Struktur in den
 * y-Start-Vektor der Integration kopieren.
 * Fuer die Integration sind die Position, Geschwindigkeit,
 * Drehgeschwindigkeit und Eulerparameter notwendig!
 * 
 */
{
    TKoerper *k, *ek;
    int nk = 0;
    TIVariablen *yy;

    FehlerOrt("IStart()");

    /* Koerperanzahl ermitteln.
     */
    for (k = z->Koerper; k; k=k->Naechster) {
      if (k->BewTyp & FREI) nk++;
    }

    /* Integration initialisieren
     */
    yy = (TIVariablen *)IInit((sizeof(struct TIVariablen ) / sizeof(TReal)) * nk,
			      Funktionsauswertung, Interpolationsnachbearbeitung,
			      IntSchrittVorbearbeitung, IntSchrittWiederholung);

    /* Werte aus der Zustands-Struktur in den y-Vektor des Integr-Verfahrens 
     * kopieren.
     */
    for (k = z->Koerper; k; k = k->Naechster) {
	if (k->BewTyp & FREI) {
	    k->ty = yy;
	    k->y = yy;
	    V_LET(yy->p, k->Position);
	    V_LET(yy->v, k->Geschwindigkeit);
	    V_LET(yy->w, k->Drehgeschwindigkeit);
	    yy->q[0]  = k->q[0];
	    yy->q[1]  = k->q[1];
	    yy->q[2]  = k->q[2];
	    yy->q[3]  = k->q[3];

	    yy++;
	}
	else {
	    k->ty = (struct TIVariablen *) &(k->Position);
	    k->y  = 0;  /* Nur Lesender Zugriff erlaubt! */ 
	}

	/* Die ty-Variable in den Teilkoerpern des ZusGesObj initialisieren! 
         */
	if (k->Art == ZUSGESOBJ)
	  for (ek=k->Form.ZusGesObj.KoerperListe; ek; ek=ek->Naechster) {
	      ek->ty = (struct TIVariablen *) &(ek->Position);
	      ek->y = 0;
	  }
    }
}


void IEnd()
/***************************************************************************
 * Kopiert das Integrationsergebnis in die Zustand-Struktur zurueck
 */
{
    TKoerper *k;
    TIVariablen *yy;

    FehlerOrt("IEnd()");

    yy = (TIVariablen *)IErg();

    for (k = z->Koerper; k; k = k->Naechster) {
	if (k->BewTyp & FREI) {
        V_LET(k->Position, yy->p);
        V_LET(k->Geschwindigkeit, yy->v);
        V_LET(k->Drehgeschwindigkeit, yy->w);
        k->q[0] = yy->q[0];
        k->q[1] = yy->q[1];
        k->q[2] = yy->q[2];
        k->q[3] = yy->q[3];
        V_LET(k->Beschleunigung, k->a);
        V_LET(k->Drehbeschleunigung, k->u);
	yy++;
	}
    }
}



void tyErg()
/***************************************************************************
 * Ergebnissvariable ty der Teilkoerper auf Ergebnisvektor der
 * Integration verteilen.
 */
{
    TKoerper *k;
    TIVariablen *yy;

    FehlerOrt("IEnd()");

    yy = (TIVariablen *)IErg();

    for (k = z->Koerper; k; k = k->Naechster) {
	if (k->BewTyp & FREI) {
	    k->ty = yy;
	    k->ty = yy;
	    yy++;
	}
    }
}



TBoolean FolgeBildBerechnung(TZustand *Z, TReal dt)
/***************************************************************************
 * Berechne den Zustand fuer z->Zeit + dt,
 * 
 */
{
    TReal t;
    TReal tend;


    FehlerOrt("FolgeBildBerechnung()");

#ifndef NODEBUG
    if (fsb_debug_level>=4)
      printzustand(z);

    if (fsb_debug_level>=1) {
	printf("FBB(z->Zeit=%f, dt=%f) 1-\n", Z->Zeit, dt);
    }
#endif

    if (dt <= 0.0) Fehler("Zeitschritt dt<=0 ?!!");


    z = Z;
    t = z->Zeit;
    tend = t + dt;

    /* Seed-Wert fuer Zufaellige Gravitation
     */
    srand(z->Seed);

    /* Wenn Zustand zum vorigen Aufruf nicht geaendert wurde dann
     * ist keine Initialisierung noetig.
     */
    if (zustand_geaendert) {
#ifndef NODEBUG
	if (fsb_debug_level>=1) {
	    printf("FBB() 1- Zustand geaendert, I-Neustart\n");
	}
#endif
	Kfreigeben();
	IConfig(ISCHRITT, Konfiguration.I_Schritt);
	IStart();
	integration_initialisiert = TRUE;
	if (z->GravitationAn) ZufGravFaktor = V_BETRAG(z->GravitationsVektor);
    }
    else {
	if (letztes_t != t) 
	  Fehler("Zustand geaendert!, da letzte-Endzeit != diese Startzeit");
    }
    

    if (Konfiguration.K_Kollisionserkennung) while (t<tend) {
	/* Berechnung mit Kollisionsbehandlung
	 * (Kollschrittweite beruecksichtigen!)
	 */
	
	/* Naechster Schritt innerhalb der KollSchrittweite */
	if ((fabs(t+Konfiguration.K_KollSchritt-tend) 
	    < Konfiguration.K_KollSchritt*0.01)
	    || (t+Konfiguration.K_KollSchritt >= tend)) {
	    INach(&t, tend);
	} else {
	    INach(&t, t+Konfiguration.K_KollSchritt);
	}

        /* Kollision freigeben wenn sie erst spater stattfindet!
         * (wegen Fehlersteuerung noetig)
         */
	if (KStattgefunden()) {
#ifndef NODEBUG
	    if (fsb_debug_level>=1) {
		printf("FBB() 1- t_kollisionsfreiZeit=%f\n", KfreieZeit());
	    }
#endif
	    if (t<KZeit()) {
#ifndef NODEBUG
		if (fsb_debug_level>=1) {
		    printf("FBB() 1- Kollisionsfreigabe da t=%f <= t_kol=%f\n",
			   t, KZeit());
	    	}
#endif
		Kfreigeben();		
	    }
	    else {
		
		tyErg();
		
#ifndef NODEBUG
		if (fsb_debug_level>=1) {
		    printf("FBB() 1- Kollision(t=%f) stattgefunden(schon bei t=%f)!\n",
			   t, KZeit());
		    printf("FBB() 1- Minimale Interpolationszeit %f\n", IMinInterpolZeit());
		}
#endif
		/* zum fruehesten Kollisionszeitpunkt zurueckkehren 
                 * und Nochmals Kollisionstest durchfuehren
		 */
		
		if (IMinInterpolZeit()<KZeit()) {
#ifndef NODEBUG
		    if (fsb_debug_level>=1) {
			printf("FBB() 1- Interpolation zur 1.Kol %f\n", KZeit());
		    }
#endif
		    Kfreigeben();
		    INach(&t, KZeit());
		    if (KStattgefunden()) KBehandlung(z, t);
		}
		else {
		    Kfreigeben();  /* Kein Rueckkehren moeglich */
		    KoerperRotMatrizen(z->Koerper);
		    KTest(z, t, FALSE);
		    if (KStattgefunden()) KBehandlung(z, t);
		}
	    }

#ifndef NODEBUG
	    if (fsb_debug_level>=1) {
		printf("FBB() 1- Ruecksetzen der Integration!\n");
	    }
#endif
	    IRuecksetzen(t, IErg());
	}
    }
    else {
	INach(&t, tend);      /* ohne Kollisionsbehandlung */
    }

    KoerperRotMatrizen(z->Koerper);

    
    IEnd();
    z->Zeit = t;

    zustand_geaendert = TRUE;

    letztes_t = t;

    return TRUE;
}



void InitFBB(TZustand *z)
/***************************************************************************
 * Initialisierung der FBB,
 */ 
{
    TKoerper *k;
/* zum DEBUGGEN
    extern int ke_debug_level;
    extern int kb_debug_level;
    extern int s_debug_level;
    extern int b_debug_level;
    extern int gl_debug_level;
    extern int i_debug_level;

    fsb_debug_level = 1;
    s_debug_level = 2;
    kb_debug_level = 1;
    ke_debug_level = 0;

    s_debug_level = 2;
    b_debug_level = 1;
    gl_debug_level = 3;

    i_debug_level = 1;  
*/
    


    FehlerOrt("InitFBB()");

    if (z) {
	if (z->MaterialDaten == NULL) Fehler("MaterialDaten Fehlen!");
	
	for (k=z->Koerper; k; k=k->Naechster)
	  KoeIniMech(k, z->MaterialDaten);
    }



    KonfigFBB(&Konfiguration);    

    Kfreigeben();
}


void EndFBB(TZustand *z)
{
}



void ErfrageKonfigFBB(TKonfigFBB *Konfig)
{
    if (Konfig==NULL) {
	printf("ErfrageKonfigFBB(Konfig=NULL) Fehler - NIL-Pointer\n");
    }
    else memcpy(Konfig, &Konfiguration, sizeof(struct TKonfigFBB));
}


/***************************************************************************
 * Konfigurations-Parameter asu Struktur konfig setzen und uebernehmen.
 */ 
void KonfigFBB(TKonfigFBB *Konfig)
{
    if (Konfig==NULL) {
	printf("KonfigFBB(Konfig=NULL) Fehler - NULL-Pointer\n");
    }
    else {
	memcpy(&Konfiguration, Konfig, sizeof(struct TKonfigFBB));
	
	IConfig(EPS, Konfiguration.I_Eps);
	IConfig(ISCHRITT, Konfiguration.I_Schritt);
	IConfig(ISCHRITT_MIN, Konfiguration.I_MinSchritt);
	IConfig(ISCHRITT_MAX, Konfiguration.I_MaxSchritt);
	if (Konfiguration.I_Fehlersteuerung) IConfig(STEPCONTROL, 0.0);
	else IConfig(CONSTSTEP, 0.0);
    }
}


void UngeaendertFBB(TZustand *z)
{
#ifndef NODEBUG
    if (fsb_debug_level>=1) {
	printf("UngeaendertFBB() 1- \n");
    }
#endif
    
    if (integration_initialisiert) zustand_geaendert = FALSE;
#ifndef NODEBUG
    else {
	if (fsb_debug_level>=1) {
	    printf("UngeaendertFBB() 1- integration nicht initialisiert\n");
	}
    }
#endif
    

}



