/********************************************************************************
 *  Projektname:        AERO
 *  Filename:           Kraft.c
 *  Filetyp:            Module
 ********************************************************************************
 *  Modulname:          
 *  Version:            1.0
 *  letzte Aenderung:   
 *  Autor:              Andreas
 *  Status:             finished, only bugs will be fixedIm Aufbau
 *                                                      
 *  imp. Bezeichner:    
 * 
 *  exp. Bezeichner:    
 *
 *  Beschreibung:
 *  -------------
 *                                                                              
 *  Fehler:
 *  -------
 *     
 *  Versionsgeschichte:
 *  -------------------
 *    12.03.93: Erste Arbeiten
 *    09.04.93: Angriffspunkte werden durch eingef"ugtes Objekt markiert."
 *    14.11.94: Fenstername "Richtungsvector bestimme" verenglischt!
 ********************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Command.h>
#include <X11/Shell.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Repeater.h>
#include <X11/Xaw/AsciiText.h>

#include "Welt.h"
#include "vektor.h"
#include "Editor.h"

   extern  void toggleNOStatus (TBoolean);
   extern  void SelektAllButtons (TBoolean);
   extern  void selektiereAuswahlInit (Widget, XtPointer, XtPointer);
   extern  void DObjektEinfuegen (void);
   extern  void Q_MUL (TQuaternion, TQuaternion, TQuaternion);
   extern  void AnzeigeDarstellung(Widget, Widget, Widget, Widget, TVektor darstpos,
                                   TQuaternion q, TReal zoom, TZustand *zustand,
                                   int modus);

extern TSelektKontext SelektKontext;
extern TKoerper *markPosition;


static TKraft *selektierteKraft;
static Widget AP_Shell, AP_label, RV_Shell, KB_Shell, KB_Betrag, KB_Start, KB_Stop, 
              RV_Start, RV_Stop, RV_Betrag, AK_Shell, AK_label; 
static TQuaternion RichtungsVektor;
static TKoerper *selObj;


void Aktion_gerichteteKraft (void)
{
   selektierteKraft->KD.GerKraft.ZielKoerper = selektiertesObjekt;
   selektierteKraft->KD.GerKraft.Zielpunkt[0] = 0.0;
   selektierteKraft->KD.GerKraft.Zielpunkt[1] = 0.0;
   selektierteKraft->KD.GerKraft.Zielpunkt[2] = 0.0;
   selektierteKraft->KD.GerKraft.Kraftbetrag = 10;
   selObj->Kraefte = selektierteKraft;
   SelektKontext = anlegeKraft;
   XtVaSetValues (AP_label, XtNlabel,"determine force direction", NULL);
   markPosition->Naechster = aktuelleWelt->Welt.Koerper;
   aktuelleWelt->Welt.Koerper = markPosition;
   markPosition->Position[0] = selektiertesObjekt->Position[0]; 
   markPosition->Position[1] = selektiertesObjekt->Position[1]; 
   markPosition->Position[2] = selektiertesObjekt->Position[2]; 
   toggleNOStatus (FALSE);
   SelektAllButtons (FALSE);
   AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
                       EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
                       DZoomFaktor, &aktuelleWelt->Welt,
                       KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
   XtPopup (AP_Shell, XtGrabNone);
}


void initKraft (Widget w, XtPointer Typ, XtPointer garbage)
{
   if (selektiertesObjekt->Art != EBENE && selektiertesObjekt->Art != NAGEL)
   {
      selektierteKraft = (TKraft *) malloc (sizeof(TKraft));
      SpeicherFrei (selektierteKraft);
   
      selektierteKraft->Typ = (TKrafttyp) Typ;
      selektierteKraft->Naechste = selektiertesObjekt->Kraefte;
      selektierteKraft->Angriffspunkt[0] = 0.0;
      selektierteKraft->Angriffspunkt[1] = 0.0;
      selektierteKraft->Angriffspunkt[2] = 0.0;
      markPosition->Position[0] = selektiertesObjekt->Position[0];
      markPosition->Position[1] = selektiertesObjekt->Position[1];
      markPosition->Position[2] = selektiertesObjekt->Position[2];
      markPosition->Naechster = aktuelleWelt->Welt.Koerper;
      aktuelleWelt->Welt.Koerper = markPosition;
      SelektKontext = Selektion;
      toggleNOStatus (FALSE);
      SelektAllButtons (FALSE);
      AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
                          EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
                          DZoomFaktor, &aktuelleWelt->Welt,
                          KoordAnAus|KoerperKoordAnAus|KraefteAnAus);

      XtVaSetValues (AP_label, XtNlabel, "determine force point", NULL);
      XtPopup (AP_Shell, XtGrabNone); /* Angriffspunkt bestimmen */
   }
   else fprintf (stderr,"This object doesn't react on forces!\n");
}


void initKraftBetrag (void)
{
     char *trans = malloc (20*sizeof (char));

     sprintf (trans,"%.3f", aktuelleWelt->Welt.Zeit);
     XtVaSetValues (KB_Start, XtNstring, trans, NULL);
     sprintf (trans,"%.3f", aktuelleWelt->Welt.Zeit+1);
     XtVaSetValues (KB_Stop, XtNstring, trans, NULL);
     XtVaSetValues (KB_Betrag, XtNstring,"100", NULL);
     toggleNOStatus (FALSE);
     SelektAllButtons (FALSE);
     XtPopup (KB_Shell, XtGrabNone);
}


void initRichtungsVektor (void)
{
     char *trans = malloc (20*sizeof (char));
     TMatrix A;
     TVektor help;
     
     sprintf (trans,"%.3f", aktuelleWelt->Welt.Zeit);
     XtVaSetValues (RV_Start, XtNstring, trans, NULL);
     sprintf (trans,"%.3f", aktuelleWelt->Welt.Zeit+1);
     XtVaSetValues (RV_Stop, XtNstring, trans, NULL);
     XtVaSetValues (RV_Betrag, XtNstring,"100", NULL);
     RichtungsVektor[0] = 1.0;
     RichtungsVektor[1] = 0.0;
     RichtungsVektor[2] = 0.0;
     RichtungsVektor[3] = 0.0;
     help[0] = 0;
     help[1] = 0;
     help[2] = 10;
     
     RotMatrix (A, RichtungsVektor); 
     MV_MUL2 (selektierteKraft->KD.Kraft, A, help); 
     toggleNOStatus (FALSE);
     SelektAllButtons (FALSE);
     AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
			 EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
			 DZoomFaktor, &aktuelleWelt->Welt,
			 KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
     XtPopup (RV_Shell, XtGrabNone);
}


void AngriffsPunktInc (Widget w, XtPointer Richtung, XtPointer garbage)
{
   TReal SchrittX, SchrittY, SchrittZ;
   TMatrix Matrix;

   switch (selektiertesObjekt->Art)
   {
      case QUADER: SchrittX = selektiertesObjekt->Form.Quader.KantenLaenge[0]/20.0;
                   SchrittY = selektiertesObjekt->Form.Quader.KantenLaenge[1]/20.0;
                   SchrittZ = selektiertesObjekt->Form.Quader.KantenLaenge[2]/20.0;
                   break;
      case ZYLINDER: SchrittX = selektiertesObjekt->Form.Zylinder.Radius/10.0;
                     SchrittZ = selektiertesObjekt->Form.Zylinder.Hoehe/20.0;
                     SchrittY = SchrittX;
                     break;
      case KUGEL: SchrittX = selektiertesObjekt->Form.Kugel.Radius/10.0;
                  SchrittY = SchrittX;
                  SchrittZ = SchrittX;
                  break;
      default: SchrittX = 0.01;
               SchrittY = 0.01;
               SchrittZ = 0.01;
               break;
   }

   switch ((TRichtung) Richtung)
   {
      case XRich: if (SelektKontext == anlegeKraft)
                     selektierteKraft->KD.GerKraft.Zielpunkt[0] += SchrittX;
                  else
                     selektierteKraft->Angriffspunkt[0] += SchrittX;
                  break;
      case YRich: if (SelektKontext == anlegeKraft)
                     selektierteKraft->KD.GerKraft.Zielpunkt[1] += SchrittY;
                  else
                     selektierteKraft->Angriffspunkt[1] += SchrittY;
                  break;
      case ZRich: if (SelektKontext == anlegeKraft)
                     selektierteKraft->KD.GerKraft.Zielpunkt[2] -= SchrittZ;
                  else
                     selektierteKraft->Angriffspunkt[2] -= SchrittZ;
                  break;
   }
   RotMatrix (Matrix, selektiertesObjekt->q);
   if (SelektKontext == anlegeKraft)
   {
      MV_MUL2 (markPosition->Position, Matrix, selektierteKraft->KD.GerKraft.Zielpunkt);
      markPosition->Position[0] += selektierteKraft->KD.GerKraft.ZielKoerper->Position[0];
      markPosition->Position[1] += selektierteKraft->KD.GerKraft.ZielKoerper->Position[1];
      markPosition->Position[2] += selektierteKraft->KD.GerKraft.ZielKoerper->Position[2];
   }
   else
   {
      MV_MUL2 (markPosition->Position, Matrix, selektierteKraft->Angriffspunkt);
      markPosition->Position[0] += selektiertesObjekt->Position[0];
      markPosition->Position[1] += selektiertesObjekt->Position[1];
      markPosition->Position[2] += selektiertesObjekt->Position[2];
   }
   AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
                       EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
                       DZoomFaktor, &aktuelleWelt->Welt,
                       KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
}


void AngriffsPunktDec (Widget w, XtPointer Richtung, XtPointer garbage)
{
   TReal SchrittX, SchrittY, SchrittZ;
   TMatrix Matrix;

   switch (selektiertesObjekt->Art)
   {
      case QUADER: SchrittX = selektiertesObjekt->Form.Quader.KantenLaenge[0]/20.0;
                   SchrittY = selektiertesObjekt->Form.Quader.KantenLaenge[1]/20.0;
                   SchrittZ = selektiertesObjekt->Form.Quader.KantenLaenge[2]/20.0;
                   break;
      case ZYLINDER: SchrittX = selektiertesObjekt->Form.Zylinder.Radius/10.0;
                     SchrittZ = selektiertesObjekt->Form.Zylinder.Hoehe/20.0;
                     SchrittY = SchrittX;
                     break;
      case KUGEL: SchrittX = selektiertesObjekt->Form.Kugel.Radius/10.0;
                  SchrittY = SchrittX;
                  SchrittZ = SchrittX;
                  break;
      default: SchrittX = 0.01;
               SchrittY = 0.01;
               SchrittZ = 0.01;
               break;
   }

   switch ((TRichtung) Richtung)
   {
      case XRich: if (SelektKontext == anlegeKraft)
                     selektierteKraft->KD.GerKraft.Zielpunkt[0] -= SchrittX;
                  else
                     selektierteKraft->Angriffspunkt[0] -= SchrittX;
                  break;
      case YRich: if (SelektKontext == anlegeKraft)
                     selektierteKraft->KD.GerKraft.Zielpunkt[1] -= SchrittY;
                  else
                     selektierteKraft->Angriffspunkt[1] -= SchrittY;
                  break;
      case ZRich: if (SelektKontext == anlegeKraft)
                     selektierteKraft->KD.GerKraft.Zielpunkt[2] += SchrittZ;
                  else
                     selektierteKraft->Angriffspunkt[2] += SchrittZ;
                  break;
   }
   RotMatrix (Matrix, selektiertesObjekt->q);
   if (SelektKontext == anlegeKraft)
   {
      MV_MUL2 (markPosition->Position, Matrix, selektierteKraft->KD.GerKraft.Zielpunkt);
      markPosition->Position[0] += selektierteKraft->KD.GerKraft.ZielKoerper->Position[0];
      markPosition->Position[1] += selektierteKraft->KD.GerKraft.ZielKoerper->Position[1];
      markPosition->Position[2] += selektierteKraft->KD.GerKraft.ZielKoerper->Position[2];
   }
   else
   {
      MV_MUL2 (markPosition->Position, Matrix, selektierteKraft->Angriffspunkt);
      markPosition->Position[0] += selektiertesObjekt->Position[0];
      markPosition->Position[1] += selektiertesObjekt->Position[1];
      markPosition->Position[2] += selektiertesObjekt->Position[2];
   }
   AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
                       EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
                       DZoomFaktor, &aktuelleWelt->Welt,
                       KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
}


void AngriffsPunktApply (Widget w, XtPointer muell, XtPointer garbage)
{
   XtPopdown (AP_Shell);
   aktuelleWelt->Welt.Koerper = markPosition->Naechster;
   markPosition->Naechster = NULL;
   switch (selektierteKraft->Typ)
   {
      case RAUMFEST:
      case KOERPERFEST: SelektKontext = Selektion;
                        selektiertesObjekt->Kraefte = selektierteKraft; 
                        initRichtungsVektor();
                        break;
      case GERICHTET: if (SelektKontext == anlegeKraft)
                        initKraftBetrag();
                      else
                      {
                         SelektKontext = anlegeKraft;
                         selObj = selektiertesObjekt;
                         selektiereAuswahlInit (topLevel, NULL, NULL);
                      }
                      break;
   }
}


void installAngriffsPunkt (void)
{
   Widget AP_box, AP_movXP, AP_movXM, AP_movYP, AP_movYM, AP_movZP, AP_movZM,
          AP_Apply, AP_paned;

   AP_Shell = XtVaCreatePopupShell("see label what to do", topLevelShellWidgetClass, topLevel, NULL);
   AP_paned = XtVaCreateManagedWidget("AP_paned", panedWidgetClass, AP_Shell, NULL);
   AP_label = XtVaCreateManagedWidget("AP_label", labelWidgetClass, AP_paned, NULL);
   AP_box   = XtVaCreateManagedWidget("AP_box", formWidgetClass, AP_paned, NULL);
   AP_movXP = XtVaCreateManagedWidget("AP_movXP", repeaterWidgetClass, AP_box, XtNbitmap, BMovXP, NULL);
   AP_movXM = XtVaCreateManagedWidget("AP_movXM", repeaterWidgetClass, AP_box, XtNbitmap, BMovXM, NULL);
   AP_movYP = XtVaCreateManagedWidget("AP_movYP", repeaterWidgetClass, AP_box, XtNbitmap, BMovYP, NULL);
   AP_movYM = XtVaCreateManagedWidget("AP_movYM", repeaterWidgetClass, AP_box, XtNbitmap, BMovYM, NULL);
   AP_movZP = XtVaCreateManagedWidget("AP_movZP", repeaterWidgetClass, AP_box, XtNbitmap, BMovZP, NULL);
   AP_movZM = XtVaCreateManagedWidget("AP_movZM", repeaterWidgetClass, AP_box, XtNbitmap, BMovZM, NULL);
   AP_Apply = XtVaCreateManagedWidget("AP_Apply", commandWidgetClass,  AP_box, NULL);
   XtAddCallback (AP_movXP, XtNcallback, AngriffsPunktInc, (XtPointer) XRich);
   XtAddCallback (AP_movYP, XtNcallback, AngriffsPunktInc, (XtPointer) YRich);
   XtAddCallback (AP_movZP, XtNcallback, AngriffsPunktInc, (XtPointer) ZRich);
   XtAddCallback (AP_movXM, XtNcallback, AngriffsPunktDec, (XtPointer) XRich);
   XtAddCallback (AP_movYM, XtNcallback, AngriffsPunktDec, (XtPointer) YRich);
   XtAddCallback (AP_movZM, XtNcallback, AngriffsPunktDec, (XtPointer) ZRich);
   XtAddCallback (AP_Apply, XtNcallback, AngriffsPunktApply, NULL);
}


void KraftBetragApply (Widget w, XtPointer muell, XtPointer garbage)
{
     char *trans = malloc (20*sizeof (char));

     XtPopdown (KB_Shell);
     XtVaGetValues (KB_Stop, XtNstring, &trans, NULL);
     selektierteKraft->EndZeit = (TReal) atof (trans);
     XtVaGetValues (KB_Start, XtNstring, &trans, NULL);
     selektierteKraft->StartZeit = (TReal) atof (trans);
     XtVaGetValues (KB_Betrag, XtNstring, &trans, NULL);
     selektierteKraft->KD.GerKraft.Kraftbetrag = (TReal) atof (trans);
     SelektKontext = Selektion;
     toggleNOStatus (TRUE);
     SelektAllButtons (TRUE);
     AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
			 EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
			 DZoomFaktor, &aktuelleWelt->Welt,
			 KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
}


void installKraftBetrag (void)
{
   Widget KB_box, KB_paned, KB_label, KB_Apply, KB_StartTxt, KB_StopTxt,
          KB_BetragTxt;

   KB_Shell = XtVaCreatePopupShell("Kraftbetrag", topLevelShellWidgetClass, topLevel, NULL);
   KB_paned = XtVaCreateManagedWidget("KB_paned", panedWidgetClass, KB_Shell, NULL);
   KB_label = XtVaCreateManagedWidget("KB_label", labelWidgetClass, KB_paned, NULL);
   KB_box   = XtVaCreateManagedWidget("KB_box", formWidgetClass, KB_paned, NULL);
   KB_StartTxt = XtVaCreateManagedWidget("KB_StartTxt", labelWidgetClass, KB_box, NULL);
   KB_Start = XtVaCreateManagedWidget("KB_Start", asciiTextWidgetClass, KB_box, NULL);
   KB_StopTxt = XtVaCreateManagedWidget("KB_StopTxt", labelWidgetClass, KB_box, NULL);
   KB_Stop = XtVaCreateManagedWidget("KB_Stop", asciiTextWidgetClass, KB_box, NULL);
   KB_BetragTxt = XtVaCreateManagedWidget("KB_BetragTxt", labelWidgetClass, KB_box, NULL);
   KB_Betrag = XtVaCreateManagedWidget("KB_Betrag", asciiTextWidgetClass, KB_box, NULL);
   KB_Apply = XtVaCreateManagedWidget("KB_Apply", commandWidgetClass, KB_box, NULL);
   XtAddCallback (KB_Apply, XtNcallback, KraftBetragApply, NULL);
}


void RichtungsVektorApply (Widget w, XtPointer muell, XtPointer garbage)
{
     char *trans = malloc (20*sizeof (char));
     TMatrix A;
     TVektor help;
     
     toggleNOStatus (TRUE);
     SelektAllButtons (TRUE);
     DObjektEinfuegen();
     SelektKontext = Selektion;  /* Zur Vorsicht */
     XtPopdown (RV_Shell);
     XtVaGetValues (RV_Stop, XtNstring, &trans, NULL);
     selektierteKraft->EndZeit = (TReal) atof (trans);
     XtVaGetValues (RV_Start, XtNstring, &trans, NULL);
     selektierteKraft->StartZeit = (TReal) atof (trans);
     XtVaGetValues (RV_Betrag, XtNstring, &trans, NULL);
     /*****************************************************************************
      * Jetzt mu noch eine Transformation stattfinden, von Quaternion nach Vektor 
      * und diesen mit dem Skalar Betrag multiplizieren.
      *****************************************************************************/
     help[0] = 0;
     help[1] = 0;
     help[2] = (TReal) atof (trans);
     
     RotMatrix (A, RichtungsVektor); 
     MV_MUL2 (selektierteKraft->KD.Kraft, A, help); 
     toggleNOStatus (TRUE);
     SelektAllButtons (TRUE);
     DObjektEinfuegen();
     AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
			 EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
			 DZoomFaktor, &aktuelleWelt->Welt,
			 KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
}


void RichtungsVektorAbort (Widget w, XtPointer muell, XtPointer garbage)
{
   selektiertesObjekt->Kraefte = selektierteKraft->Naechste;
   free (selektierteKraft);
   SelektKontext = Selektion;  /* Zur Vorsicht */
   XtPopdown (RV_Shell);
   toggleNOStatus (TRUE);
   SelektAllButtons (TRUE);
   DObjektEinfuegen();
}


void RichtungsVektorUndoRot (Widget w, XtPointer muell, XtPointer garbage)
{
   TVektor help;
   TMatrix A;

   RichtungsVektor[0] = 1.0;
   RichtungsVektor[1] = 0.0;
   RichtungsVektor[2] = 0.0;
   RichtungsVektor[3] = 0.0;
   help[0] = 0;
   help[1] = 0;
   help[2] = 10;
 
   RotMatrix (A, RichtungsVektor); 
   MV_MUL2 (selektierteKraft->KD.Kraft, A, help); 
   AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
                       EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
                       DZoomFaktor, &aktuelleWelt->Welt,
                       KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
}


/*******************************************************************************
 *  
 *
 *  Beschreibung:
 *  -------------
 *  
 ********************************************************************************/

void RichtungsVektorRotPlus (Widget w, XtPointer Richtung, XtPointer garbage)
{
   TMatrix A;
   TVektor help;

   switch ((TRichtung) Richtung)
   {
      case XRich: Q_MUL (RichtungsVektor, CRotXP, RichtungsVektor);
                  break;
      case YRich: Q_MUL (RichtungsVektor, CRotYP, RichtungsVektor);
                  break;
      case ZRich: Q_MUL (RichtungsVektor, CRotZP, RichtungsVektor);
                  break;
   }
   /* jetzt noch ein Refresh des Bildschirms */
   help[0] = 0;
   help[1] = 0;
   help[2] = 10;
 
   RotMatrix (A, RichtungsVektor); 
   MV_MUL2 (selektierteKraft->KD.Kraft, A, help); 
   AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
                       EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
                       DZoomFaktor, &aktuelleWelt->Welt,
                       KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
}


/*******************************************************************************
 *  
 *
 *  Beschreibung:
 *  -------------
 *  
 ********************************************************************************/

void RichtungsVektorRotMinus (Widget w, XtPointer Richtung, XtPointer garbage)
{
   TMatrix A;
   TVektor help;

   switch ((TRichtung) Richtung)
   {
      case XRich: Q_MUL (RichtungsVektor, CRotXM, RichtungsVektor);
                  break;
      case YRich: Q_MUL (RichtungsVektor, CRotYM, RichtungsVektor);
                  break;
      case ZRich: Q_MUL (RichtungsVektor, CRotZM, RichtungsVektor);
                  break;
   }
   /* jetzt noch ein Refresh des Bildschirms */
   help[0] = 0;
   help[1] = 0;
   help[2] = 10;
 
   RotMatrix (A, RichtungsVektor); 
   MV_MUL2 (selektierteKraft->KD.Kraft, A, help); 
   AnzeigeDarstellung (EM_DarstellungXY, EM_DarstellungYZ, EM_DarstellungXZ,
                       EM_Darstellung3D, Koordinatenursprung, Ausrichtung,
                       DZoomFaktor, &aktuelleWelt->Welt,
                       KoordAnAus|KoerperKoordAnAus|KraefteAnAus);
}


void installRichtungsVektor (void)
{
   Widget RV_box, /*RV_paned, RV_label, */RV_StartTxt, RV_StopTxt, RV_Apply,
          RV_rotXP, RV_rotXM, RV_rotYP, RV_rotYM, RV_rotZP, RV_rotZM, RV_Rot,
          RV_undoRot, RV_BetragTxt, RV_Abort;

   RV_Shell = XtVaCreatePopupShell("Set force", topLevelShellWidgetClass, topLevel, NULL);
   RV_box = XtVaCreateManagedWidget("RV_box", formWidgetClass, RV_Shell, NULL);
   RV_Rot = XtVaCreateManagedWidget("RV_Rot", formWidgetClass, RV_box, NULL);
   RV_rotXP = XtVaCreateManagedWidget("RV_rotXP", repeaterWidgetClass, RV_Rot, XtNbitmap, BRotXP, NULL);
   RV_rotXM = XtVaCreateManagedWidget("RV_rotXM", repeaterWidgetClass, RV_Rot, XtNbitmap, BRotXM, NULL);
   RV_rotYP = XtVaCreateManagedWidget("RV_rotYP", repeaterWidgetClass, RV_Rot, XtNbitmap, BRotYP, NULL);
   RV_rotYM = XtVaCreateManagedWidget("RV_rotYM", repeaterWidgetClass, RV_Rot, XtNbitmap, BRotYM, NULL);
   RV_rotZP = XtVaCreateManagedWidget("RV_rotZP", repeaterWidgetClass, RV_Rot, XtNbitmap, BRotZP, NULL);
   RV_rotZM = XtVaCreateManagedWidget("RV_rotZM", repeaterWidgetClass, RV_Rot, XtNbitmap, BRotZM, NULL);
   RV_undoRot = XtVaCreateManagedWidget("RV_undoRot", commandWidgetClass, RV_Rot, NULL);

   RV_StartTxt = XtVaCreateManagedWidget("RV_StartTxt", labelWidgetClass, RV_box, NULL);
   RV_Start = XtVaCreateManagedWidget("RV_Start", asciiTextWidgetClass, RV_box, NULL);
   RV_StopTxt = XtVaCreateManagedWidget("RV_StopTxt", labelWidgetClass, RV_box, NULL);
   RV_Stop = XtVaCreateManagedWidget("RV_Stop", asciiTextWidgetClass, RV_box, NULL);
   RV_BetragTxt = XtVaCreateManagedWidget("RV_BetragTxt", labelWidgetClass, RV_box, NULL);
   RV_Betrag = XtVaCreateManagedWidget("RV_Betrag", asciiTextWidgetClass, RV_box, NULL);
   
   RV_Apply = XtVaCreateManagedWidget("RV_Apply", commandWidgetClass, RV_box, NULL);
   RV_Abort = XtVaCreateManagedWidget("RV_Abort", commandWidgetClass, RV_box, NULL);

   XtAddCallback (RV_rotXP, XtNcallback, RichtungsVektorRotPlus,  (XtPointer) XRich);   
   XtAddCallback (RV_rotXM, XtNcallback, RichtungsVektorRotMinus, (XtPointer) XRich);   
   XtAddCallback (RV_rotYP, XtNcallback, RichtungsVektorRotPlus,  (XtPointer) YRich);   
   XtAddCallback (RV_rotYM, XtNcallback, RichtungsVektorRotMinus, (XtPointer) YRich);   
   XtAddCallback (RV_rotZP, XtNcallback, RichtungsVektorRotPlus,  (XtPointer) ZRich);   
   XtAddCallback (RV_rotZM, XtNcallback, RichtungsVektorRotMinus, (XtPointer) ZRich);  
   XtAddCallback (RV_undoRot, XtNcallback, RichtungsVektorUndoRot, NULL);
   XtAddCallback (RV_Apply, XtNcallback, RichtungsVektorApply, NULL);
   XtAddCallback (RV_Abort, XtNcallback, RichtungsVektorAbort, NULL);
}



void installAendereKraft (void)
{
   Widget AK_box, AK_paned, /*AK_StartTxt, AK_StopTxt,*/ AK_Apply, AK_Abort;

   AK_Shell = XtVaCreatePopupShell("Change force-parameter", topLevelShellWidgetClass, topLevel, NULL);
   AK_paned = XtVaCreateManagedWidget("AK_paned", panedWidgetClass, AK_Shell, NULL);
   AK_label = XtVaCreateManagedWidget("AK_label", labelWidgetClass, AK_paned, NULL);
   AK_box = XtVaCreateManagedWidget("AK_box", formWidgetClass, AK_paned, NULL);

   AK_Apply = XtVaCreateManagedWidget("AK_Apply", commandWidgetClass, AK_box, NULL);   
   AK_Abort = XtVaCreateManagedWidget("AK_Abort", commandWidgetClass, AK_box, NULL);
}
