/********************************************************************************
 *  Projektname		: AERO
 *  Filename		: kollision.h
 *  Filetyp		: Header
 ********************************************************************************
 *  Modulname		: kollision.o
 *  letzte Aenderung	: Donnerstag, 29. August 1996, 17:17:44
 *  Autor		: Horst Stolz (HUS)
 *  Status		: ungetestetes Dummy-File
 *  Zweck               : Kollisionsermittelung, liefert eine 
 *                        "Kollisions"-Liste in der die Art, Ort, usw. der 
 *                        Beruehrung oder Kollision aufgefuehrt ist.
 *
 *  Exportierte Funktionen:
 *
 *   void KollisionsErkennung(TZustand *Z, TKollision **K);
 *   void KoerperKollision(TKollision **K, TKoerper *k1, TKoerper *k2);
 *   void LoescheKolListe(TKollision **K);
 *   void KolListeSpeicherfreigabe(TKollision **K);
 *
 *
 *  Versionsgeschichte:
 *  -------------------
 *  27.01.93      Ort1 und Ort2 sind nun raumfest, KOrt1, KOrt2 werden
 *                noch nicht belegt.
 *  02.04.93      Kollisionsstruktur zwecks ZusGesObj erweitert,
 *                veraltete Eintraege fuer exakte Beruehrungsbest. entfernt
 *                Routine zur Freigabe des Speichers
 *                Kollisionsliste nur zwischen Aufrufen gueltig!!!!
 *  11.04.94      Compiler-Warnings rausgemacht
 *  
 ********************************************************************************/


#ifndef KOLLISION_H
#define KOLLISION_H

#ifndef FOLGESCHRITTBERECHNUNG_H
#include "folgeschrittberechnung.h"
#endif

typedef enum EKollisionArt {BERUEHRUNG, KOLLISION, LOSLOESUNG} TKollisionsArt;

/*
 * Kollisionsinformationen zwischen zwei Koerpern
 */
typedef struct Kollision {		
    struct Kollision   *Naechste; 
    TKoerper	       *Koerper1, *Koerper2; /* Koerper auf den Kol. wirkt */
    TKollisionsArt	Art;
    TReal		Tiefe;
    TVektor		Ort;		/* Raumfester Kollisionspunkt */
    TVektor		Normale;	/* Von K1 nach K2 */
    TVektor		EbenenVek1;	/* Alle Positionsangaben sind raumfest! */
    TVektor		EbenenVek2;	/* Ebenenvektoren bilden Rechtsystem */
    TVektor             Ort1, Ort2;     /* Raumfest, vom Koerper(1,2) aus */

/* Wurde fuer exakte Beruehrkraftbestimmung gebraucht - ueberfluessig
    int 		nr;		* fuer Beruehrungsbehandlung *
    TVektor		d, e1, e2;
    struct Kollision   *NaechsteBer;	* Verlistung der Beruehrungen *
    struct Kollision   *KoerperBer;     * Verlistung der Koerperberuehrungen *
*/

    /* Eigentliche Koerper bzw. Eingebettete Koerper die Kollidiert sind.
     * Bei einem ZusGesObj steht im obigen Koerper? der Verweis auf den
     * ZusGesKoerper(Root) - d.h. der Koerper an dem dann die Kraefte bzw.
     * Stossimpulse angreifen. Im TeilKoerper steht jedoch die Adr. des
     * "eigentlichen" geometrischen eingebetteten Koerpers!
     * Ansonsten ist Koerper?==TeilKoerper?.
     * => Aus dem Teilkoerper? sind die Informationen ueber die Materialart zu
     *    entnehmen!!!!!!!
     * => Am Koerper? sind dagegen die Kraefte anzusetzten.
     *
     */
    TKoerper           *TeilKoerper1, *TeilKoerper2; 
} TKollision;



extern void KollisionsErkennung(TZustand *Z, TKollision **K);
/****************************************************************************
 * Erstellt eine Kollisionsliste des ganzen Zustandes
 * Kollisionsliste K nur zwischen zwei Aufrufen von Routinen dieses Moduls
 * gueltig!!!!!
 */

extern void KoerperKollision(TKollision **K, TKoerper *k1, TKoerper *k2);
/****************************************************************************
 * Erstellt eine Kollisionsliste zwischen dem Koerper k1 und der Koerpern in
 * der Liste k2!!!
 * Kollisionsliste K nur zwischen zwei Aufrufen von Routinen dieses Moduls
 * gueltig!!!!!
 */ 

extern void KolListeLoeschen(TKollision **K);
/****************************************************************************
 * loescht die in der Kollisionsliste K enthaltenen Eintraegeiste K
 * Kollisionsliste muss von diesem Modul erstellt worden sein
 * -> *K = NULL;
 */

extern void KolListeSpeicherfreigabe(TKollision **K);
/****************************************************************************
 * entfernt alle in der Kollisionsliste K enthaltenen Eintrage aus dem
 * Speicher -> *K = NULL;
 */


extern int ke_debug_level;

#endif
