/********************************************************************************
 *  Projektname		: AERO
 *  Filename		: kollisionsbehandlung.c
 *  Filetyp		: C-Source
 ********************************************************************************
 *  Modulname		: kollisionsbehandlung.o
 *  letzte Aenderung	: 31.03.93
 *  Autor		: Horst Stolz (HUS)
 *  Status:		: ungetestetes Dummy-File
 *  
 *  Beschreibung:
 *
 *  
 *  Versionsgeschichte:
 *  26.01.93       Kollisionsbehandlung mit Beruecksichtigung der Stosszahl
 *  27.01.93       Kollisionsbehandlung um gefuehrte Koerper erweitert
 *                 Drehung koerrekt??
 *  31.03.93       SimStoss aus KBehandlung entfernt, nun aber FederStoss
 *                 eingefuehrt!
 *  11.05.94       Compiler Warnings behoben               
 *  
 *  
 ********************************************************************************/

#include <stdio.h>

#include "kollisionsbehandlung.h"
#include "kollision.h"
#include "vektor.h"
#include "fehler.h"
#include "beruehrung.h"
#include "stoss.h"
#include "konfig.h"
#include "ausgabe.h"

int kb_debug_level = 0;

/* MaxBerGeschw = 0.010     Am bestem Wahl KolZeitschrittweite * gravitation */


static TBoolean Kollision_aufgetreten = FALSE;
static int AnzKol;

static TReal Kollisionszeit = 0.0;
static TReal KolTiefe = 0.0;
static TReal Kollisionslose_Zeit = 0.0;
static TKollision *kol = NULL;	/* Kollisionsliste */





void Kfreigeben()
/****************************************************************************
 * Zweck:
 *   Bisher aufgetretene Kollisionen wieder freigeben, da sonst keine
 *   neuen durch den Kollisionstest erkannt werden.
 */
{
    Kollision_aufgetreten = FALSE;
    if (kol) KolListeLoeschen(&kol);
    kol = NULL;
}

TBoolean KStattgefunden() 
/****************************************************************************
 * Rueckgabewert:
 *   sind bisher Kollisionen aufgetreten
 *   
 */
{
    return Kollision_aufgetreten;
}

TReal KZeit() 
/****************************************************************************
 * Rueckgabewert:
 *   Wenn Kollision stattgefunden -> Zeit der fuehesten Kollision.
 */
{
    return Kollisionszeit;
}

TReal KfreieZeit() 
/****************************************************************************
 * Rueckgabewert:
 *   Zeit, ab der noch keine Kollision stattgefunden hatte.
 */
{
    return Kollisionslose_Zeit;
}

TReal KTiefe() 
/****************************************************************************
 * Rueckgabewert:
 *   Falls Kollision stattgefunden hat erhaelt man hier die maximale
 *   Kollisionstiefe
 */
{
    return KolTiefe;
}


TBoolean KTest(TZustand *z, TReal t, TBoolean BerBehandlung)
/****************************************************************************
 * Zweck:
 *   Testet ob im augenblicklichem Zustand z, zum derzeitigen Zeitpunkt t
 *   Kollisionen stattgefunden haben und klassifiziert diese als
 *   BERUEHRUNG, KOLLISION(Stoss) oder LOSLOESUNG.
 *
 *   Falls BerBehandlung auf TRUE gesetzt wurde erfolgt nach der
 *   Klassifizierung eine Beruehrungsbehandlung in der die Beruehrungs- 
 *   und Reibungskraeft in die Bewegungsgleichungen einfliessen.
 *
 *   Es gibt weiter die Moeglichkeit per Konfigurationsparameter 
 *   K_FederStoss alle Kollisionen als Beruehrungen zu Behandeln, wodurch 
 *   auch Stoesse(die eigentlich erst durch KBehandlung() geloest werden)
 *   durch Beruehrungskraefte simuliert werden.
 * 
 *   Weiter werden folgende Daten von der Routine gesammelt:
 *   - ob ein Stoss stattgefunden hat (per KStattgefunden() abfragbar)
 *   - zu welcher Zeit die Routine aufgerufen wurde inder im Zustand kein
 *     Stoss aufgetreten ist (per KfreieZeit() erfragbar)
 *   - wann eine Kollision stattgefunden hat und mit was fuer einer minimale
 *     Kollisionstiefe. (durch KZeit() und KTiefe() erfragbar)
 *   - weiter wird noch die Anzahl der Koll. in der Kollisionsliste
 *     ermittelt (fuer den privaten Gebrauch in AnzKol)
 *
 *   WICHTIG:
 *     Falls ein Stoss stattgefunden hat wird falls die Zeit t vor der
 *     letzten Kollisionszeit lieft diese nun als Frueheste Kollision mit 
 *     Stoessen genommen.
 *     Auch merkt sich die durch die KollisionsErkennung(..) erhaltene
 *     Kollisionsliste, fruehrer werden geloescht, sodass nach KTest(..) 
 *     immer die Kollisionsliste zum Zeitpunkt t zur Behandlung 
 *     mit KBehandlung(..) bereit steht.
 *     ==> Dass heist nun das Stoesse die vor t aufgetreten sind 
 *         nun dadurch erkennbar sind das die KZeit() eben kleiner als
 *         die Momentane Zeit t ist! ACHTUNG es steht aber nur die
 *         Kollisionsliste zur Zeit t zur Verfuegung. Will man nun eine
 *         Kollisionsbehandlung zu einer frueheren Zeit machen muss sie 
 *         zuerst durch Kfreigeben() freigemacht werden. (Dann wider KTest()
 *         aufrufen!)
 *     
 *   
 * Parameter:
 *   Zeit t, Zustand z, 
 *   BerBehandlung - ob Beruehrungskraefte errechnet werden sollen 
 *   
 * Rueckgabewert:
 *   TRUE falls zum Zeitpunkt t oder frueher ein Stoss(KOLLISION) aufgetreten
 *   ist.
 *   
 * Seiteneffekte:
 *   auf die lokalen Variablen: Kollisionszeit, KolTiefe, Kollision_aufgetreten,
 *   Kollisionslose_Zeit, kol.
 *   
 * Siehe weiter:
 *   KollisionsErkennung(), Beruehrung(), KBehandung(),
 *   Kfreigeben(), KStattgefunden(), KZeit(), KfreieZeit(), KTiefe()
 *
 * Fehler:
 *   
 */
{
    TKollision *ko;
    TKoerper   *k1, *k2;
    TReal normgeschw;
    TBoolean    kolja = FALSE;
    int anzber;

    FehlerOrt("KTest()");

#ifndef NODEBUG
	    if (kb_debug_level>=1)
		printf("KTest(t=%f, BerBeh=%s) 1-\n", 
		       t, BerBehandlung ? "true" : "false");
#endif

    if (Kollision_aufgetreten) {
#ifndef NODEBUG
	    if (kb_debug_level>=1)
		printf("KTest() 1- schon frueher Kollision aufgetreten!\n");
#endif
	/*    return TRUE; */
    } 

    if (kol) KolListeLoeschen(&kol);
    kol = NULL;

    /* Schneiden sich Koerper raeumlich?
     */
    if (Konfiguration.K_Kollisionserkennung) KollisionsErkennung(z, &kol);

    if (kol==NULL) return FALSE;

    anzber = 0;                              /* Anzahl der Beruehrpunkte zaehlen */
    AnzKol = 0;				     /* Anzahl der Schnitte zaehlen */
    KolTiefe = 1e+30;			     /* minimale Beruehrungstiefe testen */


    /* Klassifizierung der Kollision in BERUEHRUNG, KOLLISION und LOSLOESUNG
     */
    if (Konfiguration.K_FederStoss) {        /* Federstoss */
	for (ko=kol; ko; ko=ko->Naechste) {  /* alle Kollisionen */
	    AnzKol++;                        /* sind BERUEHRUNGEN */
	    ko->Art = BERUEHRUNG;
	    anzber++;
	}
    }
    else for (ko=kol; ko; ko=ko->Naechste) { /* Penality-Methode & Analy.Stoss */
	AnzKol++;
	k1 = ko->Koerper1;
	k2 = ko->Koerper2;
	normgeschw = NormGeschw(k1->ty->v, k1->ty->w, ko->Ort1, 
				k2->ty->v, k2->ty->w, ko->Ort2, ko->Normale);
	
#ifndef NODEBUG       
	if (kb_debug_level>=3)
	  printf("KTest() 3- Kol#%d hat NormGeschw=%f\n", AnzKol, normgeschw);
#endif

	if (normgeschw > Konfiguration.B_MaxBerGeschw) {
	    ko->Art = KOLLISION;
	    if (ko->Tiefe < KolTiefe) KolTiefe = ko->Tiefe;
	    kolja = TRUE;
	}
	else if (normgeschw >= -Konfiguration.B_MaxBerGeschw) {
	    ko->Art = BERUEHRUNG;
	    anzber++;
	}
	else {
	    ko->Art = LOSLOESUNG;
	}
    }

    /* Kollisionszeit und Kollision_aufgetreten richtig setzten
     */
    if (kolja) {
	if ((Kollision_aufgetreten && t<Kollisionszeit)
	    || (Kollision_aufgetreten==FALSE)) {
	    Kollision_aufgetreten = TRUE;
	    Kollisionszeit = t;
	}
    }
    if (kolja==FALSE) {
	Kollisionslose_Zeit = t;
#ifndef  NODEBUG
	if (kb_debug_level>=1)
	  printf("KTest() 1- keine Kollisionen mit NormGeschw>%f\n",
		 Konfiguration.B_MaxBerGeschw);
#endif
	
    } else {
#ifndef NODEBUG
	if (kb_debug_level>=1) {
	    printf("KTest() 1- Kollision mit t=%f, MinKolTiefe=%f, t_kol=%f, t_kolfrei=%f)\n",
		    t, KolTiefe, Kollisionszeit, Kollisionslose_Zeit);
	}
#endif
    }

    /* Behandlung der Beruehrungen
     */
    if (anzber>0) {
#ifndef NODEBUG
	    if (kb_debug_level>=1)
		printf("KTest() 1- %d Beruehrungen aufgetreten\n", anzber);
#endif
	    if (BerBehandlung) Beruehrung(kol, z->MaterialDaten);
    }


    return Kollision_aufgetreten;
}



void KBehandlung(TZustand *z, TReal t)
/****************************************************************************
 * Zweck:
 *   Alle Kollisionen die keine Beruehrungen oder Losloesungen sind
 *   werden als Sto3 behandelt und dementsprechend berechnet.
 *   
 * Parameter:
 *   Zustand und Koll-Zeitpunkt t
 *   
 */
{
    TKollision *ko;
    TKoerper   *k1, *k2;
    TBoolean kol_stattgefunden;
    TReal normgeschw;

    FehlerOrt("KBehandlung()");


#ifndef NODEBUG
	    if (kb_debug_level>=1)
		printf("KBehandlung(t=%f) 1-\n", t);
#endif

    if (Kollision_aufgetreten == FALSE)
	Fehler("ist gar keine Kollision aufgetreten?!");

    /* fuehre so lange eine Kollisionsbehandlung durch bis
     * Keine Normalgeschwindigkeit>0 ist oder maximal nkol+1 Schritte!
     */ 
    for (; AnzKol>=0; AnzKol--) {
	kol_stattgefunden = FALSE;
	for (ko=kol; ko; ko=ko->Naechste) {
	    k1 = ko->Koerper1;
	    k2 = ko->Koerper2;

	    normgeschw = NormGeschw(k1->ty->v, k1->ty->w, ko->Ort1,
			            k2->ty->v, k2->ty->w, ko->Ort2, ko->Normale);
	    if 	(normgeschw > Konfiguration.B_MaxBerGeschw) {
		ko->Art = KOLLISION;
#ifndef NODEBUG
		if (kb_debug_level>=2) {
		    printf("KBehandlung() 2- Kollision bei t=%f, Normgeschw.=%f\n",
			   t, normgeschw);
		    printvektor("KBehandlung() 2- Kollisionsort=", ko->Ort);
		}
#endif

		Stoss(ko, z->MaterialDaten);

		kol_stattgefunden = TRUE;
	    } else if (normgeschw >= -Konfiguration.B_MaxBerGeschw) {
		ko->Art = BERUEHRUNG;
#ifndef NODEBUG
		if (kb_debug_level>=2) {
		    printf("KBehandlung() 2- Beruehrung bei t=%f, NormGeschw=%f\n",
			   t, normgeschw);
		}
#endif
	    } else {
		ko->Art = LOSLOESUNG;
	    }

	}
	if (kol_stattgefunden==FALSE) break;
    }	    

    Kfreigeben(&kol);

}



