/********************************************************************************
 *  Projektname		: AERO - Teilprojekt FSB
 *  Filename		: materialien.h
 *  Filetyp		: Header
 ********************************************************************************
 *  Modulname		: materialien.o
 *  letzte Aenderung	: Donnerstag, 29. August 1996, 17:06:47
 *  Autor		: Horst Stolz (HUS)
 *  
 *  Beschreibung:
 *  
 *  Exportierte Funktionen/Makros:
 * 
 *  Noch zu machen:
 *
 *  Versionsgeschichte:
 *    0:  24.01.93	Materialdef. aus fsb..h genommen
 *    1:  12.03.94      Materialdef umgeschrieben um eine einfachere Def. zu ermoeglichen
 *                      Dehnungs und Daempfungsfaktor eingefuehrt fuer Penality-Methode
 *  
 ********************************************************************************/
#ifndef MATERIALIEN_H
#define MATERIALIEN_H

#ifndef GRUNDTYPEN_H
#include "grundtypen.h"
#endif


/****************************************************************************
 * Materialdefinitionen
 * hier stehen die zu benutzenden Groessen fuer die Kollision noch nicht fest
 * Die Reibungs- und In.-Dichte bleiben auf jeden Fall!
 * Die Materialtabelle sollte bei Programmstart durch eine Materialdatei init-
 * ialisiert werden.
 */ 

#define EISEN   0
#define PLASTIK 1
#define LIGHT   2
#define MAX_MAT 3

typedef	 unsigned short  TMaterial;


/*
 *
 * Materialtabelle
 */
typedef struct TMaterialTabelle {
  int   AnzahlMaterialien;
  int   MaxMatAnz;
  char  **MaterialNamen;  /* 1 mehr als in MaxMatAnz wegen NULL-Abschluss */
  TReal	*Haftreibungsfaktor;
  TReal	*Gleitreibungsfaktor;
  TReal *Stossfaktor;	  
  TReal *Dichte;
  TReal *Dehnungsfaktor;
  TReal *Daempfungsfaktor;

/* ----- Erweiterungswerte (fuer Raytracer) ----- */
  unsigned short *DefaultR;
  unsigned short *DefaultG;
  unsigned short *DefaultB;
  TReal *Durchsichtigkeit;
  TReal *Reflexion;
  TReal *Rauhigkeit;
  unsigned short *Flags;
} TMaterialTabelle;



/* Grundmaterialtabelle die auf jeden Fall zur Verfuegung steht
 * und in der schon einige elementare Materialien eingetragen sund
 */
extern TMaterialTabelle GrundMaterialien;



extern TReal Elastizitaet(TMaterialTabelle *mt, TMaterial m1, TMaterial m2);
/****************************************************************************
 * Zweck:
 *   Ermittelung und Rueckgabe der Stoss-Zahl zwischen zwei Materialien
 */


extern TReal Gleitreibung(TMaterialTabelle *mt, TMaterial m1, TMaterial m2);
/****************************************************************************
 * Zweck:
 *   Ermittelung und Rueckgabe der Gleitreibungs-Zahl zwischen zwei Materialien
 */


extern TReal Haftreibung(TMaterialTabelle *mt, TMaterial m1, TMaterial m2);
/****************************************************************************
 * Zweck:
 *   Ermittelung und Rueckgabe der Haftreibungs-Zahl zwischen zwei Materialien
 */


extern TReal Dichte(TMaterialTabelle *mt, TMaterial m);
/****************************************************************************
 * Zweck:
 *   Rueckgabe der Dichte eines Materials
 */

/*---------------------------------------------------------------------------*/

/*****************************************************************************
 * Ergaenzungen fuer Raytracer: Default-Farbe, -Durchsichtigkeit, -Reflexion
 *                              und -Rauhigkeit.
 *****************************************************************************/

extern unsigned short DefaultR(TMaterialTabelle *mt, TMaterial m);
/****************************************************************************
 * Zweck:
 *   Rueckgabe des Rotwerts (0..65535) der Default-Farbe eines Materials
 */

extern unsigned short DefaultG(TMaterialTabelle *mt, TMaterial m);
/****************************************************************************
 * Zweck:
 *   Rueckgabe des Gruenwerts (0..65535) der Default-Farbe eines Materials
 */

extern unsigned short DefaultB(TMaterialTabelle *mt, TMaterial m);
/****************************************************************************
 * Zweck:
 *   Rueckgabe des Blauwerts (0..65535) der Default-Farbe eines Materials
 */

extern TReal DefaultDurchsichtigkeit(TMaterialTabelle *mt, TMaterial m);
/****************************************************************************
 * Zweck:
 *   Rueckgabe der Default-Durchsichtigkeit (0.0..1.0) eines Materials 
 *                                                            (-> Raytracer)
 */

extern TReal DefaultReflexion(TMaterialTabelle *mt, TMaterial m);
/****************************************************************************
 * Zweck:
 *   Rueckgabe der Default-Reflexion (0.0..1.0) eines Materials (-> Raytracer)
 */

extern TReal DefaultRauhigkeit(TMaterialTabelle *mt, TMaterial m);
/****************************************************************************
 * Zweck:
 *   Rueckgabe der Default-Rauhigkeit (0.0..1.0) eines Materials (-> Raytracer)
 */

/*---------------------------------------------------------------------------*/


extern char **MaterialNamen(TMaterialTabelle *mt);
/****************************************************************************
 * Zweck:
 *   Rueckgabe der MaterialNamens-Tabelle
 */


extern int AnzahlMaterialien(TMaterialTabelle *mt);
/****************************************************************************
 * Zweck:
 *   Anzahl in der Materialtabelle enthaltenen Material-Elemente
 */


extern TReal Daempfungsfaktor(TMaterialTabelle *mt, TMaterial m1, TMaterial m2);
/****************************************************************************
 * Zweck:
 *   Ermittelung und Rueckgabe des Daempfungsfaktor zwischen zwei Materialien
 */


extern TReal Dehnungsfaktor(TMaterialTabelle *mt, TMaterial m1, TMaterial m2);
/****************************************************************************
 * Zweck:
 *   Ermittelung und Rueckgabe der Daempfungskonstante zwischen zwei Materialien
 */


extern void LoescheMatTab(TMaterialTabelle *mt);
/****************************************************************************
 * Zweck:
 *   Entfernt eine Materialtabelle aus dem Speicher
 *   
 */


extern TMaterialTabelle *AllokiereMatTab(int MaxMatAnz);
/****************************************************************************
 * Zweck:
 *   Belegt Speicher fuer eine Materialtabellen-Struktur. und gibt die
 *   initialisierte Struktur zurueck. Es wird Platz gehalten fuer
 *   MaxMatAnz-Elemente.
 *   
 * Parameter:
 *   MaxMatAnz - Maximales Anzahl Eintraege die in der Materialtabelle
 *               moeglich sind
 *   
 * Rueckgabewert:
 *   Zeiger auf die (noch leere) Materialtabelle
 *   
 * Seiteneffekte:
 *   Wenn kein Speicher allokiert werden kann wird mit einem Fehler rausgegangen.
 *   
 */






extern TBoolean ErgaenzeMatTab(TMaterialTabelle *mt, char *name,
			       TReal Dichte, TReal Haftfaktor, 
			       TReal Gleitfaktor, TReal Stossfaktor, 
			       TReal Dehnfaktor, TReal Daempffaktor);
/****************************************************************************
 * Zweck:
 *   Ergaenzt die Materialtabelle um ein neues Element.
 *   Dies geht nur gut wenn noch Platz ist (MaxMatAnz<AnzahlMaterialien)
 *   
 * Parameter:
 *   mt - Materialtabelle in die eingetragen werden soll.
 *   alle anderen sind selbserklaerend
 *   
 * Rueckgabewert:
 *   TRUE wenn die Materialtabelle schon voll ist.
 *   FALSE wenn Material korrekt eingetragen werden konnte.
 *   
 * Seiteneffekte:
 *   Wenn kein Speicher allokiert werden kann wird mit einem Fehler rausgegangen.
 *   Auch bei mt==NULL wird mit Fehler(..) rausgegangen.
 *   
 */



extern TBoolean ErgaenzeMatTab2(TMaterialTabelle *mt, char *name,
				TReal Dichte, TReal Gleitfaktor, 
				TReal Haftfaktor, TReal Stossfaktor, 
				TReal Dehnfaktor, TReal Daempffaktor,
				unsigned short DefaultR, 
				unsigned short DefaultG, 
				unsigned short DefaultB, 
				TReal Durchsichtigkeit, TReal Reflexion, 
				TReal Rauhigkeit);

/****************************************************************************
 * Zweck:
 *   Ergaenzt die Materialtabelle um ein neues Element.
 *   Dies geht nur gut wenn noch Platz ist (MaxMatAnz<AnzahlMaterialien)
 *   Erweitert gegenueber ErgaenzeMatTab2 durch Farb-Werte!  
 * 
 * Parameter:
 *   mt - Materialtabelle in die eingetragen werden soll.
 *   alle anderen sind selbserklaerend
 *   
 * Rueckgabewert:
 *   TRUE wenn die Materialtabelle schon voll ist.
 *   FALSE wenn Material korrekt eingetragen werden konnte.
 *   
 * Seiteneffekte:
 *   Wenn kein Speicher allokiert werden kann wird mit einem Fehler rausgegangen.
 *   Auch bei mt==NULL wird mit Fehler(..) rausgegangen.
 *   
 */

#endif
