/********************************************************************************
 *  Projektname:	AERO
 *  Filename:		visualisierung.h
 *  Filetyp:		Header
 ********************************************************************************
 *  Modulname:		Anzeige
 *  Version:		0.0.2
 *  letzte Aenderung:	Montag, 11. September 1995, 13:42:38
 *  Autor:  		Hartmut 
 *  Status:		Enthaelt die Grundtypen fuer alle Visualisierungsroutinen
 *				 
 *  imp. Bezeichner:	div. Typennamen
 * 
 *  exp. Bezeichner:    keine, nur lokales Headerfile fuer mich
 *
 *  Beschreibung:	
 *  -------------	
 *  Lokaler (=privater) Header fuer die Darstellungs- und Animationsroutinen. Hier
 *  koennen verschiedene Parameter veraendert werden und hier sind diverse Typen
 *  fuer diese Routinen definiert.
 *									       
 *  Versionsgeschichte:							       
 *  -------------------			
 *  0.0.1:  aus anzeige.h hervorgegangen
 *  0.0.2:  Makro AVektorLaenge(v) hinzugekommen
 ********************************************************************************/

#ifndef VISUALISIERUNG_H
#define VISUALISIERUNG_H

#include <X11/Intrinsic.h>       
#include <X11/StringDefs.h>
#include <limits.h>
#include "grundtypen.h"
#include "koerper.h"
#include "verbindungen.h"
#include "zustand.h"
#include "anzeigeconst.h"

/*----------------------------------------------------------------------------
  Definitionen fuer Darstellung und Animation
  ----------------------------------------------------------------------------*/

/*****************************************************************************
 * Um die Anzeige auch auf Graphiksystemen mit abweichenden Koordinatenverein- 
 * barungen benutzen zu koennen, kann hier angegeben werden, in welche Richtung
 * die Bildschirmkoordinaten wachsen:
 *   x-Werte (horizontal):  1.0: x wird nach rechts groesser (Normalfall)
 *                         -1.0: x wird nach links groesser
 *   y-Werte (vertikal):    1.0: y waechst nach oben (mathem. Ausrichtung)
 *                         -1.0: y waechst nach unten (ueblich bei Bildschirmen)
 * Diese Werte werden auf die Koordinaten aufmultipliziert. Jedoch sollten
 * hier keine Skalierungen vorgenommen werden (dies geht mit DARST_ZOOM bzw.
 * ANIM_ZOOM), sondern wirklich nur 1.0 und -1.0 verwendet werden. Ueblicher-
 * weise wird hier sowieso keine Aenderung noetig sein.
 *****************************************************************************/

#define B_ACHSEN_X 1.0			  /* x-Werte wachsen nach rechts */
#define B_ACHSEN_Y -1.0			  /* y-Werte wachsen nach unten */


/*****************************************************************************
 * Bis jetzt haben Verbindungen keine eigene Farbe, sondern werden in einer
 * Default-Farbe hingezeichnet. Diese Default-Farbe kann hier mit ihren RGB-
 * werten festgelegt werden.
 *****************************************************************************/

/* momentan sind Verbindungen schwarz */
#define VERBINDUNG_R 0
#define VERBINDUNG_G 0
#define VERBINDUNG_B 0



/* Defaultabstand fuer die Augen */
#define AUGENABSTAND 0.05



/* Datentyp fuer einen Koordinatenwert fuer X-Windows */
typedef short AXKoord;



/* Datentyp fuer eine Farbnummer bei X-Windows */
typedef unsigned long AXColornum;


#define AXmin SHRT_MIN			  /* Minimale X-Windows-Koordinate */
#define AXmax SHRT_MAX			  /* Maximale X-Windows-Koordinate */



/* Projizierte Linie im Window (2D): */

typedef struct 
{
     AXKoord x1,y1,x2,y2;
} ALinie;




/* Speicherbedarf einer Linie */

#define DARST_LINIE_SIZE (sizeof(ALinie))




/* Matrix fuer Transformationen mit homogenen 3D-Koordinaten */

typedef TReal AMatrix[4][4];



/************************************************************************
 * Makro, das testet, ob der angegebene TReal-Wert nahezu 0 ist. Diese 
 * Pruefung ist notwendig, da durch Rechenungenauigkeiten evtl. der
 * Vergleich mit genau 0.0 fehlschlaegt.
 ************************************************************************/

/* maximale Abweichung von 0 */
#define EPSILON 1e-7

#define NAHE_0(x) (fabs(x) < EPSILON)


/************************************************************************
 * Makro, das die Laenge eines Vektors vom Typ TVektor ermittelt.
 * ACHTUNG! Jedes Vektorelement wird 2x ausgewertet
 ************************************************************************/

#define AVektorLaenge(v) (sqrt(v[0]*v[0]+v[1]*v[1]+v[2]*v[2]))


/************************************************************************
 * Makro, das einen Wert quadriert. ACHTUNG! das Argument wird 2x aus-
 * gewertet.
 ************************************************************************/

#define sqr(x) ((x) * (x))



#endif /* #ifndef VISUALISIERUNG_H */ 
