/* AnimThread.h */

#ifndef ANIMTHREAD_H
#define ANIMTHREAD_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/time.h>
#include <time.h>

// QT includes
#include <qthread.h>
#include <qapplication.h>

#include "PixWidget.h"
#include "imageSeq.h"
#include "SrcWidget.h"

// Number of samples to average for frames per second
#define NUMPOINTS 4

class AnimThread : public QThread
{
	public:
		void run();
		void setFPS(int fps);
		void setUnlimitedFPS(bool toggle);

	private:
		void tick();

		int inv_fps;

		bool unlimited;

		PixWidget *pw;
		imageSeq *seq;
};

#endif
