#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../FW/labImage.h"
#include "../FW/labImgDraw.h"
#include "contour.h"
#include "multithres.h"
#include "contourtrack.h"  

#define ANZAHL_SCHWELLEN 20 /* Anzahl der Schwellen */
#define OBERGRENZE       2000  
#define UNTERGRENZE      50    

/* Parameter fuer das Konturtracking */
#define MAXFELD         80000   /* Maximale Laenge der Konturliste */   

/* Mehrschwellenverfahren */
static int grauwerte[ANZAHL_SCHWELLEN];
unsigned int anzahl_schwellen;

/*Konturtracking*/
static int Konturschritte[MAXFELD]={0};
//static Picture *Konturbild;

void contour(Picture *p_in, Picture *p_out,int par1, int par2, int par3 )
{  
  Picture *p_tmp1;
  
  anzahl_schwellen=par1;

  p_tmp1=mehrschwellen(p_in,&anzahl_schwellen,
		      OBERGRENZE,UNTERGRENZE,grauwerte);    
   
  
  konturtracking(p_tmp1,grauwerte,anzahl_schwellen,Konturschritte);  
  
  p_tmp1=MONO2RGB(p_tmp1); 
  
  konturbild_zeichnen(p_tmp1,Konturschritte);  
  
  p_out=MONO2RGB(p_out);

  memcpy((unsigned char *)p_out->data,
  	 (unsigned char *)p_tmp1->data,p_tmp1->datasize);

//  for(int i=0;i<(p_tmp1->width*p_tmp1->height);i+=3) {
//	  p_out->data[i  ] = p_tmp1->data[i+2]; // B
//	  p_out->data[i+1] = p_tmp1->data[i+1]; // G
//	  p_out->data[i+2] = p_tmp1->data[i  ]; // R
//	  p_out->data[i+3] = 0;                 // a
//  }

  freeImage(p_tmp1);
}


/************************************************/
/* Konturen zeichnen,anhand der Konturschritte	*/
/************************************************/
int konturbild_zeichnen(Picture *p_in, int E[])
{
  int temp=5,anz=0;
  int i,j;
  int X, Y, RL=0;
  
  int DX[8] = {1, 1, 0, -1, -1, -1, 0, 1};
  int DY[8] = {0, -1, -1, -1, 0, 1, 1, 1};
   
  clearImage(p_in);
  
  anz=0;temp=5;RL=0;
  /* Schliesslich Bild Zeichnen */
  for(i=0;i<=E[0];i++)
    {
      if(E[4 + anz]<0)
	{
	  setDrawColorImageR(200);
	  setDrawColorImageG(0);
	  setDrawColorImageB(0);
	}
      else
	{
	  setDrawColorImageR(0);
	  setDrawColorImageG(200);
	  setDrawColorImageB(0);
	}
      
      X=E[2 + anz];
      Y=E[3 + anz];
      
      for(j=anz+5;j<=(E[1 + anz] + 4 + anz) ;j++)
	{
	  PutPixelInImage(p_in,X,Y);
	  RL=E[j];
	  X=X+DX[RL];
	  Y=Y+DY[RL];
	}
      
      
      if(anz==0)
	temp = 1;				/* initialisieren*/ 
      else
	temp = anz+1;			/* alten Wert merken*/ 
      
      anz +=(E[temp] + 4) ;	/* index der neuen Kontur berechnen */
      
    }
  
  return 1;
}


