#ifndef IPL_PLUGIN_H
#define IPL_PLUGIN_H

#if defined (__cplusplus)
extern "C" {
#endif

#define MAX_IMAGE_SIZE (320*240)

/*  Edges  */
void IPL_sobel(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
void IPL_laplace(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
void IPL_corner(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);

/*  General  */
void IPL_min(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
void IPL_max(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
void IPL_mean(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
void IPL_median(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
void IPL_identity(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
void IPL_negation(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
void IPL_noise(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
void IPL_show(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
void IPL_difference(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);

/*  Format  */
void IPL_threshold(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
void IPL_gray_stretch(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
void IPL_dither(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
void IPL_col2gray(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
void IPL_HSVValue(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
void IPL_gray_reduce(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);

/*  Advanced  */
void IPL_match_color_range(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);

/*  Region  */
void IPL_region_growing(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);

/*  Morphology  */
char struc[] = {1, 1, 1, 1, 1, 1, 1, 1, 1};
void IPL_bin_dilation(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
void IPL_bin_erosion(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
void IPL_bin_open(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
void IPL_bin_close(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
void IPL_bin_fill(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
void IPL_bin_connected(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
void IPL_bin_boundary(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
void IPL_bin_skeleton(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);

/*  Combination  */
void IPL_and(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
void IPL_or(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);

/*  Greyscale Morphology  */
void IPL_erosion(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
void IPL_dilation(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);

/*
 * Internal Routines
 */
void IPLi_and(Picture *p_imageIn1, Picture *p_imageIn2, Picture *p_imageOut);
void IPLi_or(Picture *p_imageIn1, Picture *p_imageIn2, Picture *p_imageOut);
int IPLi_equal(Picture *p_imageIn1, Picture *p_imageIn2);
//int IPLi_equal_nobound(Picture *p_image1, Picture *p_image2);
//int IPLi_count_nobound(Picture *p_imageIn, Picture *p_imageOut, BYTE val);
int IPLi_count_nobound(Picture *p_imageIn, BYTE val);
void IPLi_rgbToHsv(double r, double g, double b, double *h, double *s, double *v);
void IPLi_col_invert(BYTE *rgb);

#if defined (__cplusplus)
}
#endif

#endif
