#ifndef IMPROVQT_H
#define IMPROVQT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>

// QT includes
#include <qapp.h>
#include <qaccel.h>
#include <qmainwindow.h>
#include <qaction.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qstatusbar.h>
#include <qwhatsthis.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qmsgbox.h>
#include <qfiledialog.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qspinbox.h>
#include <qlabel.h>
#include <qmultilineedit.h>

// application specific includes
#include "ImprovQTview.h"
#include "ImprovQTOpt.h"
#include "ParamWidget.h"
//#include "StatusWidget.h"

#define IDLEMSG "Ready."
#define PLAYINGMSG "Playing:"

/** This Class is the base class for the application. It sets
  * up the main window and providing a menubar, toolbar and 
  * statusbar. For the main view, an instance of class 
  * ImprovQTView is created which creates your view.
  */
class ImprovQTApp : public QMainWindow
{
	Q_OBJECT
  
	public:
		/** construtor */
		ImprovQTApp();
		/** destructor */
		~ImprovQTApp();
		/** initializes all QActions of the application */
		void initActions();
		/** initMenuBar creates the menu_bar and inserts the menuitems */
		void initMenuBar();
		/** this creates the toolbars. Change the toobar
		 * look and add new toolbars in this function
		 */
		void initToolBar();
		/** setup the statusbar */
		void initStatusBar();
		/** setup the mainview */
		void initView();
		/** */
		void initCamera();
		/** overloaded for Message box on last window exit */
		bool queryExit();

	public slots:
		/** open a document */
		//void slotFileOpenImage();
		/** save a document */
		void slotFileSaveImage();
		/** save a document under a different filename */
		//void slotFileSaveImageAs();
		/** save the configuration */
		void slotFileSaveConfig();
		/** save the configuration under a different filename */
		void slotFileSaveConfigAs();
		/** close the actual file */
		void slotFileClose();
		/** print the actual file */
		void slotFilePrint();
		/** edit the application options */
		void slotFileOptions();
		/** exits the application */
		void slotFileQuit();

		/** put the marked text/object into the clipboard and remove it from the document */
		//void slotEditCut();
		/** put the marked text/object into the clipboard */
		//void slotEditCopy();
		/** paste the clipboard into the document */
		//void slotEditPaste();

		/** toggle the toolbar */
		void slotViewToolBar(bool toggle);
		/** toggle the statusbar */
		void slotViewStatusBar(bool toggle);
		/** */
		void slotViewCameraOptions(bool toggle);

		/** */
		void slotAnimBackward();
		/** */
		void slotAnimStop();		
		/** */
		void slotAnimPlay();
		/** */
		void slotAnimForward();
		/** */
		void slotAnimFastForward();
		/** */
		void slotAnimRewind();
	
		/** shows a help dlg */
		void slotHelp();
		/** shows an about dlg */
		void slotHelpAbout();

		/** long-winded way to set frames per second  */
		void slotSetFPS(int fps);
		/** toogle unlimited fps */
		void slotSetUnlimitedFPS(bool toggle);

	protected:
		void closeEvent(QCloseEvent * e);

	private:

		/** view is the main widget which represents your working area. The View
		 * class should handle all events of the view widget.  It is kept empty so
		 * you can create your view according to your application's needs by
		 * changing the view class.
		 */
		ImprovQTView *view;

		/** file_menu contains all items of the menubar entry "File" */
		QPopupMenu *fileMenu;
		/** view_menu contains all items of the menubar entry "View" */
		QPopupMenu *viewMenu;
		/** view_menu contains all items of the menubar entry "Help" */
		QPopupMenu *helpMenu;
		/** the main toolbar */
		QToolBar *fileToolbar;

		/* the animation toolbar (play, stop etc.) */
		QToolBar* animToolbar;
		QLabel* targetLabel;

		/* the parameter toolbar */
		QToolBar* paramToolbar;
		ParamWidget* paramWidget;

		/** Actions for the application initialized in initActions()
		 * and used to en/disable them according to your needs during
		 * the program
		 */
		//QAction *fileOpenImage;
		QAction *fileSaveImage;

		QAction *fileSaveConfig;
		QAction *fileSaveConfigAs;

		QAction *fileOptions;

		QAction *fileQuit;

		QAction *animPlay;
		QAction *animStop;
		QAction *animForward;
		QAction *animBackward;
		QAction *animFastForward;
		QAction *animRewind;		

		//QAction *editCut;
		//QAction *editCopy;
		//QAction *editPaste;

		QAction *viewToolBar;
		QAction *viewStatusBar;
		QAction *viewCameraOptions;

		QAction *helpApp;
		QAction *helpAboutApp;

		QSpinBox* fpsBox;
		QAction *fpsUnlimited;
};

class ImprovQTHelp : public QDialog
{
	Q_OBJECT
	public:
		ImprovQTHelp(QWidget *parent=0, const char *name=0);
		~ImprovQTHelp();
	protected:
		void resizeEvent(QResizeEvent * e);
	private:
		QMultiLineEdit *text;
};

#endif 

