/***************************************************************************
                      ImprovQTCamOpt.h  -  description
                             -------------------
    begin                :
    copyright            : (C) 2002 by Leon Koch
    email                : koch-la@ee.uwa.edu.au
 ***************************************************************************/

#ifndef IMPROVQTCAMOPT_H
#define IMPROVQTCAMOPT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// QT includes
#include <qvariant.h>
#include <qdialog.h>
#include <qlabel.h>
#include <qslider.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qstring.h>

#include "improvConfig.h"

class ImprovQTCamOpt : public QDialog
{
	Q_OBJECT

	public:
		ImprovQTCamOpt(QWidget* parent = 0, const char* name = 0, imageSeqType type=OTHER, Camera *_camera=NULL, bool modal = FALSE, WFlags fl = 0 );
		~ImprovQTCamOpt();
		imageSeqType getCameraType(void);
		void setCameraType(imageSeqType type, Camera *_camera);
		int getBrightness(void);
		int getContrast(void);
		int getSaturation(void);
	public slots:
		void slotBrightnessSlider(int value);
		void slotContrastSlider(int value);
		void slotSaturationSlider(int value);
	protected:
		void closeEvent(QCloseEvent * e);
	private:
		Camera *camera;
		imageSeqType cameraType;
		QLabel* saturationValueLabel;
		QLabel* saturationTextLabel;
		QLabel* brightnessTextLabel;
		QLabel* brightnessValueLabel;
		QLabel* contrastTextLabel;
		QLabel* contrastValueLabel;
		QSlider* brightnessSlider;
		QSlider* contrastSlider;
		QSlider* saturationSlider;
};

#endif
