/**
 *  ImprovQTView.cpp - Main widget containing Seq + Src widgets.
 */

#include <assert.h>

#include "SeqWidget.h"
#include "SrcWidget.h"

#include "ImprovQTview.h"
#include "Improv.h"

#include "imageSeq.h"
#include "FW/labImage.h"
#include "improv_plugin.h"

ImprovQTView::ImprovQTView(QWidget *parent) : QWidget(parent)
{
	int numRows, numCols, numSources, numWindows;
	SrcWidget* *srcwidget;
	SeqWidget* *seqwidget;
	improvConfig::widgetConfig *config;
	Improv* improv = Improv::Instance(NULL, NULL);

	numSources = improv->config->getNumSources();	
	numWindows = improv->config->getNumWindows();
	numCols = improv->config->getNumCols();
	numRows = improv->config->getNumRows();

	// new
//	QFrame *frame;
//	frame = new QFrame(this,"frame");
//	frame->setFrameStyle(QFrame::Raised);
//	frame->setFrameShape(QFrame::Box);
//	frame->setLineWidth(0);
//	frame->setMidLineWidth(0);
//	frame->setMaximumHeight(numRows*(improv->config->getWindowHeight()+100));
//	frame->setMinimumHeight(numRows*(improv->config->getWindowHeight()+100));
//	frame->setMaximumWidth(numCols*improv->config->getWindowWidth());
//	frame->setMinimumWidth(numCols*improv->config->getWindowWidth());
//	frame->setGeometry(QRect(0,0,numCols*improv->config->getWindowWidth(),numRows*improv->config->getWindowHeight()-30));
//	effectGridLayout = new QGridLayout(frame,numRows,numCols);
//	this->setMinimumHeight(frame->height()+30);
//	this->setMinimumWidth(frame->width());
//	StatusWidget *statusBar = new StatusWidget(this);
//	improv->setStatusBar(statusBar);
	// new

	effectGridLayout = new QGridLayout(this,numRows,numCols);

	if(improv->config->numWidgetConfigs()>0) {
		// malloc source widgets
		srcwidget = (SrcWidget **)malloc(sizeof(SrcWidget *) * (numSources));
		if(srcwidget == NULL) {
			fprintf(stderr, "Error: No memory available for source widgets\n");
			return;
		}
		// malloc sequence widgets
		seqwidget = (SeqWidget **)malloc(sizeof(SeqWidget *) * (numWindows-numSources));
		if(seqwidget == NULL) {
			fprintf(stderr, "Error: No memory available for sequence widgets\n");
			return;
		}
		// setup widgets using config + layout details (provided by improvConfig)
		for(int i=0, src=0, seq=0; i<improv->config->numWidgetConfigs(); i++) {
			config = improv->config->getWidgetConfig(i);
			if(config->source) {
				srcwidget[src] = new SrcWidget(this, 0, config->id, config->sourceId);
				//srcwidget[src] = new SrcWidget(frame, 0, config->id, config->sourceId);
				assert(srcwidget);
				improv->addSrcWidget(srcwidget[src]);
				effectGridLayout->addWidget(srcwidget[src],config->row,config->col);
				src++;
			}
			else {
				seqwidget[seq] = new SeqWidget(this, 0, config->id, config->sourceId, config->position);
				//seqwidget[seq] = new SeqWidget(frame, 0, config->id, config->sourceId, config->position);
				improv->addSeqWidget(seqwidget[seq]);
				effectGridLayout->addWidget(seqwidget[seq],config->row,config->col);
				seq++;
			}
		}
	}
	else {
		// no widget details provided... fatal error
		fprintf(stderr,"Error: attempted to create ImprovQTview object without any widget configurations.\n");
		return;
	}
}

ImprovQTView::~ImprovQTView() {
	// no need to delete child widgets, Qt does it all for us
}

void ImprovQTView::redraw(void) {
	// TODO
	this->repaint();
}

void ImprovQTView::reload(void) {
	int i, numWindows, numExistingWindows;
	SeqWidget* sw;
	QValueList<SeqWidget*> seqWidgetList;
	QValueList<SeqWidget*>::iterator it;
	Improv* improv = Improv::Instance(NULL, NULL);
	numWindows = improv->config->getNumWindows();
	seqWidgetList = improv->getSeqWidgetList();
	numExistingWindows = seqWidgetList.count() + 1;

	if(numWindows < numExistingWindows) {
		// TODO
		/* we'll just delete the ones we don't need */
		//seqWidgetList.clear();
		for(i=numWindows;i<numExistingWindows;i++) {
			it = seqWidgetList.at(i);
			improv->removeSeqWidget((*it));	
			//seqWidgetList.remove(it);
			//delete it;
		}
	}
	else if(numWindows < numExistingWindows) {
  	/* we need to add some new windows */
		for(int i=numExistingWindows; i<numWindows; i++) {
			sw = new SeqWidget(this, 0, i, 0, i+1);
			seqWidgetList.append(sw);
			improv->addSeqWidget(sw);
		}
	}
	//printf("successfully updated the number of seq widgets");
	this->redraw();
}

void ImprovQTView::slotDocumentChanged() {
	//TODO update the view
}
