#include "PixWidget.h"
#include <qpainter.h>
#include <qapplication.h>

PixWidget::PixWidget(QWidget *parent=0, const char *name=0) : QWidget(parent)
{ 
	this->scale = false;
	this->autoscale = false;
}
		
PixWidget::PixWidget( QWidget *parent=0, int w, int h ) : QWidget(parent)
{
	setFixedWidth(w);
	setFixedHeight(h);
//	setMinimumWidth(w);
//	setMinimumHeight(h);
}

PixWidget::~PixWidget()
{ }
		
void PixWidget::setPicture(Picture *p_in)
{
	Picture *buffer = newImage();
	QImage qimage = QImage();

	assert(p_in);

	//saveImage("/home/stud/koch-la/tmp/in.ppm",p_in);
	//saveImage("/home/leon/tmp/32.ppm",p_in);
	//saveImage_Ascii("/home/leon/tmp/32ascii.ppm",p_in);

	qApp->lock();

	//qimage = QImage(QSize(p_in->width, p_in->height), 32, 0, QImage::LittleEndian);
	//memcpy(qimage.bits(),p_in->data,4*p_in->width*p_in->height);

	//printf("%d %d %d %d\n%d %d %d %d\n", p_in->data[0], p_in->data[1], p_in->data[2], p_in->data[3], p_in->data[4], p_in->data[5], p_in->data[6], p_in->data[7]);
//	if(p_in->format==pix_rgb32) {
//		qimage = QImage(p_in->data, p_in->width, p_in->height, 32, 0, 0, QImage::LittleEndian);
//		qimage = qimage.swapRGB();
//		//qimage.save(tr("/home/leon/tmp/32rgb.png"),"PNG");
//	}
	if(p_in->format==pix_bgr32) {
		qimage = QImage(p_in->data, p_in->width, p_in->height, 32, 0, 0, QImage::LittleEndian);
		//qimage.save(tr("/home/leon/tmp/32bgr.png"),"PNG");
	}
//	if(p_in->format==pix_rgb24) {
//		Picture* buffer;
//		buffer = copyImage(p_in);
//		RGB242BGR32(buffer);
//		qimage = QImage(buffer->data, buffer->width, buffer->height, 32, 0, 0, QImage::LittleEndian);
//	}
	if(p_in->format==pix_rgb24) {
		fprintf(stderr,"Error: Something produced a RGB 24 image! All colours images should be BGR 32.\n");
	}
	if(p_in->format==pix_grey) {
		// TOFIX
		//QRgb colourtable[256];
		//for(int i=0;i<256;i++) colourtable[i] = qRgb(i,i,i);
		//qimage = QImage(p_in->data, p_in->width, p_in->height, 8, colourtable, 256, QImage::LittleEndian);

		//qimage = QImage(p_in->data, p_in->width, p_in->height, 8, NULL, 256, QImage::LittleEndian);
		//for(int i=0;i<256;i++) qimage.setColor(i,qRgb(i,i,i));

		// hack to fix QImage white "wrapping" problem.
		buffer = copyImage(p_in);
		buffer = MONO2BGR32(buffer);
		qimage = QImage(buffer->data, buffer->width, buffer->height, 32, 0, 0, QImage::LittleEndian);

		//qimage.save(tr("/home/leon/tmp/8.png"),"PNG");
	}

	if(qimage.width() > this->width() || qimage.height() > this->height())
		this->autoscale = true;
	else
		this->autoscale = false;

	if(this->scale == true || this->autoscale == true) {
		// SLOW!
		pixmap.convertFromImage(qimage.scale(this->width(), this->height()), 0);
		// or
		/*scaleImage(p_in,this->width(),this->height());
		if(p_in->format == pix_grey) {
			pixmap.loadFromData(p_in->data,p_in->datasize,"PGMRAW",QPixmap::Auto);
		}
		if(p_in->format == pix_rgb32) {
			pixmap.loadFromData(p_in->data,p_in->bytes_per_pixel,"PPMRAW",QPixmap::Auto);
		}*/
	}
	else {
		// SLOW!
		pixmap.convertFromImage(qimage, 0);
		// or
		/*if(p_in->format == pix_grey) {
			pixmap.loadFromData(p_in->data,p_in->datasize,"PGMRAW",QPixmap::Auto);
		}
		if(p_in->format == pix_rgb32) {
			pixmap.loadFromData(p_in->data,p_in->bytes_per_pixel,"PPMRAW",QPixmap::Auto);
		}*/
	}

	qApp->unlock();

	if(this->scale == true || this->autoscale == true) {
		pixwidth = this->width();
		pixheight = this->height();
	}
	else {
		pixwidth = p_in->width;
		pixheight = p_in->height;

		if(pixwidth < this->width())
			offset_x = (this->width() - pixwidth) / 2;
		else
			offset_x = 0;

		if(pixheight < this->height())
			offset_y = (this->height() - pixheight) / 2;
		else
			offset_y = 0;
	}
	if(p_in->format==pix_grey) {
		freeImage(buffer);
	}
}
	
void PixWidget::paintEvent(QPaintEvent* event) {
	this->redraw();
}

//  Double-buffered draw routine
void PixWidget::redraw() {
	QPixmap buffer(this->width(), this->height());
	QPainter p;

	qApp->lock();
	
	if(scale == false && autoscale == false) {
		p.begin(&buffer);
		p.setPen(darkGray);
		p.fillRect(0,0,buffer.width(),buffer.height(), darkGray);
		p.end();
		bitBlt( &buffer, offset_x, offset_y, &pixmap, 0, 0, pixwidth, 
				pixheight, CopyROP, true );

		bitBlt( this, 0, 0, &buffer, 0, 0, buffer.width(), 
				buffer.height(), CopyROP, true );
	}
	else {
		bitBlt( this, 0, 0, &pixmap, 0, 0, pixwidth,
				pixheight, CopyROP, true );
	}

	p.begin(this);
	p.setPen(gray);
	p.drawRect(0,0,this->width(),this->height());
	p.end();
		
	qApp->unlock();
}

void PixWidget::clear() {
	QPainter p;

	qApp->lock();
	// Clear pixmap
	if(!pixmap.isNull()) {
		p.begin(&pixmap);
		p.setPen(darkGray);
		p.fillRect(0,0,pixwidth,pixheight, darkGray);
	}
	qApp->unlock();

	// redraw
	this->redraw();
}

void PixWidget::setScale(bool sc)
{
	this->scale = sc;
}
