#ifndef SEQWIDGET_H
#define SEQWIDGET_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// QT includes
#include <qwidget.h>
#include <qpixmap.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qimage.h>
#include <qvbox.h>
#include <qlayout.h>
#include <qwhatsthis.h>
#include <qapplication.h>

#include "FW/labImage.h"
#include "PixWidget.h"

/* This class represent an instance of a plugin
 * operation, as listed in the SeqWidget.
 */

class PluginItem : public QListBoxText
{
	public:
		PluginItem(const QString& text, int menuId, int bufferId,
				int numParams = 0, QStringList *paramNames = 0);
		~PluginItem();

		int getMenuId(void);
		int getBufferId(void);
		int getNumParams(void);
		float* getParams(void);
		QStringList* getParamNames(void);
		
		//void setParam(int param, float value);

	private:

		int menuId;
		int bufferId;
		unsigned int numParams;
		float* params;
		QStringList* paramNames;
};

//  Requires plugin menu to be already be created

class SeqWidget : public QWidget
{
	Q_OBJECT

	public:
		SeqWidget( QWidget *parent, const char *name, int id, int sourceId, int position);
		~SeqWidget();

		void copyPicture(Picture *pic);
		void tick();
		Picture* getCurrent(void);

		void setActive(bool value);
		bool isActive(void);
		int getId(void);

		int getPosition(void);
		void setPosition(int value);
		int getSourceId(void);
		void setSourceId(int value);

		void redraw(void);
		void reload(void);

		void disablePopUp(void);
		void setPopUpMenu(QPopupMenu* menu);

		int numPluginItems(void);
		PluginItem **getPluginItems(void);
	private:
		int          id;
		int          sourceId; // this widget gets its pictures from...
		int          position;
		bool         active;
		PixWidget*   pixWidget;
		QHBox*       hbox;
		QBoxLayout*  layout;
		QPushButton* popupButton;
		QPushButton* rmButton;
		QPushButton* upButton;
		QPushButton* downButton;
		QPushButton* zoomButton;
		QListBox*    chainListBox;
		Picture*     picture;

		QPixmap*     zoomPixmap;

	private slots:
		void popupPressed();
		void rmPressed();
		void upPressed();
		void downPressed();
		void itemHighlighted(QListBoxItem* item);
		void zoomToggled(bool on);
};

#endif

