#include "Improv.h"

SrcWidget::SrcWidget( QWidget *parent, const char *name, int id, int sourceId)
	: QWidget( parent, name )
{
	int i;
	dirent **seq_subpaths;
	Improv* improv = Improv::Instance(NULL, NULL);

	this->id = id;
	this->sourceId = sourceId;

	pixWidget = new PixWidget(this, improv->config->getWindowWidth(), improv->config->getWindowHeight() );
	listBox   = new QListBox(this);
//	listBox->setFixedHeight(100);

	layout = new QVBoxLayout(this);
	layout->setSpacing(0);
	layout->addWidget(pixWidget);
	layout->addWidget(listBox);

	listBox->insertItem(CAMERASTRING, 0);
	listBox->setMinimumHeight(70);
	listBox->setMinimumWidth(improv->config->getWindowWidth());

	//  Search for sequence directories and add them to the listview
	//printf("scanning dir '%s'\n", improv->config->getSequencePath());
	i = scandir(improv->config->getSequencePath(), &seq_subpaths, this->file_select, alphasort);
	while(i--) {
		listBox->insertItem(seq_subpaths[i]->d_name, i+1);
		free(seq_subpaths[i]);
	}
	free(seq_subpaths);

	imageSequence = 0;

	connect(listBox, SIGNAL(highlighted(const QString&)), 
			this, SLOT(seq_select(const QString&)));
}

SrcWidget::~SrcWidget() {
	delete imageSequence;
}

int SrcWidget::file_select(const struct dirent *entry)
{
	if ( (strcmp(entry->d_name, ".") == 0)  ||
			(strcmp(entry->d_name, "..") == 0) ||
			(strcmp(entry->d_name, "README") == 0) )
		return 0;
	else return 1;
}

void SrcWidget::seq_select(int item) {
	seq_select(listBox->text(item));
}

void SrcWidget::seq_select( const QString& sequence )
{	
	QString fullpath, msg;
	Improv* improv = Improv::Instance(NULL, NULL);

	// ensure that the row is selected...
	QListBoxItem *sequenceItem;
	sequenceItem = listBox->findItem(sequence);
	if(listBox->isSelected(sequenceItem)==false) {
		listBox->setSelected(sequenceItem,true);
	}

	if(strcmp(sequence.latin1(),CAMERASTRING)!=0) {
		fullpath = improv->config->getSequencePath();
		if(fullpath.endsWith(QString("/")) == false) fullpath.append('/');
		fullpath.append(sequence);

		if(imageSequence)
			delete imageSequence;

		QMessageBox loadDialog("Information", "Loading sequence", 
				QMessageBox::Information, 
				QMessageBox::NoButton,
				QMessageBox::NoButton,
				QMessageBox::NoButton,
				this, "load dialog", FALSE, WStyle_DialogBorder);
		loadDialog.show();
		imageSequence = new imageSeq(PIXMAP, fullpath.latin1());
		loadDialog.close();

		if(imageSequence->getSeqType() == PIXMAP) {
			if(improv->isReady()==true) {
				this->tick();
				QValueList<SeqWidget*> seqWidgetList;
				QValueList<SeqWidget*>::iterator it;
				seqWidgetList = improv->getSeqWidgetList();
				for(it = seqWidgetList.begin(); it != seqWidgetList.end(); it++) {
					if((*it)->isActive() == true) {
						(*it)->tick();
					}
				}
			}
			else {
				this->tick();
			}
			if(imageSequence->getNumFrames()>1) {
				if(imageSequence->getInfo()!=NULL)
					msg.sprintf("Loaded %d frames: %dx%d (%s)", imageSequence->getNumFrames(), imageSequence->getWidth(), imageSequence->getHeight(), imageSequence->getInfo());
				else
					msg.sprintf("Loaded %d frames: %dx%d", imageSequence->getNumFrames(), imageSequence->getWidth(), imageSequence->getHeight());
			}
			else {
				if(imageSequence->getInfo()!=NULL)
					msg.sprintf("Loaded 1 frame: %dx%d (%s)", imageSequence->getWidth(), imageSequence->getHeight(), imageSequence->getInfo());
				else
					msg.sprintf("Loaded 1 frame: %dx%d", imageSequence->getWidth(), imageSequence->getHeight());
			}
			improv->setStatusMessage(msg.latin1(),3000);
		}
		else {
			improv->setPlaying(false);
			imageSequence = 0;
			pixWidget->clear();
			improv->setStatusMessage("Not a directory or no valid images found",2000);
		}
	}
	else {
		if(imageSequence) delete imageSequence;

		imageSequence = new imageSeq(improv->config->getCameraType(), "");
		if(imageSequence->getCameraReady()) {
			improv->setStatusMessage("Successfully Opened Camera",2000);
			improv->updateCamOpt(improv->config->getCameraType(),imageSequence->getCamera());
			if(!improv->camOptIsOpen()) {
				improv->getCamOpt()->show();
				improv->setCamOptOpen(true);
			}
		}
		else {
			improv->setStatusMessage("Unsuccessful in Opening Camera",3000);
		}

		if(!imageSequence->getCameraReady()) {
			improv->setPlaying(false);
			imageSequence = 0;
			pixWidget->clear();
		}
	}
}

void SrcWidget::tick(int numFrames=1)
{
	assert(imageSequence);

	if(imageSequence) {
		pixWidget->setPicture(imageSequence->tick(numFrames));
		pixWidget->redraw();
	}
}

// Returns the "current" picture, ie the last picture returned by tick()
Picture* SrcWidget::getCurrent(void)
{
  if(imageSequence) {
		return imageSequence->getCurrent();
	}
	else {
		return (Picture *)NULL;
	}
}

bool SrcWidget::isReady(void)
{
	if(imageSequence)
		return true;
	else
		return false;
}

int SrcWidget::getId(void) {
	return this->id;
}

int SrcWidget::getSourceId(void) {
	return this->sourceId;
}

void SrcWidget::setSrcEnabled(bool value)
{
	listBox->setEnabled(value);
}

void SrcWidget::reload(bool sequencesAsWell) {
	int i;
	dirent **seq_subpaths;
	QString previousSelection = NULL;
	Improv* improv = Improv::Instance(NULL, NULL);
	previousSelection = listBox->currentText();
	if(sequencesAsWell == true) {
		listBox->clear();
		listBox->insertItem(CAMERASTRING, 0);
		i = scandir(improv->config->getSequencePath(), &seq_subpaths, this->file_select, alphasort);
		while(i--) {
			listBox->insertItem(seq_subpaths[i]->d_name, i+1);
			free(seq_subpaths[i]);
		}
		free(seq_subpaths);
	}
	if((pixWidget->height()!=improv->config->getWindowHeight())||
	   (pixWidget->width()!=improv->config->getWindowWidth())) {
		pixWidget->resize(improv->config->getWindowWidth(),improv->config->getWindowHeight());
		pixWidget->setFixedWidth(improv->config->getWindowWidth());
		pixWidget->setFixedHeight(improv->config->getWindowHeight());
	}
	if(previousSelection != NULL) {
		seq_select(previousSelection);
	}
	else {
		pixWidget->clear();
		this->imageSequence = 0;
	}	
	//redraw();
}

imageSeq *SrcWidget::getImageSeq(void) {
	return imageSequence;
}

