#ifndef V4L2Camera_H
#define V4L2Camera_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/mman.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <fcntl.h>

#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>

#include <linux/fs.h>
#include <linux/kernel.h>
#include <linux/videodev2.h>

#include "Camera.h"
#include "FW/labImage.h"

#define DEFAULT_VIDEO_DEVICE  "/dev/video0"
#define VIDEO_STANDARD        "PAL"
#define DEFAULT_IMAGE_WIDTH   160
#define DEFAULT_IMAGE_HEIGHT  120
#define STREAMBUFS            4

class V4L2Camera : public Camera {
	struct {
		v4l2_buffer vidbuf;
		char *data;
	} vimage[STREAMBUFS];      // buffers for images
	int vid_fd;                // video device
	struct v4l2_format fmt;    // video format request
  
	int pic_size_x;
	int pic_size_y;
	int pic_size;

	int x_offset;
	int y_offset;

	int autobrightness;
  
	public:
		virtual bool open(IPL_CONFIG *ipl_config);
		virtual void close(void);
		virtual void read(Picture *p_frame);
		virtual void setBrightness(int value);
		virtual void setContrast(int value);
		virtual void setSaturation(int value);
		virtual void setAutoBrightness(bool on);
		virtual int getBrightness(void);
		virtual int getContrast(void);
		virtual int getSaturation(void);
		virtual bool getAutoBrightness(void);

		virtual bool iscolor(void);
		virtual void get_info(CamInfo *info);
		virtual int map_to_v4l2_format(pixel_format format);
};

#endif /* __v4l2_camera_h */
