#ifndef V4LCamera_h
#define V4LCamera_h

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#if defined(HAVE_V4L)

#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/mman.h>
#include <errno.h>

/* Video for Linux */
#include <linux/fs.h>
#include <linux/videodev.h>

#include "Camera.h"
#include "FW/labImage.h"

// extern int frame_count;

class V4LCamera : public Camera {
	int vid_fd;
	struct video_capability vid_cap;
	struct video_mbuf       vid_mbuf;
	struct video_channel    vid_chnl;
	struct video_mmap       vid_mmap;
	struct video_picture    vid_pic;
  
	int width, height;
	int palette;
	int input;
	int norm;
	BYTE* video_map;

	bool greyscale;

	public:
		virtual bool open(const char* device);
		virtual void close(void);
		virtual void read(Picture *p_frame);
		virtual bool iscolor(void);
		virtual void get_info(CamInfo *info);
		virtual void mmap_read(Picture *p_frame, int expected_size);
		virtual BYTE* set_up_mmap (int dev, int width, int height, int fmt);
		virtual void set_colour(int value);
		virtual void setBrightness(int value);
		virtual void setContrast(int value);
		virtual void setSaturation(int value);
		virtual void setAutoBrightness(bool on);
		virtual int getBrightness(void);
		virtual int getContrast(void);
		virtual int getSaturation(void);
		virtual bool getAutoBrightness(void);
		struct video_window vid_win;
};

//#endif /* HAVE_V4L */

#endif // V4LCamera_h
