#ifndef IPL_PLUGIN_H
#define IPL_PLUGIN_H

#if defined (__cplusplus)
extern "C" {
#endif

#ifndef _BYTE
#define _BYTE
typedef unsigned char BYTE;
#endif

#define MAX_IMAGE_SIZE (320*240)

//#define DEBUG    /* turn arguement checking on and off */
//#define SCREEN   /* debug information printed screen, otherwise file debug.out */
#define DISPLAY  /* turns on and off display */
#define COLOUR   /* track using colour information */
#define RELAX    /* use interative relaxation */
//#define HIST     /* use histogram equalization */
#define MOTION   /* detect motion */

#ifndef TRUE
#define TRUE  0
#endif

#ifndef FALSE
#define FALSE 1
#endif

/* Gaussian */
#define MAXSIZE 14
#define MAXVAR  4

/* TRACKING */
#define XX       4
#define xx       13
#define YY       3
#define yy       12
#define SEARCH   17

/* MORAVEC */
#define MAX_POINTS     2000
#define supp_window    5
#define SW             floor(supp_window/2)
#define var_thres      0
#define supp_thres     pow(supp_window,2)-1
#define mor_window     5  /* must be odd */
#define M              floor(mor_window/2)
#define R              1  /* image reduction factor */

/* HISTOGRAM EQUALIZATION */
#define HL 256         /* the number of grey levels */

/*
 * Typedefs
 */

typedef struct _window {
	short x1, y1;  /* top left corner */
	short x2, y2;  /* bottom right corner */
} window;

typedef struct _active {
	window main;
	window *windows;
} active;

typedef struct _feature {
	short   x,y;             /* pixel position */
	char    r,g,b;           /* intensities */
	double  grad_x, grad_y;  /* gradients */
	double  var;             /* maximum variance */
	int     active;          /* true if feature is being tracked */
	int     moving;          /* true if feature is moving */
} feature;

typedef struct {
	short x;
	short y;
} IPLPoint;

/*
 * Globals
 */
/* debugging */
FILE *db;
/* GAUSSIAN */
static double **g_mask = NULL;
/* DETECTED FEATURES */
feature f[XX*YY];
feature g[XX*YY];
/* initial */
static int first = TRUE;
static int motion = FALSE;
/* CORRESPONDANCE */
double  similar[XX*YY][MAX_POINTS]; /* array of similarity */
feature t[XX*YY][MAX_POINTS];       /* the feature vector of each candiate */
double  p[XX*YY][MAX_POINTS];       /* the probability of each candiate being a match */
/* MOTION */
static int moving = FALSE;
/* frame count used when filming */
static int frame_no = 0;

/*
 * Internal Routines
 */

/* gaussian.c */
void     Generate_Gauss(int size, int g, int var);
void     Gaussian_Smooth(BYTE * imageIn, BYTE * imageOut, int x1, int y1, int x2, int y2, int width, int height, int size, int g, int var);
double   smooth_pixel(BYTE * image, int m, int i, int j, int width, int height);
void     gclamp(int *x1, int *y1, int *x2, int *y2, int width, int height, int g);
void     smooth_areas( BYTE *imageIn, BYTE* imageOut, int width, int height, int g);
double   smooth_pixel_col(BYTE * image, int g, int i, int j, int c, int width, int height);

/* histeq.c */
void     Hist_Eq(BYTE * ImageIn, BYTE * ImageOut, int width, int height);
void     save_hist(unsigned int *n, BYTE *imageOut, int x1, int y1, int x2, int y2, int width, int height);
void     Hist_Eq_Col(BYTE *imageIn, BYTE *imageOut, int width, int height);

/* track.c */
double   grad_x(BYTE * imageIn, int x, int y, int width, int height);
double   grad_y(BYTE * imageIn, int x, int y, int width, int height);
void     generate_windows(active* grid, int width, int height);
void     find_active_area(active *grid, int width, int height);
void     correspond(BYTE* col_im, BYTE *image, feature *s, IPLPoint *point, int no_points, int width, int height);
double   norm_feature(feature *a, double *w);
double   norm_diff_feature(feature *a, feature *b, double *w);
void     correspond2(BYTE* col_im, BYTE* image, IPLPoint** point, int* no_points, int width, int height);
void     similarity(BYTE* col_im, BYTE* image, IPLPoint** point, int *no_points, int width, int height);
void     calc_probs(int* no_points);
void     choose(IPLPoint **point, int *no_points);
void     relax(IPLPoint **point, int* no_points);
double   sim_disparity(int k, int dx, int dy, IPLPoint* disparity, IPLPoint** point, int* no_points);
double   disparity_mismatch(IPLPoint* a, IPLPoint* b);
int      still_tracking();
void     activate_lost(IPLPoint **point, int* no_points);
void     detect_motion();
int      can_track();

/* moravec.c */
void     Detect_Prominent_Features(BYTE* col_im, BYTE *image, active *grid, int width, int height, int g);
void     initial_moravec( BYTE * image, int x1, int y1, int x2, int y2, feature *f, int width, int height);
void     interest(BYTE * image, int x1, int y1, int x2, int y2, double* var, int width, int height);
void     non_max_suppress(double* var, int x1, int y1, int x2, int y2, IPLPoint *point, int *no_points, int width, int height);
int      find_features(BYTE* col_im, BYTE *imageOut, int width, int height);

/* misc.c */
void     draw_features(BYTE * image, int col, int width, int height);
void     draw_grid(window* grid, BYTE * image, int col, int width, int height);
void     square_im(BYTE * imageIn, BYTE * ImageOut, int width, int height);
void     WritePGM(char *filename, unsigned char *pixel, int width, int height, int grey_levels);
void     draw_points(BYTE *image, IPLPoint *points, int no_points, int width, int height);
void     draw_active(BYTE *image, active* grid, int width, int height);
void     draw_areas(BYTE *image, int col, int width, int height);
void     copy_features();
void     motion_test_im1(BYTE* imageIn, int width, int height);
void     motion_test_im2(BYTE* imageIn, int width, int height);

/* angles.c */
void direct(IPLPoint* target);
void draw_crosshair(BYTE* image, IPLPoint *target, int col, int width, int height);

/*
void IPL_moravec(Picture *p_imageIn, Picture *p_imageOut);
void IPL_Track(Picture *p_imageIn, Picture *p_imageOut);
void IPL_HistEq(Picture *p_imageIn, Picture *p_imageOut);
void IPL_Gauss(Picture *p_imageIn, Picture *imageOut);
*/

void IPL_Gauss(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
void IPL_HistEq(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
void IPL_moravec(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
void IPL_Track(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);

void IPLi_lum(Picture *p_imageIn, BYTE *p_imageOut);

#if defined (__cplusplus)
}
#endif

#endif
