/***************************************************************************
                        improvConfig.h  -  description
                             -------------------
    begin                :
    copyright            : (C) 2002 by Leon Koch
    email                : koch-la@ee.uwa.edu.au

	Stores all config values for easy access by all objects

 ***************************************************************************/

#ifndef IMPROVCONFIG_H
#define IMPROVCONFIG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <assert.h>
#include <string.h>
#include <stdlib.h>
#include <dirent.h>
#include <getopt.h>

#include "imageSeq.h"

#define MAXLINE 512

#define CONFIG_FILENAME ".improvqt"
#define DEFAULT_WINDOW_WIDTH     169
#define DEFAULT_WINDOW_HEIGHT    134
#define DEFAULT_NUMBER_WINDOWS   6
#define MINIMUM_BUTTON_BAR_WIDTH 150

class improvConfig {
	public:
		typedef struct {
			int id;
			bool source;
			int sourceId;
			int position;
			int row;
			int col;
		} widgetConfig;

		typedef struct {
			int row;
			int col;
			int posn;
			int uniqueId;
			char *name;
		} pluginInstance;

		improvConfig();
		~improvConfig();

		/* Load config values
		 */
		void load(int argc, char **argv);
	
		/* Load default config values
		 */
		void loadDefaults(void);

		/* Loads config from the default file (~/CONFIG_FILENAME)
		 * @return true if successfully saved, false if it failed.
		 */
		bool load(void);

		/* Loads config from a file
		 * @return true if successfully saved, false if it failed.
		 */
		bool load(char *filename);
		
		/* Saves config to the default file (~/CONFIG_FILENAME)
		 * @return true if successfully saved, false if it failed.
		 */
		bool save(void);

		/* Saves config to a file
		 * @return true if successfully saved, false if it failed.
		 */
		bool saveAs(char *filename);

		void clear(void);
		void clearLayout(void);
			
		/* Set the sequence path
		 * @param sequencePath desired sequence path
		 */
		void setSequencePath(char *sequencePath);

		/* Get the sequence path
		 * @return sequence path
		 */
		char *getSequencePath(void);
	
		/* Set the plugin path
		 * @param pluginPath desired plugin path
		 */
		void setPluginPath(char *pluginPath);

		/* Get the plugin path
		 * @return plugin path
		 */
		char *getPluginPath(void);
	
		/* Set the window width
		 * @param windowWidth desired window width
		 */
		void setWindowWidth(int width);

		/* Get the window width
		 * @return window width
		 */
		int getWindowWidth(void);

		/* Set the window height
		 * @param windowHeight desired window height
		 */
		void setWindowHeight(int height);

		/* Get the window height
		 * @return window height
		 */
		int getWindowHeight(void);

		/* Set the number of image windows
		 * @param numWindows number of windows
		 */
		void setNumSources(int number);

		/* Get the number of windows
		 * @return number of windows
		 */
		int getNumSources(void);

		/* Set the number of image windows
		 * @param numWindows number of windows
		 */
		void setNumWindows(int number);
                          
		/* Get the number of windows
		 * @return number of windows
		 */
		int getNumWindows(void);

		/* Set the sequence to start with
		 */
		void setUseSequence(char *name);

		/* Get the sequence that was started with
		 */
		char *getUseSequence(void);

		/* Set the type of camera
		 */
		void setCameraType(imageSeqType camera);
		
		/* Get the type of camera
		 * @return enum of imageSeqType
		 */
		imageSeqType getCameraType(void);

		/* Get whether the config has been modified or not.
		 */
		bool isModified(void);
		void setModified(bool on);

		widgetConfig *getWidgetConfig(int posn);
		widgetConfig *getWidgetConfig(bool source, int id);
		int numWidgetConfigs(void);

		pluginInstance *getPluginInstance(int posn);
		int numPluginInstances(void);

		int getNumRows(void);
		int getNumCols(void);

		bool verifyWidgetConfig(void);
		bool verifyWidgetConfig(widgetConfig **_widgets, int _numWidgets,	int _numWindows, int _numSources);

		char *getDefaultFilename(void);

	private:
		char *sequencePath;
		char *pluginPath;
		char *useSequence;
		
		int windowWidth;
		int windowHeight;

		int numSources;
		int numWindows;
		int numRows;
		int numCols;
		
		imageSeqType cameraType;

		bool modified;

		char *defaultFilename;

		int numPlugins;
		pluginInstance **plugins;

		int numWidgets;
		widgetConfig **widgets;
};
#endif
