/** Implements the plugin interface using improv image processing
 *  plugins, as defined in improv_plugin.h
 */

#ifndef IPPLUGIN_H
#define IPPLUGIN_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "improv_plugin.h"
#include "plugin.h"

class ipPlugin : public Plugin
{
	public:
		ipPlugin(const char* plugin_file);
		~ipPlugin();

		void processId(int id, Picture **p_in, Picture *p_out, float *params, void *result);
		void printInfo(void);
		bool isReady(void);
		void listOps(void);
		unsigned int getNumOps(void);
		bool getOpInfo(int id, char** category, char** name, unsigned int* num_inputs, unsigned int* num_params, char*** param_names, pluginResultType *resultType, size_t *resultSize);
		int getUniqueId(void);
		const char *getFileName(void);

	private:
		const char*    plugin_file;
		void*          phandle;
		IP_Handle*     iphandle;
		IP_Descriptor* desc;

		int init_plugin(void);
		IP_Descriptor* get_plugin_desc(void);
};

#endif
