#ifndef CAMERA_H
#define CAMERA_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "FW/labImage.h"

#define DEFAULT_BLACK 0
#define DEFAULT_WHITE 255
#define DEFAULT_WIDTH 82
#define DEFAULT_HEIGHT 62
#define DEFAULT_BPP 24

typedef unsigned char BYTE;

class Camera {

 public:
	// Information on the camera's attributes
	typedef struct {
		int width;   // width of image, including border
		int height;  // height of image, including border
		int bpp;     // colour depth (bits per pixel)
	} CamInfo;

	// Return true on success and false if camera is unsupported on this machine
	virtual bool open(const char* device) = 0;

	// Releases camera.  Must be called if open succeded.
	virtual void close(void) = 0;

	// Fetch next frame from camera
	virtual void read(Picture *p_frame) = 0;

	// Does this camera return color or grey scale images
	virtual bool iscolor(void) { return false; };

	// Get information on image width, height and bits per pixel
	virtual void get_info(CamInfo *info) = 0;

	virtual void setBrightness(int value) = 0;
	virtual void setContrast(int value) = 0;
	virtual void setSaturation(int value) = 0;
	virtual void setAutoBrightness(bool on) = 0;

	virtual int getBrightness(void) = 0;
	virtual int getContrast(void) = 0;
	virtual int getSaturation(void) = 0;
	virtual bool getAutoBrightness(void) = 0;
};

#endif // Camera_h
