/***************************************************************************
                       ImprovQTOpt.cpp  -  description
                             -------------------
    begin                :
    copyright            : (C) 2002 by Leon Koch
    email                : koch-la@ee.uwa.edu.au
 ***************************************************************************
  To add new camera drivers to the options dialog, edit the code at ADD1-4
 */


#include "ImprovQTOpt.h"
#include "Improv.h"

#define V4L_STRING "Video4Linux"
#define V4L2_STRING "Video4Linux 2"
#define QCAM_STRING "QuickCam"
// ADD1: new camera types here...

ImprovQTOpt::ImprovQTOpt(QWidget *parent=0, const char *name=0, improvConfig *config=0)
: QDialog( parent, name, true, WType_Modal )
{
	QLabel* widthTextLabel;
	QLabel* heightTextLabel;
	QLabel* windowsTextLabel;
	QLabel* sourcesTextLabel;
	QLabel* pluginTextLabel;
	QLabel* sequenceTextLabel;
	QLabel* cameraTextLabel;
	int wwWidth, wwHeight;
	int numCols = config->getNumCols();
	int numRows = config->getNumRows();
	int extraWidth = 0;
	int extraHeight= 0;

	frame = new QFrame(this,"frame");
	frame->setFrameStyle(QFrame::Raised);
	frame->setFrameShape(QFrame::Box);
	frame->setLineWidth(1);
	frame->setMidLineWidth(0);
	frame->setMaximumHeight(170);
	frame->setMaximumWidth(230);
	frame->setGeometry(QRect(10,10,230,170));
	QGridLayout *gridLayout;
	gridLayout = new QGridLayout(frame,numRows,numCols,2,1,"gridLayout");

	if(numCols>3) {
		extraWidth = (int)floor((double)(numCols - 3)*75);
		frame->setMaximumWidth(frame->width()+extraWidth);
		frame->setGeometry(QRect(frame->geometry().left(),
		                         frame->geometry().top(),
		                         frame->width()+extraWidth,
		                         frame->height()));
	}
	if(numRows>2) {
		extraHeight = (int)floor((double)(numRows - 2)*82.5);
		frame->setMaximumHeight(frame->height()+extraHeight);
		frame->setGeometry(QRect(frame->geometry().left(),
		                         frame->geometry().top(),
		                         frame->width(),
		                         frame->height()+extraHeight));
	}
	
	wwWidth = (int)((frame->width()-(2*gridLayout->margin()+gridLayout->spacing()*(numCols-1)))/numCols);
	wwHeight = (int)((frame->height()-(2*gridLayout->margin()+gridLayout->spacing()*(numRows-1)))/numRows);

	//fprintf(stderr,"numRows %d, numCols %d, wwWdith %d, wwHeight %d\n", numRows, numCols, wwWidth, wwHeight);

	// this resizes the frame, if the child widgets don't take up the whole width/height
	if((2*gridLayout->margin()+(numCols-1)*gridLayout->spacing()+numCols*wwWidth)!=frame->width()) {
		frame->setMaximumWidth(2*gridLayout->margin()+(numCols-1)*gridLayout->spacing()+numCols*wwWidth);
	}
	if((2*gridLayout->margin()+(numRows-1)*gridLayout->spacing()+numRows*wwHeight)!=frame->height()) {
		frame->setMaximumHeight(2*gridLayout->margin()+(numRows-1)*gridLayout->spacing()+numRows*wwHeight);
	}

	optWidgets = (OptWidget **)malloc(sizeof(OptWidget *) * (config->getNumWindows()));
	if(optWidgets == NULL) {
		fprintf(stderr,"Error: Options - No memory available for opt widgets\n");
		return;
	}

	// add all the windowWidgets to the grid in the frame.
	for(int i=0;i<config->numWidgetConfigs();i++) {
		optWidgets[i] = new OptWidget(frame,"",config->getWidgetConfig(i),wwWidth,wwHeight);
		optWidgets[i]->setNumWindows(config->getNumWindows()-config->getNumSources());
		optWidgets[i]->setNumSources(config->getNumSources());
		gridLayout->addWidget(optWidgets[i],config->getWidgetConfig(i)->row,config->getWidgetConfig(i)->col);
	}

	setName("Options");
	resize(362+extraWidth, 319+extraHeight);
	setMinimumHeight(height());
	setMinimumWidth(width());
	setMaximumHeight(height());
	setMaximumWidth(width());
	setCaption(trUtf8("Options"));

	/* text labels */
	cameraTextLabel = new QLabel( this, "cameraTextLabel" );
	cameraTextLabel->setGeometry( QRect( 10, 250+extraHeight, 70, 20 ) );
	cameraTextLabel->setText( trUtf8( "Camera" ) );
	sequenceTextLabel = new QLabel( this, "sequenceTextLabel" );
	sequenceTextLabel->setGeometry( QRect( 10, 220+extraHeight, 67, 20 ) );
	sequenceTextLabel->setText( trUtf8( "Sequences" ) );
	pluginTextLabel = new QLabel( this, "pluginTextLabel" );
	pluginTextLabel->setGeometry( QRect( 10, 190+extraHeight, 65, 20 ) );
	pluginTextLabel->setText( trUtf8( "Plugins" ) );
	windowsTextLabel = new QLabel( this, "windowsTextLabel" );
	windowsTextLabel->setGeometry( QRect( 300+extraWidth, 10, 54, 20 ) );
	windowsTextLabel->setText( trUtf8( "Windows" ) );
	sourcesTextLabel = new QLabel( this, "sourcesTextLabel" );
	sourcesTextLabel->setGeometry( QRect( 300+extraWidth, 40, 54, 20 ) );
	sourcesTextLabel->setText( trUtf8( "Sources" ) );
	heightTextLabel = new QLabel( this, "heightTextLabel" );
	heightTextLabel->setGeometry( QRect( 300+extraWidth, 70, 54, 20 ) );
	heightTextLabel->setText( trUtf8( "Height" ) );
	widthTextLabel = new QLabel( this, "widthTextLabel" );
	widthTextLabel->setGeometry( QRect( 300+extraWidth, 100, 54, 20 ) );
	widthTextLabel->setText( trUtf8( "Width" ) );

	/* line edits */
	pluginLineEdit = new QLineEdit(this, "pluginLineEdit");
	pluginLineEdit->setText(tr(config->getPluginPath()));
	pluginLineEdit->setGeometry(QRect(81, 190+extraHeight, 210+extraWidth, 20));
	pluginLineEdit->setCursorPosition(0);
	QWhatsThis::add(pluginLineEdit,tr("Plugins directory\n\nThe directory that contains ImprovQT plugins"));
	sequenceLineEdit = new QLineEdit(this, "sequenceLineEdit");
	sequenceLineEdit->setText(tr(config->getSequencePath()));
	sequenceLineEdit->setGeometry(QRect(81, 220+extraHeight, 210+extraWidth, 20));
	sequenceLineEdit->setCursorPosition(0);
	QWhatsThis::add(sequenceLineEdit,tr("Sequences directory\n\nThe directory that contains image sequences"));

	/* browse buttons */
	pluginButton = new QPushButton(this, "pluginButton");
	pluginButton->setGeometry(QRect( 300+extraWidth, 190+extraHeight, 50, 20));
	pluginButton->setText(trUtf8("Browse"));
	pluginButton->setAutoDefault(false);
	QWhatsThis::add(pluginButton,tr("Browse for Plugins directory"));
	connect(pluginButton, SIGNAL(clicked()), this, SLOT(slotPluginButton()));
	sequenceButton = new QPushButton(this, "sequenceButton");
	sequenceButton->setGeometry(QRect(300+extraWidth, 220+extraHeight, 50, 20));
	sequenceButton->setText(trUtf8("Browse"));
	sequenceButton->setAutoDefault(false);
	QWhatsThis::add(sequenceButton,tr("Browse for Sequences directory"));
	connect(sequenceButton, SIGNAL(clicked()), this, SLOT(slotSequenceButton()));

	/* spin boxes */
	numWindows = new QSpinBox(2, config->getNumWindows(), 1, this, "numWindows");
	numWindows->setValue(config->getNumWindows());
	numWindows->setGeometry(QRect(250+extraWidth, 10, 50, 20));
	QWhatsThis::add(numWindows,tr("Number of total windows\n\nNot implemented in this version\nPlease use the command line arguments"));
	numWindows->setEnabled(false);
	numSources = new QSpinBox(1, config->getNumSources(), 1, this, "numSources");
	numSources->setValue(config->getNumSources());
	numSources->setGeometry(QRect(250+extraWidth, 40, 50, 20));
	QWhatsThis::add(numSources,tr("Number of source image windows\n\nNot implemented in this version\nPlease use the command line arguments"));
	numSources->setEnabled(false);
	connect(numWindows, SIGNAL(valueChanged(int)), this, SLOT(slotNumWindows(int)));
	windowHeight = new QSpinBox(1,1000,1,this, "windowHeight");
	windowHeight->setValue(config->getWindowHeight());
	windowHeight->setGeometry(QRect(250+extraWidth, 70, 50, 20));
	QWhatsThis::add(windowHeight,tr("Height of each image window (pixels)"));
	connect(windowHeight, SIGNAL(valueChanged(int)), this, SLOT(slotWindowHeight(int)));
	windowWidth = new QSpinBox(1,1000,1,this, "windowWidth");
	windowWidth->setValue(config->getWindowWidth());
	windowWidth->setGeometry(QRect(250+extraWidth, 100, 50, 20));
	QWhatsThis::add(windowWidth,tr("Width of each image window (pixels)"));
	connect(windowWidth, SIGNAL(valueChanged(int)), this, SLOT(slotWindowWidth(int)));

	/* combo boxes */
	cameraComboBox = new QComboBox(FALSE, this, "cameraComboBox");
	cameraComboBox->setGeometry( QRect( 80, 250+extraHeight, 210+extraWidth, 21 ) );
	cameraComboBox->insertItem(tr(V4L_STRING),0);
	cameraComboBox->insertItem(tr(V4L2_STRING),1);
	cameraComboBox->insertItem(tr(QCAM_STRING),2);
	// ADD2: new camera types here...
	QWhatsThis::add(cameraComboBox,tr("Type of Camera to use"));
	if(config->getCameraType()==V4L) cameraComboBox->setCurrentItem(0);
	else if(config->getCameraType()==V4L2) cameraComboBox->setCurrentItem(1);
	else if(config->getCameraType()==QCAM) cameraComboBox->setCurrentItem(2);
	// ADD3: new camera types here...

	/* buttons */
	cancelButton = new QPushButton(this, "cancelButton");
	cancelButton->setGeometry(QRect(300+extraWidth, 290+extraHeight, 50, 20));
	cancelButton->setText(trUtf8("Cancel"));
	cancelButton->setAutoDefault(false);
	QWhatsThis::add(cancelButton,tr("Cancel and close options"));
	connect(cancelButton, SIGNAL(clicked()), this, SLOT(slotCancelButton()));
	okButton = new QPushButton(this, "okButton");
	okButton->setGeometry(QRect(250+extraWidth, 290+extraHeight, 40, 20));
	okButton->setText(trUtf8("OK"));
	okButton->setAutoDefault(true);
	QWhatsThis::add(okButton,tr("Save and close options"));
	connect(okButton, SIGNAL(clicked()), this, SLOT(slotOkButton()));

	/* tab order */
	this->setTabOrder(numWindows, numSources);
	this->setTabOrder(numSources, windowHeight);
	this->setTabOrder(windowHeight, windowWidth);
	this->setTabOrder(windowWidth, pluginLineEdit);
	this->setTabOrder(pluginLineEdit, pluginButton);
	this->setTabOrder(pluginButton, sequenceLineEdit);
	this->setTabOrder(sequenceLineEdit, sequenceButton);
	this->setTabOrder(sequenceButton, cameraComboBox);
	this->setTabOrder(cameraComboBox, okButton);
	this->setTabOrder(okButton, cancelButton);
	this->setTabOrder(cancelButton, numWindows);

	/* set focus */
	okButton->setFocus();
}

ImprovQTOpt::~ImprovQTOpt() {
	// no need to delete child widgets, Qt does it all for us
}

void ImprovQTOpt::slotOkButton() {
	QValueList<SrcWidget*> srcWidgetList;
	QValueList<SrcWidget*>::iterator srcIt;
	QValueList<SeqWidget*> seqWidgetList;
	QValueList<SeqWidget*>::iterator seqIt;
	Improv* improv = Improv::Instance(NULL, NULL);
	improvConfig::widgetConfig **newConfigs;

	newConfigs = (improvConfig::widgetConfig **)malloc(sizeof(improvConfig::widgetConfig *)*numWindows->value());
	for(int i=0;i<numWindows->value();i++) {
		newConfigs[i] = optWidgets[i]->getConfig();
	}
	if(!improv->config->verifyWidgetConfig(newConfigs,numWindows->value(),numWindows->value(),numSources->value())) {
		QMessageBox invalidDialog("Invalid", "The window configuration you have\nselected is invalid. Please try again.",
					QMessageBox::Critical,
					QMessageBox::Ok | QMessageBox::Default,
					QMessageBox::NoButton,
					QMessageBox::NoButton,
					this, "invalidDialog", true, WStyle_Dialog);
		invalidDialog.exec();
		return;
	}
	QMessageBox busyDialog("Updating Options", "Please wait",
				QMessageBox::Information,
				QMessageBox::NoButton,
				QMessageBox::NoButton,
				QMessageBox::NoButton,
				this, "busyDialog", true, WStyle_DialogBorder);
	busyDialog.show();

	if(strcmp(improv->config->getPluginPath(),pluginLineEdit->text().latin1())!=0) {
		improv->config->setPluginPath((char *)pluginLineEdit->text().latin1());
		improv->constructPluginMenu();
		if(improv->getPluginMenu() == NULL) {
			// options created null plugin menu -> disable add buttons
			seqWidgetList = improv->getSeqWidgetList();
			for(seqIt = seqWidgetList.begin(); seqIt != seqWidgetList.end(); seqIt++) {
				(*seqIt)->disablePopUp();
			}
		}
		else {
			// options created new plugin menu -> update add buttons
			seqWidgetList = improv->getSeqWidgetList();
			for(seqIt = seqWidgetList.begin(); seqIt != seqWidgetList.end(); seqIt++) {
				(*seqIt)->setPopUpMenu(improv->getPluginMenu());
			}
		}
	}
	if((QString::compare(cameraComboBox->currentText(),tr(V4L_STRING))==0)&&
		 (improv->config->getCameraType()!=V4L)) {
		improv->config->setCameraType(V4L);
	}
	if((QString::compare(cameraComboBox->currentText(),tr(V4L2_STRING))==0)&&
		 (improv->config->getCameraType()!=V4L2)) {
		improv->config->setCameraType(V4L2);
	}
	if((QString::compare(cameraComboBox->currentText(),tr(QCAM_STRING))==0)&&
		 (improv->config->getCameraType()!=QCAM)) {
		improv->config->setCameraType(QCAM);
	}
	// ADD4: new camera types here...

	if((improv->config->getWindowHeight()!=windowHeight->value())||
		 (improv->config->getWindowWidth()!=windowWidth->value())) {
		improv->config->setWindowHeight(windowHeight->value());
		improv->config->setWindowWidth(windowWidth->value());
		srcWidgetList = improv->getSrcWidgetList();
		if(strcmp(improv->config->getSequencePath(),sequenceLineEdit->text().latin1())!=0) {
			improv->config->setSequencePath((char *)sequenceLineEdit->text().latin1());
			for(srcIt = srcWidgetList.begin(); srcIt != srcWidgetList.end(); srcIt++) {
				(*srcIt)->reload(true);
			}	
		}
		else {
			for(srcIt = srcWidgetList.begin(); srcIt != srcWidgetList.end(); srcIt++) {
				(*srcIt)->reload(false);
			}	
		}
		seqWidgetList = improv->getSeqWidgetList();
		for(seqIt = seqWidgetList.begin(); seqIt != seqWidgetList.end(); seqIt++) {
			(*seqIt)->reload();
		}
	}
	else if(strcmp(improv->config->getSequencePath(),sequenceLineEdit->text().latin1())!=0) {
		improv->config->setSequencePath((char *)sequenceLineEdit->text().latin1());
		srcWidgetList = improv->getSrcWidgetList();
		for(srcIt = srcWidgetList.begin(); srcIt != srcWidgetList.end(); srcIt++) {
			(*srcIt)->reload(true);
		}	
	}
	for(int i=0;i<numWindows->value();i++) {
		// update src + seq from optwidgets
		if(optWidgets[i]->isModified()) {
			// to trigger isModified
			improv->config->setModified(true);
			improv->config->getWidgetConfig(i)->source = optWidgets[i]->getSource();
			improv->config->getWidgetConfig(i)->sourceId = optWidgets[i]->getSourceId();
			improv->config->getWidgetConfig(i)->position = optWidgets[i]->getPosition();
			if(improv->config->getWidgetConfig(i)->source) {
				// src widgets
				if(!optWidgets[i]->getSource()) {
					// TODO: change it to a seq
				}
			}
			else {
				// seq widgets
				if(optWidgets[i]->getSource()) {
					// TODO: change it to a src
				}
				else {
					improv->getSeqWidget(improv->config->getWidgetConfig(i)->id)->setSourceId(optWidgets[i]->getSourceId());
					improv->getSeqWidget(improv->config->getWidgetConfig(i)->id)->setPosition(optWidgets[i]->getPosition());
				}
			}
		}
	}
	if(improv->config->getNumWindows()!=numWindows->value()) {
		improv->config->setNumWindows(numWindows->value());
		// TODO
		//delete parent->view;
		//view = new ImprovQTView(app, app->doc);
		//parent->setCentralWidget(view);
		// OR
		//view->reload();
	}
	busyDialog.close();
	close();
	if(improv->config->isModified()) {
		improv->setStatusMessage("Options updated",2000);
	}
	else {
		improv->setStatusMessage(IDLEMSG);
	}
}

void ImprovQTOpt::slotCancelButton() {
	Improv* improv = Improv::Instance(NULL, NULL);
	improv->setStatusMessage("Options aborted",2000);
	close();
}

void ImprovQTOpt::slotPluginButton() {
	Improv* improv = Improv::Instance(NULL, NULL);
	improv->setStatusMessage("Choosing Plugin Directory...");

	QString dirName = QFileDialog::getExistingDirectory(tr(pluginLineEdit->text()),this,"pluginBrowser","Choose Plugin Directory", true);
	if (!dirName.isEmpty()) {
		pluginLineEdit->setText(dirName);
		improv->setStatusMessage("Options");
	}
	else {
		improv->setStatusMessage("Selection aborted",2000);
	}
}

void ImprovQTOpt::slotSequenceButton() {
	Improv* improv = Improv::Instance(NULL, NULL);
	improv->setStatusMessage("Choosing Sequence Directory...");

	QString dirName = QFileDialog::getExistingDirectory(tr(sequenceLineEdit->text()),this,"sequenceBrowser","Choose Sequence Directory", true);
	if (!dirName.isEmpty()) {
		sequenceLineEdit->setText(dirName);
		improv->setStatusMessage("Options");
	}
	else {
		improv->setStatusMessage("Selection aborted",2000);
	}
}

void ImprovQTOpt::slotWindowHeight(int value) {
	//localConfig->setWindowHeight(value);
}

void ImprovQTOpt::slotWindowWidth(int value) {
	//localConfig->setWindowWidth(value);
}

void ImprovQTOpt::slotNumWindows(int value) {
	//localConfig->setNumSeqWindows(value);
}

/*void ImprovQTOpt::closeEvent(QCloseEvent * e) {
	Improv* improv = Improv::Instance(NULL, NULL);
	improv->redraw();
	this->close();
	//slotCancelButton();
}*/

OptWidget::OptWidget(QWidget *parent=0, const char *name=0, improvConfig::widgetConfig *config=0, int width=0, int height=0) : QWidget(parent)
{
	QLabel* positionTextLabel;
	QLabel* sourceTextLabel;
	QFrame *frame;
	this->id = config->id;
	this->col = config->col;
	this->row = config->row;
	this->setMaximumWidth(width);
	this->setMaximumHeight(height);
	frame = new QFrame(this,"wwFrame");
	frame->setFrameStyle(QFrame::Raised);
	frame->setFrameShape(QFrame::Box);
	frame->setLineWidth(1);
	frame->setMidLineWidth(0);
	frame->setGeometry(QRect(0,0,width,height));
	
	sourceCheckBox = new QCheckBox(tr("Source"),this,"sourceCheckBox");
	sourceCheckBox->setGeometry(QRect((int)((width-65)/2), 2, 65, 20));
	sourceCheckBox->setChecked(config->source);
	sourceCheckBox->setEnabled(false);
	QWhatsThis::add(sourceCheckBox,tr("Toggle source window\n\nNot implemented in this version\nPlease use the command line arguments"));
	connect(sourceCheckBox, SIGNAL(toggled(bool)), this, SLOT(slotSource(bool)));

	sourceSpinBox = new QSpinBox(-1, config->sourceId, 1, frame, "sourceSpinBox");
	sourceSpinBox->setGeometry(QRect((int)((width-65)/2), 25, 30, 20));
	sourceSpinBox->setValue(config->sourceId);
	QWhatsThis::add(sourceSpinBox,tr("Source Id of this window"));
	connect(sourceSpinBox, SIGNAL(valueChanged(int)), this, SLOT(slotSourceId(int)));
	if(config->source) sourceSpinBox->setEnabled(false);

	if(config->source) positionSpinBox = new QSpinBox(0, 0, 1, frame, "positionSpinBox");
	else positionSpinBox = new QSpinBox(1, config->position, 1, frame, "positionSpinBox");
	positionSpinBox->setGeometry(QRect((int)((width-65)/2), 48, 30, 20));
	positionSpinBox->setValue(config->position);
	QWhatsThis::add(positionSpinBox,tr("Position of this window"));
	connect(positionSpinBox, SIGNAL(valueChanged(int)), this, SLOT(slotPosition(int)));
	if(config->source) positionSpinBox->setEnabled(false);

	/* text labels */
	sourceTextLabel = new QLabel(frame, "sourceTextLabel");
	sourceTextLabel->setGeometry(QRect((int)((width-65)/2)+35, 25, 30, 20));
	sourceTextLabel->setText(trUtf8("SrcId"));
	positionTextLabel = new QLabel(frame, "positionTextLabel");
	positionTextLabel->setGeometry(QRect((int)((width-65)/2)+35, 48, 30, 20));
	positionTextLabel->setText(trUtf8("Posn"));

	modified = false;
}

OptWidget::~OptWidget() {
}

void OptWidget::slotSource(bool on) {
	modified = true;
	if(on) {
		positionSpinBox->setMinValue(0);
		positionSpinBox->setMaxValue(0);
		positionSpinBox->setValue(0);
	}
	else {
		positionSpinBox->setMinValue(1);
		positionSpinBox->setMaxValue(numWindows);
	}
	positionSpinBox->setEnabled(!on);
	sourceSpinBox->setEnabled(!on);
}

void OptWidget::slotSourceId(int value) {
	modified = true;
}

void OptWidget::slotPosition(int value) {
	modified = true;
}

improvConfig::widgetConfig *OptWidget::getConfig(void) {
	improvConfig::widgetConfig *config;
	config = (improvConfig::widgetConfig *)malloc(sizeof(improvConfig::widgetConfig));
	config->id = this->id;
	config->col = this->col;
	config->row = this->row;
	config->position = this->positionSpinBox->value();
	config->source = this->sourceCheckBox->isChecked();
	config->sourceId = this->sourceSpinBox->value();
	return config;	
}

bool OptWidget::getSource(void) {
	return sourceCheckBox->isChecked();
}

int OptWidget::getSourceId(void) {
	return sourceSpinBox->value();
}

int OptWidget::getPosition(void) {
	return positionSpinBox->value();
}

void OptWidget::setNumWindows(int num) {
	numWindows = num;
	positionSpinBox->setMaxValue(num);
}

void OptWidget::setNumSources(int num) {
	numSources = num;
	sourceSpinBox->setMaxValue(num-1);
}

bool OptWidget::isModified(void) {
	return modified;
}

