/***************************************************************************
                         ImprovQTOpt.h  -  description
                             -------------------
    begin                :
    copyright            : (C) 2002 by Leon Koch
    email                : koch-la@ee.uwa.edu.au
 ***************************************************************************/

#ifndef IMPROVQTOPT_H
#define IMPROVQTOPT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// QT includes
#include <qvariant.h>
#include <qdialog.h>
#include <qspinbox.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qrect.h>
#include <qcheckbox.h>

#include "Improv.h"
#include "ImprovQT.h"
#include "improvConfig.h"

class OptWidget : public QWidget
{
	Q_OBJECT

	public:
		OptWidget(QWidget *parent=0, const char *name=0, improvConfig::widgetConfig *config=0, int width=0, int height=0);
		~OptWidget();
		improvConfig::widgetConfig *getConfig(void);
		bool getSource(void);
		int getSourceId(void);
		int getPosition(void);
		void setNumWindows(int num);
		void setNumSources(int num);
		bool isModified(void);
	public slots:
		void slotSource(bool value);
		void slotSourceId(int value);
		void slotPosition(int value);
	private:
		int id;
		int col;
		int row;
		bool modified;
		int numWindows;
		int numSources;
		QCheckBox* sourceCheckBox;
		QSpinBox* sourceSpinBox;
		QSpinBox* positionSpinBox;
};

class ImprovQTOpt : public QDialog
{
  Q_OBJECT

	public:
		ImprovQTOpt(QWidget *parent=0, const char *name=0, improvConfig *config=0);
    ~ImprovQTOpt();
	public slots:
		void slotOkButton();
		void slotCancelButton();
		void slotPluginButton();
		void slotSequenceButton();
		void slotWindowHeight(int value);
		void slotWindowWidth(int value);
		void slotNumWindows(int value);
	protected:
		//void closeEvent(QCloseEvent * e);
	private:
 		QSpinBox* windowWidth;
		QSpinBox* windowHeight;
		QSpinBox* numWindows;
		QSpinBox* numSources;

		QPushButton* okButton;
		QPushButton* cancelButton;
		QPushButton* pluginButton;
		QPushButton* sequenceButton;

		QLineEdit* pluginLineEdit;
		QLineEdit* sequenceLineEdit;

		QComboBox* cameraComboBox;

		QFrame *frame;

		OptWidget **optWidgets;
};

#endif
