//  Constructs a Popup menu from a plugin

#ifndef PLUGIN_MENU_H
#define PLUGIN_MENU_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// QT includes
#include <qobject.h>
#include <qvaluelist.h>
#include <qstringlist.h>
#include <qpopupmenu.h>

#include "plugin.h"

class PluginMenu : public QObject
{
	Q_OBJECT
	public:
		typedef struct
		{
			QString* name;
			QString* category;
			int menuId;

			Plugin* plugin;
			int opId;

			int inputCount;
			int numParams;
			QStringList* paramNames;
			pluginResultType resultType;
			size_t resultSize;
		} PluginOp;

		PluginMenu(void);
		~PluginMenu(void);

		/** Add a plugin's items to the popup menu  */
		int addPlugin(Plugin *p);
		int getPluginCount(void);
		QPopupMenu* getMainMenu(void);
		void printInfo(void);
		PluginOp* getPluginOp(int index);
		int getUniqueId(int index);

	protected:
		int pluginCount;
		QPopupMenu*  mainMenu;
		QStringList             categoryList;
		QValueList<PluginOp*>   pluginList;
		QValueList<QPopupMenu*> categoryMenuList;

	protected slots:
		void activated(int id);
};

#endif

