#ifndef SRCWIDGET_H
#define SRCWIDGET_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <dirent.h>

// QT includes
#include <qwidget.h>
#include <qpixmap.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qimage.h>
#include <qvbox.h>
#include <qlabel.h>
#include <qmessagebox.h>

#include "PixWidget.h"

#include "FW/labImage.h"
#include "imageSeq.h"

#define CAMERASTRING "Camera"

class SrcWidget : public QWidget
{
	Q_OBJECT

	public:
		SrcWidget( QWidget *parent, const char *name, int id, int sourceId);
		~SrcWidget(void);
		void tick(int numFrames=1);

		Picture* getCurrent(void);
		bool isReady(void);

		int getId(void);
		int getSourceId(void);
		
		void setSrcEnabled(bool value);
	
		void reload(bool sequencesAsWell);
		imageSeq *getImageSeq(void);
		void seq_select(int item);

	public slots:
		void seq_select(const QString&);
	
	protected:
		static int file_select(const struct dirent *entry);

	private:
		int          id;       // unique across seq + src widgets
		int          sourceId; // unique for all src widgets
		PixWidget*   pixWidget;
		QPushButton* popupButton;
		QListBox*    listBox;
		QBoxLayout*  layout;
		imageSeq*    imageSequence;
};

#endif

