#ifndef IMPROV_PLUGIN_H
#define IMPROV_PLUGIN_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "FW/labImage.h"

#define WHITE 255
#define BLACK 0

#ifndef MAX
#define MAX(a,b) (a>b?a:b)
#endif

#ifndef MIN
#define MIN(a,b) ((a)>=(b)?(b):(a))
#endif

#ifndef _BYTE
#define _BYTE
typedef unsigned char BYTE;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* These are the possible data types that can be returned
 *  by a plugin, in addition to the processed image.
 */
typedef enum {
	TEXT,
	INT,
	FLOAT,
	NORESULT
} pluginResultType;

typedef enum {
	WRONGFORMAT,
	TOOLARGE,
	NOERROR
} pluginErrorType;

/*  Instance data for the plugin is stored in an IP_Handle type */
typedef void* IP_Handle;

/*  A plugin may aggregate several Ops  */
typedef struct _IP_Op {
	/*  Image processing category and operation name  */
	const char* Category;
	const char* Operation;
	int         Index;
	int					InputCount;

	unsigned long ParamCount;
	char**        ParamNames;

	pluginResultType resultType;
	size_t resultSize;

	/*  image processing function  
	 *  takes initialized IP_Handle, array of inputs, single (init'd) output and 
	 *  output parameters  */
	void (*process)(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);
} IP_Op;

typedef struct _IP_Descriptor {
	/*  Unique Id number  */
	unsigned long UniqueId;

	/*  Meta information about the plugin  */
	const char* Name;
	const char* Maker;
	const char* Copyright;
	const char* Comment;

	/*  Number of operations provided by the plugin  */
	unsigned long OpCount;
	/*  An array of operations, from 0 to OpCount-1 */
	IP_Op* Ops;
} IP_Descriptor;

IP_Handle  IP_init(void);
const IP_Descriptor* IP_Descriptor_get(unsigned long Index);
typedef const IP_Descriptor* (*IP_Descriptor_Function)(unsigned long Index);

#ifdef __cplusplus
}
#endif

#endif  // #ifndef IMPROV_PLUGIN_H

