/**
 * Abstract image processing plugin class
 */

#ifndef PLUGIN_H
#define PLUGIN_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "FW/labImage.h"
#include "improv_plugin.h"

class Plugin
{
	public:
		Plugin(void) {}
		virtual ~Plugin(void) {}

		/** Process image using operation referenced by Id  */
		virtual void processId(int id, Picture **p_in, Picture *p_out, float *params, void *result) = 0;
		/** Print plugin information to stdout */
		virtual void printInfo(void) = 0;
		virtual void listOps(void) = 0;

		virtual bool isReady(void) = 0;

		virtual unsigned int  getNumOps(void) = 0;
		virtual bool getOpInfo(int id, char** category, char** name, unsigned int* num_inputs, unsigned int* num_params, char*** param_names, pluginResultType *resultType, size_t *resultSize) = 0;
		virtual int getUniqueId(void) = 0;
		virtual const char *getFileName(void) = 0;

	protected:
		bool ready;
};

#endif

