/* AnimThread.h
 * Last modified:
 * Authors: Daniel Venkitachalam <venki-d@ee.uwa.edu.au>
 *          Leon Koch <leon@redfishsoftware.com.au>
 */
/** @class AnimThread
 * Image processing play thread.
 */

#ifndef ANIMTHREAD_H
#define ANIMTHREAD_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/time.h>
#include <time.h>

// QT includes
#include <qthread.h>
#include <qapplication.h>

#include "PixWidget.h"
#include "imageSeq.h"
#include "SrcWidget.h"

// Number of samples to average for frames per second
#define NUMPOINTS 4

class AnimThread : public QThread
{
	public:
		/** Begin execution of the thread */
		void run();
		/** Set the desired frame for the application.
		 * @param fps Desired frame rate, per second.
		 */
		void setFPS(int fps);
		/** Toggle unlimited frame rate mode.
		 * @param toggle
		 */
		void setUnlimitedFPS(bool toggle);

	private:
		/** The inverse value of the desired frame rate. */
		int inv_fps;
		/** Unlimited frame rate mode boolean. */
		bool unlimited;

};

#endif
