#include "../FW/labImage.h"
#include "multithres.h"


#define NTHMAX 		126             /* maximale Schwellenanzahl*/
#define HISTO_GROESSE	10000		/* Histogram Grsse */

Picture *mehrschwellen(Picture *p_image,
		       unsigned int *anzahl_schwellen,
		       int OBERGRENZE,		
		       int UNTERGRENZE,		
		       int grauwerte[])  
{ 
  
  unsigned int histogram[HISTO_GROESSE];
  short schwellwerte[NTHMAX];	
  int i;
  Picture *p_img2;
   
  for(i=0;i<HISTO_GROESSE;i++)
    {
      histogram[i]=0;  
    }
    
  for(i=0;i<NTHMAX;i++)
    {
      schwellwerte[i]=0;  
    }

  if(*anzahl_schwellen>NTHMAX)
    {
      fprintf(stderr," Anzahl der Schwellen zu gross!\n");
    }
    
  /* Bild bearbeiten */
  histogram_erstellen(p_image,OBERGRENZE,UNTERGRENZE,histogram);
  
  schwellwerte_berechnen(p_image,histogram,
			 OBERGRENZE,UNTERGRENZE,anzahl_schwellen,
			 schwellwerte);
  
  p_img2 = binarisierung(p_image,schwellwerte,anzahl_schwellen,grauwerte);
  
  return p_img2;
}


void histogram_erstellen(Picture *p_image,
			 int OBERGRENZE,
			 int UNTERGRENZE,
			 unsigned int histogram[])
{
  
  unsigned int i,j;
  short akt;
  
  unsigned char *data;
  
  data=(unsigned char *) p_image->data;		/*Data - Pointer erhalten*/
  
  

  
  for(i=0;i < p_image->width;i++)
    {
      for(j=0;j < p_image->height;j++)
	{
	  akt=*data++;				/*Alle Grauwerte durchgehen*/
	  
	  if(akt>OBERGRENZE)			/* Werte abschneiden (oben) */
	    akt=(short)OBERGRENZE;			
	  
	  if(akt<UNTERGRENZE)			/* Werte abschneiden (unten) */
	    akt=(short)UNTERGRENZE;
	  
	  histogram[akt]++;			/*Histogram schreiben*/
	}
    }
}

void schwellwerte_berechnen(Picture *p_image,
			    unsigned int histogram[],
			    int OBERGRENZE,
			    int UNTERGRENZE,
			    unsigned int *anzahl,
			    short schwellwerte[])
{
  
  unsigned int step,akku=0,s=0;
  short i;
  
  step=(p_image->width*p_image->height)/(*anzahl+1);	/* Gleichverteilung */	
    for(i=(short)UNTERGRENZE;i<(short)OBERGRENZE;i++)
      {
      akku+=histogram[i];     	           
      
      if(akku>step)
	{
	  schwellwerte[s]=i;
	  s++;
	  akku=0;		
	}				   

    }
  
  if(s<*anzahl)
    {	
      //fprintf(stdout,"\n Es konnnten nicht mehr als %d Schwellen gelegt werden!\n",s);
      *anzahl=s;	
      
    }
  
}

Picture *binarisierung(Picture *p_image,
		       short schwellwerte[], 
		       unsigned int *anzahl,
		       int grauwerte[]
		     )
{
  
  Picture *p_img2;
  unsigned int i,j;
  int k;
  unsigned char *data;
  unsigned char *data_img2;
  short akt;
	
  /* Schnittbild initialisieren*/
  p_img2=newImage();
  setImageType(p_img2, pix_grey);
  resizeImage(p_img2,p_image->width,p_image->height);
  
  data_img2 = (unsigned char *) p_img2->data;	
  data      = (unsigned char *) p_image->data;
  
  for(k=(*anzahl-1);k>=0;k--)
    grauwerte[k]=( (255-(*anzahl+1))/(*anzahl))*(k+1);
  
  /* Durch das ganze Bild fahren */
  for(i=0;i < p_image->width;i++)				
    {
      for(j=0;j < p_image->height;j++)
	{
	  akt=*data++;
	  
	  for(k=(*anzahl-1);k>=0;k--)			
	    {	
	      if(akt>=schwellwerte[k])
		{  
		  *data_img2=(unsigned char) grauwerte[k];
		  break;
		}			
	      else
		*data_img2=0;
	    }
	  
	  (data_img2)++;
	}
      
    }
  
  return p_img2;
}


