/**********************************************************************/
/* labFont.c                                                          */
/* File for Fontusage (used in drawStringInImage)                     */
/* used to deliver easy usage of fonts created with the tool          */
/* "getfont" (UNIX only)                                              */
/*                                                                    */
/* Author: Frank Lindner                                              */
/* Date:   25.05.99                                                   */
/* Documentation: See labFont.h                                       */
/**********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "labFont.h"

/**********************************************************************/
/**********************************************************************/

MyFont *newMyFont()
{
  int ii;               /*Countervariable                             */
  MyFont *p_font;       /*Font to be allocated                        */
  
  if(!(p_font = (MyFont *)malloc(sizeof(MyFont))))
  {
    fprintf(stderr, "No Space to malloc MyFont\n");
    return(NULL);
  }
  for(ii = 0; ii < 255; ii++) p_font->p_chars[ii] = NULL;
  return(p_font);
}

/**********************************************************************/
/**********************************************************************/

Picture *getCharImage(MyFont *p_font, unsigned char c)
{
  if(!p_font)        return(NULL);
  return(p_font->p_chars[(int)c]);
}

/**********************************************************************/
/**********************************************************************/

int getFontCharWidth(MyFont *p_font, unsigned char c)
{
  if(!p_font)                            return(0);
  if(p_font->p_chars[(int)c] == NULL)    return(0);
  return(p_font->p_chars[(int)c]->width);
}

/**********************************************************************/
/**********************************************************************/

int getFontCharHeight(MyFont *p_font)
{
  int ii;           /*Countervariable                                */
  if(!p_font)       return(0);
  for(ii = 0; ii < 255; ii++)
  {
    if(p_font->p_chars[ii])
    {
      return(p_font->p_chars[ii]->height);
    }
  }
  return(0);
}

/**********************************************************************/
/**********************************************************************/

int getFontStringWidth(MyFont *p_font, char *p_string, int spacew)
{
  int ii;               /*Countervariable                            */
  int length = 0;       /*Width of String in Pixels                  */
  if(!p_font || !p_string) return(0);
  for(ii = 0; ii < (int)strlen(p_string); ii++)
  {
    if(p_font->p_chars[(unsigned char)p_string[ii]]) 
    {
      length += p_font->p_chars[(unsigned char)p_string[ii]]->width;
      length += spacew;
    }
  }
  return(length);
}

/**********************************************************************/
/**********************************************************************/

int saveFont(char *p_outname, MyFont *p_font)
{
  int   ii;           /*Countervariable                               */
  FILE *p_outfile;    /*Filename of the Font                          */
  
  if(!p_outname || !p_font) return(0);
  if(!(p_outfile = fopen(p_outname, "wb")))
  {
    fprintf(stderr, "Can't open %s to write Font\n", p_outname);
    return(0);
  }
  for(ii = 0; ii < 256; ii++)
  {
    if(p_font->p_chars[ii]) /*only if char in Font*/
    {
      fprintf(p_outfile, "\n%d %d\n", p_font->p_chars[ii]->width,
                                       p_font->p_chars[ii]->height);
      fwrite(p_font->p_chars[ii]->data, sizeof(unsigned char), 
                            p_font->p_chars[ii]->width*
                            p_font->p_chars[ii]->height,p_outfile);
    }
    else /*empty Images*/
    {
      fprintf(p_outfile, "\n%d %d\n", 0,0);
    }
  }
  fclose(p_outfile);
  return(1);
}

/**********************************************************************/
/**********************************************************************/

MyFont *loadFont(char *p_indir, char *p_praefix)
{
  char    *p_inname;      /*Name of the Fontfile                      */
  MyFont  *p_font;        /*Font to be loaded                         */
  
  if(!p_indir || !p_praefix)  return(NULL);
  if(!strlen(p_indir))        return(NULL);
  /* 6 = '/.fnt\0' */
  if(!(p_inname = (char *)malloc(strlen(p_indir) + 
                             strlen(p_praefix) + 6))) return(NULL);

  strcpy(p_inname, p_indir);
#ifdef IS_UNIX 
  if(p_inname[strlen(p_inname)-1] != '/')
    strcat(p_inname, "/");
#else
  if(p_inname[strlen(p_inname)-1] != '\\')
    strcat(p_inname, "\\");  
#endif
  sprintf(p_inname, "%s%s.fnt", p_inname, p_praefix);
  p_font = loadFont2(p_inname);
  free(p_inname);
  return(p_font);
}

/**********************************************************************/
/**********************************************************************/

MyFont *loadFont2(char *p_inname)
{
  int     ii;             /*Countervariable                           */
  int     anz     = 0;    /*Number of Characters found in Font        */
  FILE   *p_infile;       /*File containing the Font                  */
  MyFont *p_font;         /*Font to be loaded                         */
  int     width;          /*Width of a single Character               */
  int     height;         /*Height of a single Character              */
  
  if(!p_inname) return(0);
  if(!(p_infile = fopen(p_inname, "rb")))
  {
    fprintf(stderr, "Can't open %s to read Font\n", p_inname);
    return(0);
  }
  if(!(p_font = newMyFont())) return(NULL);
  
  for(ii = 0; ii < 256; ii++)
  {
    if(!(fscanf(p_infile, "\n%d %d\n", &width, &height)))
    {
       fprintf(stderr, "Unexpected End of Fontfile in Char %d\n", ii);
       return(0);
    }
    if(width && height)/*image is to be expected*/
    {
      if(!(p_font->p_chars[ii] = newImage()))
      {
        fprintf(stderr, "No Space for Fontchar %d left\n", ii);
        return(NULL);
      }
      p_font->p_chars[ii]->format = pix_grey;
      if(!(resizeImage(p_font->p_chars[ii], width, height)))
      {
        fprintf(stderr, "No Space for Fontchar %d left\n", ii);
        return(NULL);
      }
      if((fread(p_font->p_chars[ii]->data, sizeof(unsigned char), 
                width*height, p_infile)) < (unsigned int)(width*height))
      {
        fprintf(stderr, "Not enough Data for Char %d\n", ii);
        return(NULL);
      }        
      anz++;
    }
    /*else: No Image -> read next width and height*/
  }
  fclose(p_infile);
  if(anz == 0) fprintf(stderr, "No Char found in font %s\n", p_inname);
  return(p_font);
}

