#ifndef IPL_PLUGIN_H
#define IPL_PLUGIN_H

#if defined (__cplusplus)
extern "C" {
#endif

#define MAX_IMAGE_SIZE (320*240)
#define MAX_CONTOUR  1000

/*  Edges  */
pluginReturnType IPL_sobel(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
pluginReturnType IPL_laplace(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
pluginReturnType IPL_corner(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);

/*  General  */
pluginReturnType IPL_min(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
pluginReturnType IPL_max(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
pluginReturnType IPL_mean(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
pluginReturnType IPL_median(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
pluginReturnType IPL_identity(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
pluginReturnType IPL_negation(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
pluginReturnType IPL_noise(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
pluginReturnType IPL_show(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
pluginReturnType IPL_difference(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);

/*  Format  */
pluginReturnType IPL_threshold(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
pluginReturnType IPL_gray_stretch(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
pluginReturnType IPL_dither(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
pluginReturnType IPL_col2gray(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
pluginReturnType IPL_HSVValue(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
pluginReturnType IPL_gray_reduce(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);

/*  Advanced  */
pluginReturnType IPL_match_color_range(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);

/*  Region  */
pluginReturnType IPL_region_growing(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
pluginReturnType LK_match_grey_range(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);

/*  Morphology  */
char struc[] = {1, 1, 1, 1, 1, 1, 1, 1, 1};
pluginReturnType IPL_bin_dilation(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
pluginReturnType IPL_bin_erosion(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
pluginReturnType IPL_bin_open(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
pluginReturnType IPL_bin_close(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
pluginReturnType IPL_bin_fill(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
pluginReturnType IPL_bin_connected(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
pluginReturnType IPL_bin_boundary(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
pluginReturnType IPL_bin_skeleton(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);

/*  Combination  */
pluginReturnType IPL_and(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
pluginReturnType IPL_or(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);

/*  Greyscale Morphology  */
pluginReturnType IPL_erosion(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);
pluginReturnType IPL_dilation(IP_Handle instance, Picture **p_imageInputs, Picture *p_imageOut, float *params, void *result);

/*
 * Internal Routines
 */
void IPLi_and(Picture *p_imageIn1, Picture *p_imageIn2, Picture *p_imageOut);
void IPLi_or(Picture *p_imageIn1, Picture *p_imageIn2, Picture *p_imageOut);
int IPLi_equal(Picture *p_imageIn1, Picture *p_imageIn2);
//int IPLi_equal_nobound(Picture *p_image1, Picture *p_image2);
//int IPLi_count_nobound(Picture *p_imageIn, Picture *p_imageOut, BYTE val);
int IPLi_count_nobound(Picture *p_imageIn, BYTE val);
void IPLi_rgbToHsv(double r, double g, double b, double *h, double *s, double *v);
void IPLi_col_invert(BYTE *rgb);
int IPLi_contour(Picture *pIn, Picture *pOut, Point * result, BYTE threshold);
static int IPLi_CheckCircle(int length, Point *contour, Point *cog);
static int IPLi_IsEdge(Picture *pIn, int x, int y, int w, BYTE threshold);
static int IPLi_FollowContour(Picture *pIn, int x, int y, BYTE threshold, Point *points, int maxLength);

#if defined (__cplusplus)
}
#endif

#endif
