/* ImprovQTCamOpt.cpp
 * Last modified:
 * Authors: Leon Koch <leon@redfishsoftware.com.au>
 */

#include "ImprovQTCamOpt.h"
#include "Improv.h"

ImprovQTCamOpt::ImprovQTCamOpt(QWidget* parent, const char* name, imageSeqType type, Camera *_camera, bool modal, WFlags fl)
: QDialog( parent, name, false, WType_TopLevel | WDestructiveClose )
{
	if(!name) setName("ImprovQTCamOpt");

	this->cameraType = type;

	resize( 105, 210 );
	setMinimumSize( QSize( 105, 210 ) );
	setMaximumSize( QSize( 105, 210 ) );
	setCaption(tr( "Camera" ) );

	// static text labels
	brightnessTextLabel = new QLabel( this, "brightnessTextLabel" );
	brightnessTextLabel->setGeometry( QRect( 10, 5, 25, 20 ) );
	brightnessTextLabel->setFocusPolicy( QLabel::NoFocus );
	brightnessTextLabel->setText( tr( "Bri." ) );
	brightnessTextLabel->setAlignment( int( QLabel::AlignCenter ) );
	contrastTextLabel = new QLabel( this, "contrastTextLabel" );
	contrastTextLabel->setGeometry( QRect( 40, 5, 25, 20 ) );
	contrastTextLabel->setFocusPolicy( QLabel::NoFocus );
	contrastTextLabel->setText( tr( "Con." ) );
	contrastTextLabel->setAlignment( int( QLabel::AlignCenter ) );
	saturationTextLabel = new QLabel( this, "saturationTextLabel" );
	saturationTextLabel->setGeometry( QRect( 70, 5, 25, 20 ) );
	saturationTextLabel->setFocusPolicy( QLabel::NoFocus );
	saturationTextLabel->setText( tr( "Sat." ) );
	saturationTextLabel->setAlignment( int( QLabel::AlignCenter ) );

	// changing value labels
	brightnessValueLabel = new QLabel( this, "brightnessValueLabel" );
	brightnessValueLabel->setGeometry( QRect( 10, 25, 25, 20 ) );
	brightnessValueLabel->setFocusPolicy( QLabel::NoFocus );
	brightnessValueLabel->setAlignment( int( QLabel::AlignRight ) );
	brightnessValueLabel->setNum(0);
	contrastValueLabel = new QLabel( this, "contrastValueLabel" );
	contrastValueLabel->setGeometry( QRect( 40, 25, 25, 20 ) );
	contrastValueLabel->setFocusPolicy( QLabel::NoFocus );
	contrastValueLabel->setAlignment( int( QLabel::AlignRight ) );
	contrastValueLabel->setNum(0);
	saturationValueLabel = new QLabel( this, "saturationValueLabel" );
	saturationValueLabel->setGeometry( QRect( 70, 25, 25, 20 ) );
	saturationValueLabel->setFocusPolicy( QLabel::NoFocus );
	saturationValueLabel->setAlignment( int( QLabel::AlignRight ) );
	saturationValueLabel->setNum(0);

	brightnessSlider = new QSlider( this, "brightnessSlider" );
	brightnessSlider->setGeometry( QRect( 10, 50, 25, 145 ) );
	brightnessSlider->setMaxValue( 255 );
	brightnessSlider->setOrientation( QSlider::Vertical );
	QWhatsThis::add(brightnessSlider,tr("Brightness level"));
	connect(brightnessSlider, SIGNAL(valueChanged(int)), this, SLOT(slotBrightnessSlider(int)));
		
	contrastSlider = new QSlider( this, "contrastSlider" );
	contrastSlider->setGeometry( QRect( 40, 50, 25, 145 ) );
	contrastSlider->setMaxValue( 120 );
	contrastSlider->setOrientation( QSlider::Vertical );
	QWhatsThis::add(contrastSlider,tr("Contrast level"));
	connect(contrastSlider, SIGNAL(valueChanged(int)), this, SLOT(slotContrastSlider(int)));
	
	saturationSlider = new QSlider( this, "saturationSlider" );
	saturationSlider->setGeometry( QRect( 70, 50, 25, 145 ) );
	saturationSlider->setMaxValue( 120 );
	saturationSlider->setOrientation( QSlider::Vertical );
	QWhatsThis::add(saturationSlider,tr("Saturation level"));
	connect(saturationSlider, SIGNAL(valueChanged(int)), this, SLOT(slotSaturationSlider(int)));

	setCameraType(type, _camera);

	// signals and slots connections
}

ImprovQTCamOpt::~ImprovQTCamOpt() {
	// no need to delete child widgets, Qt does it all for us
}

imageSeqType ImprovQTCamOpt::getCameraType(void) {
	return cameraType;
}

void ImprovQTCamOpt::setCameraType(imageSeqType type, Camera *_camera) {
	cameraType = type;
	if(type==OTHER) {
		camera = NULL;
		brightnessValueLabel->setNum(0);
		brightnessSlider->setValue(0);
		contrastValueLabel->setNum(0);
		contrastSlider->setValue(0);
		saturationValueLabel->setNum(0);
		saturationSlider->setValue(0);
	}
	else {
		camera = _camera;
		brightnessValueLabel->setNum(camera->getBrightness());
		brightnessSlider->setValue(camera->getBrightness());
		contrastValueLabel->setNum(camera->getContrast());
		contrastSlider->setValue(camera->getContrast());
		saturationValueLabel->setNum(camera->getSaturation());
		saturationSlider->setValue(camera->getSaturation());
	}	
}

int ImprovQTCamOpt::getBrightness(void) {
	return atoi(brightnessValueLabel->text().latin1());
}

int ImprovQTCamOpt::getContrast(void) {
	return atoi(contrastValueLabel->text().latin1());
}

int ImprovQTCamOpt::getSaturation(void) {
	return atoi(saturationValueLabel->text().latin1());
}

void ImprovQTCamOpt::slotBrightnessSlider(int value) {
	brightnessValueLabel->setNum(value);
	if(camera) camera->setBrightness(value);
}

void ImprovQTCamOpt::slotContrastSlider(int value) {
	contrastValueLabel->setNum(value);
	if(camera) camera->setContrast(value);
}

void ImprovQTCamOpt::slotSaturationSlider(int value) {
	saturationValueLabel->setNum(value);
	if(camera) camera->setSaturation(value);
}

void ImprovQTCamOpt::closeEvent(QCloseEvent * e) {
	Improv* improv = Improv::Instance(0, NULL);
	improv->setCamOptOpen(false);
	// we never delete this widget (until exit), only hide/show it
	this->hide();
}
