/* ImprovQTView.cpp
 * Last modified:
 * Authors: Daniel Venkitachalam <venki-d@ee.uwa.edu.au>
 *          Leon Koch <leon@redfishsoftware.com.au>
 */
/* Main widget containing Seq + Src widgets.
 */

#include <assert.h>

#include "SeqWidget.h"
#include "SrcWidget.h"

#include "ImprovQTview.h"
#include "Improv.h"

#include "imageSeq.h"
#include "FW/labImage.h"
#include "improv_plugin.h"

ImprovQTView::ImprovQTView(QWidget *parent) : QWidget(parent)
{
	int numRows, numCols, numSources, numWindows;
	SrcWidget* *srcWidget;
	SeqWidget* *seqWidget;
	improvConfig::widgetConfig *config;
	Improv* improv = Improv::Instance(0, NULL);

	numSources = improv->config->getNumSources();	
	numWindows = improv->config->getNumWindows();
	numCols = improv->config->getNumCols();
	numRows = improv->config->getNumRows();

	// new
//	QFrame *frame;
//	frame = new QFrame(this,"frame");
//	frame->setFrameStyle(QFrame::Raised);
//	frame->setFrameShape(QFrame::Box);
//	frame->setLineWidth(0);
//	frame->setMidLineWidth(0);
//	frame->setMaximumHeight(numRows*(improv->config->getWindowHeight()+100));
//	frame->setMinimumHeight(numRows*(improv->config->getWindowHeight()+100));
//	frame->setMaximumWidth(numCols*improv->config->getWindowWidth());
//	frame->setMinimumWidth(numCols*improv->config->getWindowWidth());
//	frame->setGeometry(QRect(0,0,numCols*improv->config->getWindowWidth(),numRows*improv->config->getWindowHeight()-30));
//	effectGridLayout = new QGridLayout(frame,numRows,numCols);
//	this->setMinimumHeight(frame->height()+30);
//	this->setMinimumWidth(frame->width());
//	StatusWidget *statusBar = new StatusWidget(this);
//	improv->setStatusBar(statusBar);
	// new

	effectGridLayout = new QGridLayout(this,numRows,numCols);

	if(improv->config->numWidgetConfigs()>0) {
		// malloc source widgets
		srcWidget = (SrcWidget **)malloc(sizeof(SrcWidget *) * (numSources));
		if(srcWidget == NULL) {
			fprintf(stderr, "Error: No memory available for source widgets\n");
			return;
		}
		// malloc sequence widgets
		seqWidget = (SeqWidget **)malloc(sizeof(SeqWidget *) * (numWindows-numSources));
		if(seqWidget == NULL) {
			fprintf(stderr, "Error: No memory available for sequence widgets\n");
			return;
		}
		// setup widgets using config + layout details (provided by improvConfig)
		for(int i=0, src=0, seq=0; i<improv->config->numWidgetConfigs(); i++) {
			config = improv->config->getWidgetConfig(i);
			if(config->source) {
				srcWidget[src] = new SrcWidget(this, 0, config->id, config->sourceId);
				//srcWidget[src] = new SrcWidget(frame, 0, config->id, config->sourceId);
				assert(srcWidget);
				improv->addSrcWidget(srcWidget[src]);
				effectGridLayout->addWidget(srcWidget[src],config->row,config->col);
				src++;
			}
			else {
				seqWidget[seq] = new SeqWidget(this, 0, config->id, config->sourceId, config->position);
				//seqWidget[seq] = new SeqWidget(frame, 0, config->id, config->sourceId, config->position);
				improv->addSeqWidget(seqWidget[seq]);
				effectGridLayout->addWidget(seqWidget[seq],config->row,config->col);
				seq++;
			}
		}
	}
	else {
		// no widget details provided... fatal error
		fprintf(stderr,"Error: attempted to create ImprovQTview object without any widget configurations.\n");
		return;
	}
	free(srcWidget);
	free(seqWidget);
}

ImprovQTView::~ImprovQTView() {
	// no need to delete child widgets, Qt does it all for us
}

void ImprovQTView::redraw(void) {
	/** @todo Implement the redraw method of ImprovQTview, which 
	 * should re-create itself, based upon the improvConfig values. */
	this->repaint();
}

void ImprovQTView::reload(void) {
	//int i;
	int numWindows, numExistingWindows;
	//SeqWidget* sw;
	QValueList<SeqWidget*> seqWidgetList;
	QValueList<SrcWidget*> srcWidgetList;
	//QValueList<SeqWidget*>::iterator it;
	Improv* improv = Improv::Instance(0, NULL);
	numWindows = improv->config->getNumWindows();
	seqWidgetList = improv->getSeqWidgetList();
	srcWidgetList = improv->getSrcWidgetList();
	numExistingWindows = seqWidgetList.size() + srcWidgetList.size();

	/** @todo Extend reload() to actually remove SrcWidgets and SeqWidgets from Improv */
/*
	if(numWindows < numExistingWindows) {
		// we'll just delete the ones we don't need
		//seqWidgetList.clear();
		for(i=numWindows;i<numExistingWindows;i++) {
			it = seqWidgetList.at(i);
			improv->removeSeqWidget((*it));	
			//seqWidgetList.remove(it);
			//delete it;
		}
	}
	else if(numWindows < numExistingWindows) {
  	// we need to add some new windows
		for(int i=numExistingWindows; i<numWindows; i++) {
			sw = new SeqWidget(this, 0, i, 0, i+1);
			seqWidgetList.push_back(sw);
			improv->addSeqWidget(sw);
		}
	}
*/
	//printf("successfully updated the number of seq widgets");
	this->redraw();
}

void ImprovQTView::slotDocumentChanged() {
	/** @todo Update the view */
}
