#ifndef LK_PLUGIN_H
#define LK_PLUGIN_H

#if defined (__cplusplus)
extern "C" {
#endif

#define MAX_IMAGE_SIZE (320*240)

/* magic numbers - used to scale the param from (0<=t<=1) */
#define SCALING_BRIGHTNESS  2
#define SCALING_GAMMA      10
#define SCALING_HIGHBOOST   5
#define SCALING_MEANV      18

/* Physical Transformations */
pluginReturnType LK_flip_horizontal(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);
pluginReturnType LK_flip_vertical(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);
pluginReturnType LK_half_resolution(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);
pluginReturnType LK_bit_plane(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);
pluginReturnType LK_remix_colours(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);
pluginReturnType LK_brightness(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);
pluginReturnType LK_contrast(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);
pluginReturnType LK_red(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);
pluginReturnType LK_green(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);
pluginReturnType LK_blue(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);

pluginReturnType LK_hue(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);
pluginReturnType LK_saturation(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);
pluginReturnType LK_intensity(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);

/* Combination */
pluginReturnType LK_xor(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);
pluginReturnType LK_average(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);
pluginReturnType LK_subtraction(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);
pluginReturnType LK_addition(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);
pluginReturnType LK_multiplication(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);
pluginReturnType LK_division(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);
pluginReturnType LK_lighten(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);
pluginReturnType LK_darken(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);

/* Spatial Filters */
pluginReturnType LK_highboost3(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);
pluginReturnType LK_meanV(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);
pluginReturnType LK_perwitt3(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);
pluginReturnType LK_sobel3(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);

/* Frequence Domain Filters */
pluginReturnType LK_fft(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);

/* Advanced */
pluginReturnType LK_match_grey_range(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);
pluginReturnType LK_intensityslice(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);
pluginReturnType LK_hblur(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);

/* Binary images */
pluginReturnType LK_labelobjects(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);
pluginReturnType LK_labelobjects_wr(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);
pluginReturnType LK_object_centroid(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);
pluginReturnType LK_minimum_inertia(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);
pluginReturnType LK_objectvolume(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);

/* Stereo Matching */
pluginReturnType LK_stereoLocal(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);
pluginReturnType LK_stereoLocal_bidirectional(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);
pluginReturnType LK_stereoCorrelation(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);

/* Test function */
pluginReturnType LK_test(IP_Handle instance, Picture **in, Picture *out, float *params, void *result);

/* Internal Functions */
void LKi_spatialmask(Picture *in, Picture *out, int xsize, int ysize, float *mask, int scale);
void LKi_derivativemask(Picture *in, Picture *out, int xsize, int ysize, float *xmask, float *ymask, int scale);
void LKi_fft(Picture *in, Picture *out);
void LKi_xor(Picture *in1, Picture *in2, Picture *out);
int  powerOfTwo(int x);            /* If x is a power of two, return 1, else return 0 */
int  nextHighestPowerOfTwo(int x); /* Finds the closest power of two, greater than x */
int  LKi_labelobjects(Picture *in, Picture *out);
void LKi_followobject(int i, int object, Picture *in, Picture *out);

int LKi_similarity(Picture *left, Picture *right, int leftPoint, int rightPoint, int xsize, int ysize);
int LKi_correlation(Picture *left, Picture *right, int leftPoint, int rightPoint, int xsize, int ysize);
int LKi_correlationcoefficient(Picture *left, Picture *right, int leftPoint, int rightPoint, int xsize, int ysize, int wbar);

#if defined (__cplusplus)
}
#endif

#endif

