/* Main.cpp
 * Last modified:
 * Authors: Daniel Venkitachalam <venki-d@ee.uwa.edu.au>
 *          Leon Koch <leon@redfishsoftware.com.au>
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// QT includes
#include <qapplication.h>
#include <qfont.h>
#include <qstring.h>
#include <qtextcodec.h>
#include <qtranslator.h>
#include <qwindowsstyle.h>
//#include <qplatinumstyle.h>
#include <qstatusbar.h>
#include <qobject.h>

#include "Improv.h"
#include "ImprovQT.h"

int main(int argc, char *argv[])
{
	QApplication a(argc, argv);
	QFont appFont;
	appFont.setStyleHint(QFont::SansSerif);
	//appFont.setStyleHint(QFont::Helvetica);
	//appFont.setPointSize(8); //was 9
	appFont.setPixelSize(9);
	appFont.setFamily("verdana");

	a.setFont(appFont);
	QTranslator tor( 0 );
	puts("ImprovQT " VERSION);

	// Initialise the global state
	Improv* improv;
	improv = Improv::Instance(argc, argv);

	tor.load( QString("improvqt.") + QTextCodec::locale(), "." );
	a.installTranslator( &tor );
	/* uncomment the following line, if you want a Windows 95 look*/
	a.setStyle(new QWindowsStyle());
	//a.setStyle(new QPlatinumStyle());

	ImprovQTApp *improvqt = new ImprovQTApp();

	a.setMainWidget(improvqt);

	improvqt->show();

	// now setup the app, if needed
	if(improv->config->numPluginInstances()>0) {
		improvConfig::pluginInstance *p;
		improvConfig::widgetConfig *w;
		int targetSeqId=-1;
		for(int i=0;i<improv->config->numPluginInstances();i++) {
			p = improv->config->getPluginInstance(i);
			//printf("fn = %d,%d,%d,%d,%s\n", p->row, p->col, p->posn, p->uniqueId, p->name);
			for(int j=0;j<improv->config->numWidgetConfigs();j++) {
				w = improv->config->getWidgetConfig(j);
				if((w->row==p->row)&&(w->col==p->col)) {
					targetSeqId = w->id;
				}
			}
			if(targetSeqId!=-1) {
				if(improv->getSeqWidget(targetSeqId)->addFunction(p->uniqueId,p->name)) {
					if(p->params!=NULL)
						improv->getSeqWidget(targetSeqId)->getPluginItem(p->posn)->setParams(p->params);
				}
			}
		}
		improv->clearSeqSelections();
		improv->disableParamWidget();
	}	

	if(improv->config->getUseSequence()) {
		QValueList<SrcWidget*> srcWidgetList;
		QValueList<SrcWidget*>::iterator it;
		srcWidgetList = improv->getSrcWidgetList();
		for(it = srcWidgetList.begin(); it != srcWidgetList.end(); it++) {
			(*it)->seq_select(QString(improv->config->getUseSequence()));
		}
	}
	else {
		improv->getSrcWidget(0)->seq_select(QObject::tr(CAMERASTRING));
		if(improv->getSrcWidget(0)->isReady()) {
			improvqt->slotAnimPlay();
		}
		else {
			improv->getSrcWidget(0)->seq_select(1);
		}
	}
	if(improv->getSrcWidget(0)->isReady()) {
		improvqt->slotAnimPlay();
	}
	
	//printf("MainWindow: Width %d, Height %d\n", improvqt->width(), improvqt->height());

	// TOFIX: hack to get the QMainWindow to include the status bar
	improvqt->setMinimumHeight(improvqt->height()+22);
	//improvqt->resize(improvqt->width(),improvqt->height()+22);
	//printf("MainWindow: Width %d, Height %d\n", improvqt->width(), improvqt->height());

	//printf("MainWindow: Width %d, Height %d\n", improvqt->minimumWidth(), improvqt->minimumHeight());
	
	return a.exec();
}

// int printf(const char* format, ...)
// {
// 	Improv* improv = Improv::Instance();
// 	static char temp[1024];
// 	va_list vargs;
// 	int count;
// 
// 	va_start(vargs, format);
// 	count = vsnprintf(temp, 1024, format, vargs);
// 	va_end(vargs);
// 
// 	// improv->text_info->value(temp);
// 	if(improv->statusBarReady() == true)
// 		improv->setStatusMessage(temp);
// 	else
// 		printf(temp);
// 
// 	return count;
// }

