#if defined(__cplusplus)
extern "C" { 
#endif

#include "../FW/labImage.h"  
#include "mathmi.h"

#ifndef _Vec_Field
#define _Vec_Field
  typedef struct {
    float          *u;
    float          *v;
    unsigned char  *valid;
    
    unsigned int   width;
    unsigned int   height;
     
    unsigned int   xoffset;
    unsigned int   yoffset;
    
    unsigned int   datasize;
  } vec_field;
#endif


  
  vec_field *allocVec_field();
  vec_field *initVec_field(vec_field *field);
  vec_field *newVec_field();
  
  int resizeVec_field(vec_field *field, 
		      unsigned int width, 
		      unsigned int height,
		      unsigned int xoffset,
		      unsigned int yoffset );
  
  void freeVec_field(vec_field *field);
  
  void clearVec_field(vec_field *field);
  
  vec_field *copy_vec_field(vec_field *in_field);

  void draw_motion_field(Picture  *p_image, 
			 vec_field *field, 
			 int draw_mode, int normalize,
			 int stepx, int stepy); 
  
  int plotting_ego(int *counter,
		   float foe_x,float foe_y,
		   float foe_x_kal,float foe_y_kal,
		   float Omx_est, float Omy_est, float Omz_est,
		   float Omx_est_kal,float Omy_est_kal,float Omz_est_kal,
		   int force_plot);
  
  int draw_rotation(Picture *p_output,
		    float Omx, float Omy, float Omz, 
		    int factor, float tresh, int size);
  
  int draw_foe(Picture *p_output, float foe_x_kal, float foe_y_kal);
  int draw_foe_bw(Picture *p_output, float foe_x_kal, float foe_y_kal);
  
  Picture *subsample_pic(Picture *p_input, Picture *p_output,
			 int factor,int nr);
  
#if defined(__cplusplus)
       }
#endif
