/* PixWidget.h
 * Last modified: 
 * Authors: Daniel Venkitachalam <venki-d@ee.uwa.edu.au>
 *          Leon Koch <leon@redfishsoftware.com.au>
 */
/** @class PixWidget
 * A double buffered widget for displaying pixmaps.
 * This involves two conversions, and is kinda slow.
 * Should be scraped and replace with a widget that uses raw X code instead of QPixmap.
 */

#ifndef PIXWIDGET_H
#define PIXWIDGET_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <assert.h>

// QT includes
#include <qwidget.h>
#include <qpixmap.h>
#include <qimage.h>
#include <qpainter.h>
#include <qapplication.h>

#include "FW/labImage.h"

class PixWidget : public QWidget
{
	public:
		/** Constructor. */
		PixWidget( QWidget *parent=0, const char *name=0 );
		/** Constructor. */
		PixWidget( QWidget *parent=0, int w=100, int h=30 );
		/** Destructor. Deletes the instance of the class. */
		~PixWidget();

		/** */
		void setPicture(Picture *p_in);
		/** */
		void setScale(bool sc);
		/** */
		void redraw();
		/** */
		void clear();
	
	protected:
		/** */
		void paintEvent(QPaintEvent* event);
		/** */
		int pixwidth;
		/** */
		int pixheight;
		/** */
		int offset_x;
		/** */
		int offset_y;

	private:
		/** */
		QPixmap pixmap;
		/** */
		bool scale;
		/** */
		bool autoscale;

};

#endif

