/* PluginMenu.h
 * Last modified: 
 * Authors: Daniel Venkitachalam <venki-d@ee.uwa.edu.au>
 *          Leon Koch <leon@redfishsoftware.com.au>
 */
/** @class PluginMenu
 * Constructs a Popup menu from a plugin.
 */

#ifndef PLUGIN_MENU_H
#define PLUGIN_MENU_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <vector>

// QT includes
#include <qobject.h>
#include <qvaluelist.h>
#include <qstringlist.h>
#include <qpopupmenu.h>

#include "plugin.h"

using namespace std;

class PluginMenu : public QObject
{
	Q_OBJECT
	public:
		/** @struct PluginOp
		 * The plugin operation structure.
		 */
		typedef struct
		{
			/** */
			QString* name;
			/** */
			QString* category;
			/** */
			int menuId;

			/** */
			Plugin* plugin;
			/** */
			int opId;

			/** */
			int inputCount;
			/** */
			int numParams;
			/** */
			QStringList* paramNames;
			/** */
			pluginResultType resultType;
			/** */
			size_t resultSize;
		} PluginOp;

		/** Constructor. */
		PluginMenu(void);
		/** Destructor. Deletes the instance of the class. */
		~PluginMenu(void);

		/** Add a plugin's items to the popup menu */
		int addPlugin(Plugin *p);
		/** */
		int getPluginCount(void);
		/** */
		QPopupMenu* getMainMenu(void);
		/** */
		void printInfo(void);
		/** */
		PluginOp* getPluginOp(int index);
		/** */
		int getUniqueId(int index);

	protected:
		/** */
		int pluginCount;
		/** */
		QPopupMenu* mainMenu;
		/** */
		QStringList categoryList;
		/** */
		QValueList<PluginOp*> pluginList;
		/** */
		QValueList<QPopupMenu*> categoryMenuList;

	protected slots:
		/** */
		void activated(int id);
		
};

#endif

