/* SeqWidget.h
 * Last modified: 
 * Authors: Daniel Venkitachalam <venki-d@ee.uwa.edu.au>
 *          Leon Koch <leon@redfishsoftware.com.au>
 */

#ifndef SEQWIDGET_H
#define SEQWIDGET_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// QT includes
#include <qwidget.h>
#include <qpixmap.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qimage.h>
#include <qvbox.h>
#include <qlayout.h>
#include <qwhatsthis.h>
#include <qapplication.h>

#include "FW/labImage.h"
#include "PixWidget.h"

/** @class PluginItem
 * This class represents an instance of a plugin operation, as listed in the SeqWidget.
 */
class PluginItem : public QListBoxText
{
	public:
		/** Constructor. */
		PluginItem(const QString& text, int menuId, int bufferId,
				int numParams = 0, QStringList *paramNames = 0);
		/** Destructor. Deletes the instance of the class. */
		~PluginItem();

		/** */
		int getMenuId(void);
		/** */
		int getBufferId(void);
		/** */
		int getNumParams(void);
		/** */
		float* getParams(void);
		/** */
		void setParams(float *params);
		/** */
		QStringList* getParamNames(void);
		/** */
		//void setParam(int param, float value);

	private:
		/** */
		int menuId;
		/** */
		int bufferId;
		/** */
		unsigned int numParams;
		/** */
		float* params;
		/** */
		QStringList* paramNames;

};

/** @class SeqWidget
 * Sequence widget.
 * This widget allows the images to be processed by a list of operations, and then displayed.
 * This class requires plugin menu to be already be created.
 * @see SrcWidget
 */
class SeqWidget : public QWidget
{
	Q_OBJECT

	public:
		/** Constructor. */
		SeqWidget( QWidget *parent, const char *name, int id, int sourceId, int position);
		/** Destructor. Deletes the instance of the class. */
		~SeqWidget();

		/** */
		void copyPicture(Picture *pic);
		/** */
		void tick();
		/** */
		Picture* getCurrent(void);

		/** */
		void setActive(bool value);
		/** */
		bool isActive(void);
		/** */
		int getId(void);

		/** */
		int getPosition(void);
		/** */
		void setPosition(int value);
		/** */
		int getSourceId(void);
		/** */
		void setSourceId(int value);

		/** */
		void redraw(void);
		/** */
		void reload(void);

		/** */
		void disablePopUp(void);
		/** */
		void setPopUpMenu(QPopupMenu* menu);

		/** Clears any highlighting or selection within the list of PluginItems. */
		void clearSelection(void);

		/** Return the numer of PluginItems (image processing functions) contained
		 * within the Sequence widget.
		 * @return The number of PluginItems.
		 */
		int numPluginItems(void);
		/** */
		PluginItem *getPluginItem(int posn);
		/** Return the list of PluginItems (image processing functions) contained
		 * within the Sequence widget.
		 * @return The PluginItems list.
		 * @see PluginItem
		 */
		PluginItem **getPluginItems(void);

		/** Add an Image processing function from the menu to this Sequence widget.
		 * @return True if the function was added, false otherwise.
		 * @param menuId The menuId of the function. To find this Id, use the
		 * functions in Improv to convert from uniqueId/Name to menuId.
		 */
		bool addFunction(int menuId);
		/** Add an Image processing function from the menu to this Sequence widget.
		 * @return True if the function was added, false otherwise.
		 * @param uniqueId The uniqueId of the image processing plugin to use.
		 * @param functionName The name of the function to use.
		 */
		bool addFunction(int uniqueId, char *functionName);

	private:
		/** */
		int id;
		/** The source widget that this widget gets its pictures from. */
		int sourceId;
		/** */
		int position;
		/** */
		bool active;
		/** */
		PixWidget *pixWidget;
		/** */
		QHBox *hbox;
		/** */
		QBoxLayout *layout;
		/** */
		QPushButton *popupButton;
		/** */
		QPushButton *rmButton;
		/** */
		QPushButton *upButton;
		/** */
		QPushButton *downButton;
		/** */
		QPushButton *zoomButton;
		/** */
		QListBox *chainListBox;
		/** */
		Picture *picture;
		/** */
		QPixmap *zoomPixmap;

	private slots:
		/** */
		void popupPressed();
		/** */
		void rmPressed();
		/** */
		void upPressed();
		/** */
		void downPressed();
		/** */
		void itemHighlighted(QListBoxItem* item);
		/** */
		void zoomToggled(bool on);
		
};

#endif

