/* StatusWidget.cpp
 * Last modified:
 * Authors: Leon Koch <leon@redfishsoftware.com.au>
 */

#include "StatusWidget.h"

StatusWidget::StatusWidget(QWidget *parent) : QWidget(parent)
{
//	this->msg = NULL;
//	this->fpsMsg = NULL;
//	this->resultMsg = NULL;
	this->msg = "Ready.";
	this->fpsMsg = "10 FPS";
	this->resultMsg = "good";
	msgBar = new QStatusBar(this,"msgBar");
	msgBar->setSizeGripEnabled(false);
	msgBar->message(tr(msg));
	fpsBar = new QStatusBar(this,"fpsBar");
	fpsBar->setSizeGripEnabled(false);
	fpsBar->message(tr(fpsMsg));
	resultBar = new QStatusBar(this,"resultBar");
	resultBar->setSizeGripEnabled(false);
	resultBar->message(tr(resultMsg));
	effectGridLayout = new QGridLayout(this,1,3,0,0,"effectGridLayout");
	effectGridLayout->setColStretch(0,1);
	effectGridLayout->setColStretch(1,5);
	effectGridLayout->setColStretch(2,1);
	effectGridLayout->addWidget(msgBar,0,0);
	effectGridLayout->addWidget(resultBar,0,1);
	effectGridLayout->addWidget(fpsBar,0,2);
}

StatusWidget::~StatusWidget() {
}

void StatusWidget::setMessage(const char* msg) {
	this->msg = strdup(msg);
}

void StatusWidget::setMessage(const char* msg, int ms) {
	this->msg = strdup(msg);
}

const char *StatusWidget::getMessage(void) {
	return msg;
}

void StatusWidget::setFPSMessage(const char* msg) {
	this->fpsMsg = strdup(msg);
}

const char *StatusWidget::getFPSMessage(void) {
	return fpsMsg;
}

void StatusWidget::setResultMessage(const char* msg) {
	this->resultMsg = strdup(msg);
}

const char *StatusWidget::getResultMessage(void) {
	return resultMsg;
}
