/* V4L2Camera.h
 * Last modified: 
 * Authors: Daniel Venkitachalam <venki-d@ee.uwa.edu.au>
 *          Leon Koch <leon@redfishsoftware.com.au>
 */
/** @class V4L2Camera
 * Implementation of the Camera class for Video 4 Linux 2 devices.
 * @see Camera
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#if defined(HAVE_V4L2)

#ifndef V4L2Camera_H
#define V4L2Camera_H

#include <sys/mman.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <iostream>
#include <string.h>
#include <assert.h>

#include <linux/fs.h>
#include <linux/kernel.h>
#include <linux/videodev2.h>

#include "Camera.h"
#include "FW/labImage.h"

#define DEFAULT_VIDEO_DEVICE  "/dev/video0"
#define VIDEO_STANDARD        "PAL"
#define DEFAULT_IMAGE_WIDTH   160
#define DEFAULT_IMAGE_HEIGHT  120
#define STREAMBUFS            4

class V4L2Camera : public Camera {
	/** @struct vimage
	 * buffers for images
	 */
	struct {
		v4l2_buffer vidbuf;
		char *data;
	} vimage[STREAMBUFS];
	
	/** video device */
	int vid_fd;
	
	/** video format request */
	struct v4l2_format fmt;
  
	/** */
	int pic_size_x;
	/** */
	int pic_size_y;
	/** */
	int pic_size;

	/** */
	int x_offset;
	/** */
	int y_offset;

	/** */
	int autobrightness;
  
	public:
		virtual bool open(void);
		virtual void close(void);
		virtual void read(Picture *p_frame);
		virtual void setBrightness(int value);
		virtual void setContrast(int value);
		virtual void setSaturation(int value);
		virtual void setAutoBrightness(bool on);
		virtual int getBrightness(void);
		virtual int getContrast(void);
		virtual int getSaturation(void);
		virtual bool getAutoBrightness(void);

		virtual bool iscolor(void);
		virtual void get_info(CamInfo *info);
		virtual int map_to_v4l2_format(pixel_format format);
};

#endif /* V4L2Camera_h */

#endif /* HAVE_V4L2 */
