/* improvcl.cpp
 * Authors: Daniel Venkitachalam <venki-d@ee.uwa.edu.au>
 */

/** @todo This file is horribly out of date, and isn't even being 
 * compiled anymore. It needs major work to incorporate all the 
 * changes made to the app, specifically in improvConfig.
 */

#define MAXPARAMS 10

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dlfcn.h>
#include <assert.h>
#include <getopt.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <errno.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "FW/labImage.h"
#include "improv_plugin.h"
#include "ipPlugin.h"
#include "imageSeq.h"
//#include "improvConfig.h"

// Forward declaration
static void print_help(void);

using namespace std;

int main(int argc, char **argv) {
	imageSeq *iseq;
	char c;
	bool listplugins = false;
	bool printmetadata = false;
	bool rescale = false;
	char pluginfile[512];
	bool pluginset = false;
	char* pluginpath;
	char* outputpath = NULL;
	char* prefix = NULL;
	char* inputpath = NULL;
	char outfile[512];
	unsigned int width = 0, height = 0;
	ipPlugin* plugin;
	int opindex = 0;
	Picture *p_out;
	float params[MAXPARAMS];
	int paramcount = 0;
	int i;

	puts("ImprovCL (command-line) " VERSION "\n");
	pluginpath = getenv("IMPROV_PLUGIN_PATH");

	for(i=0; i<MAXPARAMS; i++)
		params[i] = 0.5;

	if( argc == 1 ) {
		puts("Use improvcl -h to display usage help.");
		return 0;
	}
	else
		while( (c = getopt(argc, argv, "lp:o:hi:v:I:aW:H:n:")) != -1 ) {
			switch(c) {
				case 'l':
					listplugins = true;
					break;
				case 'p':
					if(!pluginpath)
						strncpy(pluginfile, optarg, 512);
					else {
						// FIXME fix buffer size
						strncpy(pluginfile, pluginpath, 512);
						strncat(pluginfile, "/", 1);
						strncat(pluginfile, optarg, 512);
					}
					pluginset = true;
					break;
				case 'o':
					outputpath = strdup(optarg);
					break;
				case 'n':
					prefix = strdup(optarg);
					break;
				case 'h':
					print_help();
					return 0;
					break;
				case 'i':
					inputpath = strdup(optarg);
					break;
				case 'I':
					opindex = atoi(optarg);
					break;
				case 'v':
					if(paramcount < MAXPARAMS)
						params[paramcount++] = atof(optarg);
					else
						puts("Maximum parameter count filled! Ignoring a user value.");
					break;
				case 'a':
					printmetadata = true;
					break;
				case 'W':
					width = atoi(optarg);
					rescale = true;
					break;
				case 'H':
					height = atoi(optarg);
					rescale = true;
					break;
				default:
					printf("Warning: ignoring unknown option '%c'\n", c);
					break;
			}
		}

	// Fill in default values if not set
	if( pluginset == false ) {
		if( pluginpath ) {
			strncpy(pluginfile, pluginpath, 512);
			strncat(pluginfile, "/", 1);
		}
		strncat(pluginfile, "libIPL_plugin.so", 512);
	}

	if( outputpath == NULL )
		outputpath = strdup( "output_sequence" );
	if( prefix == NULL )
		prefix = strdup( "output" );

	// printf("DEBUG strcmp: %d\n", strcmp("/home/wct/localroot/lib/improv_plugins/libOpticFlow_plugin.so", pluginfile));
	plugin = new ipPlugin(pluginfile);
//	plugin = new ipPlugin("/home/wct/localroot/lib/improv_plugins/libOpticFlow_plugin.so");
	if(plugin->isReady() == false) {
		puts("ipPlugin could not be instantiated!\n");
		return 1;
	}

	if( printmetadata == true )
		plugin->printInfo();

	if( listplugins == true )
		plugin->listOps();

	// No input sequence specified, return
	if( inputpath == NULL )
		return 0;

	iseq = new imageSeq(PIXMAP, inputpath);
	if( iseq->getNumFrames() <= 0 ) {
		printf("Error: No images loaded from path \"%s\".\n", inputpath);
		delete iseq;
		return 1;
	}

	printf("\nUser parameters: ");
	for( i=0; i<paramcount; i++ ) {
		printf("%0.2f ", params[i]);
	}

	putchar('\n');

	if( mkdir(outputpath, 0755) != 0 && errno != EEXIST ) {
		printf("Error creating/accessing directory %s\n", outputpath);
		return 1;
	}

	printf("Using operation %d\n", opindex);

	for( i=0; i<iseq->getNumFrames() && iseq->getCurrent() != NULL ; i++ ) {
		Picture *current;

		current = iseq->getCurrent();
		if( rescale && width == 0 )
			width = current->width;
		if( rescale && height == 0 )
			height = current->height;
		p_out = copyImage(current);	
		plugin->processId(opindex, &current, p_out, params,NULL);
		snprintf(outfile, 512, "%s/%s.%04d.ppm", outputpath, prefix, i);
		if( rescale )
			resizeImage(p_out, width, height);
		saveImage( outfile, p_out );
		iseq->tick();
	}

	putchar('\n');

	delete plugin;	
	return 0;
}

void print_help(void)
{
	puts("\% improvcl [options] plugin\n");
	puts("Options:\n");
	puts(" File selection");
	puts("   -p plugin : use a different plugin file (default: libIPL_plugin.so)");
	puts("   -i path   : process the image sequence in path");
	puts("   -o path   : specify an output path (default: output_sequence)");
	puts("   -n name   : specify an output file name prefix (default: output)\n");
	puts(" Image operations");
	puts("   -I op     : select a plugin operation to apply by index (default: 0)");
	puts("   -v value  : specify a param value (default: 0.5)");
	puts("   -W width  : rescale output image width to specified value in pixels");
	puts("   -H height : rescale output image height to specified value in pixels\n");
	puts(" Information");
	puts("   -a        : print plugin meta-data / information");
	puts("   -l        : list the plugin operations available");
	puts("   -h        : print this help");
//	printf(" Options: -x width  : Set the width of the image frames.\n");
//	printf("          -y height : Set the height of the image frames.\n");
//	printf("          -p path   : Set 'path' as the plugin path.\n");
//	printf("          -s path   : Set 'path' as the sequence path.\n");
//	printf("          -n number : Set the total number of windows.\n");
//	printf("          -i number : Set the number of input windows.\n");
//	printf("          -u name   : Use the image sequence 'name'.\n");
//	printf("          -q        : Use the QuickCam (default is Video 4 Linux).\n");
//	printf("          -v        : Use the Video 4 Linux 2 device.\n");
//	printf("          -c file   : Load configuration from 'file'.\n");
}

