/* ipPlugin.h
 * Last modified: 
 * Authors: Daniel Venkitachalam <venki-d@ee.uwa.edu.au>
 *          Leon Koch <leon@redfishsoftware.com.au>
 */
/** @class ipPlugin
 * Implements the plugin interface using improv image 
 * processing plugins, as defined in improv_plugin.h
 * @see improv_plugin
 */

#ifndef IPPLUGIN_H
#define IPPLUGIN_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <dlfcn.h>
#include <assert.h>
#include <string.h>

#include "improv_plugin.h"
#include "plugin.h"

class ipPlugin : public Plugin
{
	public:
		/** Constructor. */
		ipPlugin(const char* plugin_file);
		/** Destructor. Deletes the instance of the class. */
		~ipPlugin();

		/** */
		pluginReturnType processId(int id, Picture **in, Picture *out, float *params, void *result);
		/** */
		void printInfo(void);
		/** */
		bool isReady(void);
		/** */
		void listOps(void);
		/** */
		unsigned int getNumOps(void);
		/** */
		bool getOpInfo(int id, char** category, char** name, unsigned int* num_inputs, unsigned int* num_params, char*** param_names, pluginResultType *resultType, size_t *resultSize);
		/** */
		int getUniqueId(void);
		/** */
		const char *getFileName(void);

	private:
		/** */
		const char* plugin_file;
		/** */
		void* phandle;
		/** */
		IP_Handle* iphandle;
		/** */
		IP_Descriptor* desc;
		/** */
		int init_plugin(void);
		/** */
		IP_Descriptor* get_plugin_desc(void);
		
};

#endif
