
/**********************************************************************/
/*typedef struct                                                      */
/*{                                                                   */
/*  Image  *p_chars[256]; p_chars[i] is the Picture of one char,      */
/*                        NULL if not set                             */
/*                        Pixel: 0: not set, != 0: Pixel is set(255)  */
/*} MyFont;                                                           */
/**********************************************************************/


/**********************************************************************/
/* Allocates pointer to Struct                                        */
/* In: void                                                           */
/* Out: Font with all chars (Images ) set to NULL                     */
/**********************************************************************/
/*MyFont *newMyFont();                                                */
/**********************************************************************/

/**********************************************************************/
/* returns single char image (original - dont free)                   */
/* In: Font, which char (ISO 8859-1 )                                 */
/* Out: Pointer to the Image depicting the Character c                */
/**********************************************************************/
/*Image  *getCharImage(MyFont *p_font, unsigned char c);              */
/**********************************************************************/

/**********************************************************************/
/* returns the width of one Character without surrounding space       */
/* In: Font, which char (ISO 8859-1 )                                 */
/* Out: width of the Character                                        */
/**********************************************************************/
/*int     getFontCharWidth(MyFont *p_font, unsigned char c);          */
/**********************************************************************/

/**********************************************************************/
/* returns the height of the Font (all Chars have the same height)    */
/* In: Font                                                           */
/* Out: height of the Characters                                      */
/**********************************************************************/
/*int     getFontCharHeight(MyFont *p_font);                          */
/**********************************************************************/

/**********************************************************************/
/* returns the width of a String when printed with this Font          */
/*                                                                    */
/* In: Font, String, the Space between two Characters (the width of   */
/*           the SPACE Character is the width of Char 32 (ISO 8859-1))*/
/* Out: Width of the String (plus one spacew after the last Char)     */
/**********************************************************************/
/*int   getFontStringWidth(MyFont *p_font, char *p_string,int spacew);*/
/**********************************************************************/

/**********************************************************************/
/* Saves one Font to a File in the Format:                            */
/*   for i = 0 : 255                                                  */
/*     \n%d(width) %d(height)\n                                       */
/*     (width*height unsigned chars)                                  */
/*   end                                                              */
/*                                                                    */
/* In: Filename to write into, Font                                   */
/* Out: Success                                                       */
/**********************************************************************/
/*int     saveFont(char *p_outname, MyFont *p_font);                  */
/**********************************************************************/

/**********************************************************************/
/* loads .fnt File (calls loadFont2 after producing the Filename      */
/* Filename: p_indir[/,\\]p_praefix.fnt                               */
/* In: indir, praefix                                                 */
/* Out: Font with all chars fond set to images, all others NULL       */
/**********************************************************************/
/*MyFont *loadFont(char *p_indir, char *p_praefix);                   */
/**********************************************************************/

/**********************************************************************/
/* loads .fnt File                                                    */
/* In: Filename from which to load the font                           */
/* Out: Font with all chars fond set to images, all others NULL       */
/**********************************************************************/
/*MyFont *loadFont2(char *p_inname);                                  */
/**********************************************************************/

#ifndef LABFONT_H
#define LABFONT_H

#include "labImage.h"

#if defined(__cplusplus)
extern "C" { 
#endif

typedef struct
{
  Picture  *p_chars[256]; /*[i] is Picture of one char, NULL if not set */
} MyFont;

MyFont *newMyFont();
Picture *getCharImage(MyFont *p_font, unsigned char c);
int     getFontCharWidth(MyFont *p_font, unsigned char c);
int     getFontCharHeight(MyFont *p_font);
int     getFontStringWidth(MyFont *p_font, char *p_string,int spacew);
int     saveFont(char *p_outname, MyFont *p_font);
MyFont *loadFont(char *p_indir, char *p_praefix);
MyFont *loadFont2(char *p_inname);

#if defined(__cplusplus)
}
#endif

#endif /*#ifndef LABFONT_H*/
