package lgrammar;

import java.awt.*;

public class Projection extends Panel{
	boolean open_yet = false;
	private int  	x0 = 0,
			y0 = 0,
			a  = 1000;
	private TextField t_x0, t_y0, t_a;

	public void init() {
		setLayout(new GridLayout(2, 3));
		setFont(Xui.lgrammarFont);
		t_x0 = new TextField("0", 4);
		t_y0 = new TextField("0", 4);
		t_a  = new TextField("1000", 4); 
		add(new Label("x0"));
		add(new Label("y0"));
		add(new Label("a"));
		add(t_x0);
		add(t_y0);
		add(t_a);
		open_yet = true;
	}
	public void visible(){
		if (open_yet){}
		else {init(); show();
		}
	}
	public void read_in(){
		try {
		    x0 =Integer.valueOf(t_x0.getText()).intValue();
		    }
		catch(Exception e) {
			x0 = 0; // default value
			t_x0.setText(Integer.toString(x0));
			}
		
		try {
		    y0 =Integer.valueOf(t_y0.getText()).intValue();
		    }
		catch(Exception e) {
			y0 = 0; // default value
			t_x0.setText(Integer.toString(y0));
			}
		try {
		    a =Integer.valueOf(t_a.getText()).intValue();
		    }
		catch(Exception e) {
			a = 1000; // default value
			t_a.setText(Integer.toString(y0));
			}
	}

	public void set_default(){
		t_x0.setText("0");
		t_y0.setText("1");
		t_a.setText("1000");
	}
	
	public Point persp(Vector3 d3_point){
	// projects a 3-dimensinal Point into a 2-dimensinal one
		Point point = new Point(1,1); // just a dummy value
		double w = d3_point.z/a+1;
		
		point.x = x0 + (int)(d3_point.x/w);
		point.y = y0 + (int)(d3_point.y/w);
		return point;
	}
		

	public int get_x(){
		return x0;
	}


	public int get_y(){
		return y0;
	}

	public int get_a(){
		return a;
	}

	public void set_values(int x, int y, int a){
		this.a = a;
		this.x0 = x;
		this.y0 = y;
	}
}

/* ************************************************ */

class ProjWin extends Frame{
	Projection proj = null;
	Xui father = null;
	private Button  b_ok = new Button("OK"),
		 	b_cancel = new Button("Cancel");
	private Panel button = new Panel();	

	public ProjWin(Projection proj, Xui father){
		super("Projection");
		this.proj = proj;
		this.father = father;
	}

	public void init(){
		button.setLayout(new FlowLayout());
		button.add(b_ok);
		button.add(b_cancel);
		setLayout(new BorderLayout());
		proj.visible();
		add("North", proj);
		add("South", button);
	}
	public boolean action(Event e, Object o){
		if("OK".equals(o)){
		proj.read_in();
		this.hide();
		this.dispose();
		father.b_proj.enable();
		}
		if("Cancel".equals(o)){
		proj.set_default();
		this.hide();
		father.b_proj.enable();
		this.dispose();
		}
		return true;
	}
}

		





